/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.doxia.module.xhtml;

import java.io.Reader;
import org.codehaus.doxia.parser.ParseException;
import org.codehaus.doxia.parser.Parser;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class XhtmlParser
implements Parser {
    public void parse(Reader reader, Sink sink) throws ParseException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            this.parseXdoc((XmlPullParser)parser, sink);
        }
        catch (Exception ex) {
            throw new ParseException("Error parsing the model.", ex);
        }
    }

    public void parseXdoc(XmlPullParser parser, Sink sink) throws Exception {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("title")) {
                    sink.title();
                } else if (parser.getName().equals("author")) {
                    sink.author();
                } else if (parser.getName().equals("body")) {
                    sink.body();
                } else if (parser.getName().equals("section")) {
                    sink.section1();
                    sink.sectionTitle();
                    sink.text(parser.getAttributeValue(null, "name"));
                    sink.sectionTitle_();
                } else if (parser.getName().equals("p")) {
                    sink.paragraph();
                } else if (parser.getName().equals("source")) {
                    sink.verbatim(true);
                } else if (parser.getName().equals("ul")) {
                    sink.list();
                } else if (parser.getName().equals("ol")) {
                    sink.numberedList(0);
                } else if (parser.getName().equals("li")) {
                    sink.listItem();
                } else if (parser.getName().equals("properties")) {
                    sink.head();
                } else if (parser.getName().equals("b")) {
                    sink.bold();
                } else if (parser.getName().equals("a")) {
                    sink.link(parser.getAttributeValue(null, "href"));
                } else if (parser.getName().equals("table")) {
                    sink.table();
                } else if (parser.getName().equals("tr")) {
                    sink.tableRow();
                } else if (parser.getName().equals("th")) {
                    sink.tableCell();
                } else if (parser.getName().equals("td")) {
                    sink.tableCell();
                }
            } else if (eventType == 3) {
                if (parser.getName().equals("title")) {
                    sink.title_();
                } else if (parser.getName().equals("author")) {
                    sink.author_();
                } else if (parser.getName().equals("body")) {
                    sink.body_();
                } else if (parser.getName().equals("p")) {
                    sink.paragraph_();
                } else if (parser.getName().equals("source")) {
                    sink.verbatim_();
                } else if (parser.getName().equals("ul")) {
                    sink.list_();
                } else if (parser.getName().equals("ol")) {
                    sink.numberedList_();
                } else if (parser.getName().equals("li")) {
                    sink.listItem_();
                } else if (parser.getName().equals("properties")) {
                    sink.head_();
                } else if (parser.getName().equals("b")) {
                    sink.bold_();
                } else if (parser.getName().equals("a")) {
                    sink.link_();
                } else if (parser.getName().equals("table")) {
                    sink.table_();
                } else if (parser.getName().equals("tr")) {
                    sink.tableRow_();
                } else if (parser.getName().equals("th")) {
                    sink.tableCell_();
                } else if (parser.getName().equals("td")) {
                    sink.tableCell_();
                }
            } else if (eventType == 4) {
                sink.text(parser.getText());
            }
            eventType = parser.next();
        }
    }
}

