/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.zhipu.chat.Content;
import dev.langchain4j.model.zhipu.chat.Message;
import dev.langchain4j.model.zhipu.chat.Role;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class UserMessage
implements Message {
    private Role role = Role.USER;
    private Object content;
    private String name;

    public UserMessage(Role role, Object content, String name) {
        this.role = (Role)((Object)Utils.getOrDefault((Object)((Object)role), (Object)((Object)Role.USER)));
        this.content = content;
        this.name = name;
    }

    public static UserMessageBuilder builder() {
        return new UserMessageBuilder();
    }

    public static UserMessage from(String text) {
        return UserMessage.builder().content(text).build();
    }

    public static UserMessage from(List<Content> contents) {
        return UserMessage.builder().content(contents).build();
    }

    public static UserMessage from(Content ... contents) {
        return UserMessage.builder().content(Collections.singletonList(contents)).build();
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class UserMessageBuilder {
        private Role role;
        private Object content;
        private String name;

        UserMessageBuilder() {
        }

        public UserMessageBuilder role(Role role) {
            this.role = role;
            return this;
        }

        public UserMessageBuilder content(Object content) {
            this.content = content;
            return this;
        }

        public UserMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserMessage build() {
            return new UserMessage(this.role, this.content, this.name);
        }
    }
}

