/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.qianfan;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.model.qianfan.QianfanEmbeddingModelNameEnum;
import dev.langchain4j.model.qianfan.client.QianfanClient;
import dev.langchain4j.model.qianfan.client.embedding.EmbeddingRequest;
import dev.langchain4j.model.qianfan.client.embedding.EmbeddingResponse;
import dev.langchain4j.model.qianfan.spi.QianfanEmbeddingModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class QianfanEmbeddingModel
extends DimensionAwareEmbeddingModel {
    private final QianfanClient client;
    private final String baseUrl;
    private final String modelName;
    private final Integer maxRetries;
    private final String user;
    private final String endpoint;

    public QianfanEmbeddingModel(String baseUrl, String apiKey, String secretKey, Integer maxRetries, String modelName, String endpoint, String user, Boolean logRequests, Boolean logResponses, Proxy proxy) {
        if (Utils.isNullOrBlank((String)apiKey) || Utils.isNullOrBlank((String)secretKey)) {
            throw new IllegalArgumentException(" api key and secret key must be defined. It can be generated here: https://console.bce.baidu.com/qianfan/ais/console/applicationConsole/application");
        }
        this.modelName = modelName;
        String string = this.endpoint = Utils.isNullOrBlank((String)endpoint) ? QianfanEmbeddingModelNameEnum.getEndpoint(modelName) : endpoint;
        if (Utils.isNullOrBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Qianfan is no such model name. You can see model name here: https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Nlks5zkzu");
        }
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://aip.baidubce.com");
        this.client = QianfanClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).secretKey(secretKey).logRequests(logRequests).logResponses(logResponses).proxy(proxy).build();
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.user = user;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(texts).model(this.modelName).user(this.user).build();
        EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> this.client.embedding(request, this.endpoint).execute(), (int)this.maxRetries);
        List embeddings = response.data().stream().map(openAiEmbedding -> Embedding.from(openAiEmbedding.embedding())).collect(Collectors.toList());
        return Response.from(embeddings, (TokenUsage)InternalQianfanHelper.tokenUsageFrom(response));
    }

    public static QianfanEmbeddingModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QianfanEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QianfanEmbeddingModelBuilderFactory factory = (QianfanEmbeddingModelBuilderFactory)iterator.next();
            return (QianfanEmbeddingModelBuilder)factory.get();
        }
        return new QianfanEmbeddingModelBuilder();
    }

    public static class QianfanEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String secretKey;
        private Integer maxRetries;
        private String modelName;
        private String endpoint;
        private String user;
        private Boolean logRequests;
        private Boolean logResponses;
        private Proxy proxy;

        public QianfanEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QianfanEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QianfanEmbeddingModelBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public QianfanEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public QianfanEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QianfanEmbeddingModelBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public QianfanEmbeddingModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public QianfanEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public QianfanEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public QianfanEmbeddingModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public QianfanEmbeddingModel build() {
            return new QianfanEmbeddingModel(this.baseUrl, this.apiKey, this.secretKey, this.maxRetries, this.modelName, this.endpoint, this.user, this.logRequests, this.logResponses, this.proxy);
        }

        public String toString() {
            return "QianfanEmbeddingModel.QianfanEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", secretKey=" + this.secretKey + ", maxRetries=" + this.maxRetries + ", modelName=" + this.modelName + ", endpoint=" + this.endpoint + ", user=" + this.user + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", proxy=" + String.valueOf(this.proxy) + ")";
        }
    }
}

