/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding.onnx;

import ai.djl.huggingface.tokenizers.Encoding;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.Tokenizer;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class HuggingFaceTokenizer
implements Tokenizer {
    private final ai.djl.huggingface.tokenizers.HuggingFaceTokenizer tokenizer;

    public HuggingFaceTokenizer() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("padding", "false");
        options.put("truncation", "false");
        this.tokenizer = HuggingFaceTokenizer.createFrom(this.getClass().getResourceAsStream("/bert-tokenizer.json"), options);
    }

    public HuggingFaceTokenizer(Path pathToTokenizer) {
        this(pathToTokenizer, null);
    }

    public HuggingFaceTokenizer(Path pathToTokenizer, Map<String, String> options) {
        try {
            this.tokenizer = HuggingFaceTokenizer.createFrom(Files.newInputStream(pathToTokenizer, new OpenOption[0]), options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HuggingFaceTokenizer(String pathToTokenizer) {
        this(pathToTokenizer, null);
    }

    public HuggingFaceTokenizer(String pathToTokenizer, Map<String, String> options) {
        try {
            this.tokenizer = HuggingFaceTokenizer.createFrom(Files.newInputStream(Paths.get(pathToTokenizer, new String[0]), new OpenOption[0]), options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ai.djl.huggingface.tokenizers.HuggingFaceTokenizer createFrom(InputStream tokenizer, Map<String, String> options) {
        try {
            return ai.djl.huggingface.tokenizers.HuggingFaceTokenizer.newInstance((InputStream)tokenizer, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int estimateTokenCountInText(String text) {
        Encoding encoding = this.tokenizer.encode(text, false, true);
        return encoding.getTokens().length;
    }

    public int estimateTokenCountInMessage(ChatMessage message) {
        return this.estimateTokenCountInText(message.text());
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        int tokens = 0;
        for (ChatMessage message : messages) {
            tokens += this.estimateTokenCountInMessage(message);
        }
        return tokens;
    }

    public int estimateTokenCountInToolSpecifications(Iterable<ToolSpecification> toolSpecifications) {
        throw new RuntimeException("Not applicable");
    }

    public int estimateTokenCountInToolExecutionRequests(Iterable<ToolExecutionRequest> toolExecutionRequests) {
        throw new RuntimeException("Not applicable");
    }
}

