/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.response;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Objects;

@Experimental
public class ChatResponse {
    private final AiMessage aiMessage;
    private final TokenUsage tokenUsage;
    private final FinishReason finishReason;

    private ChatResponse(Builder builder) {
        this.aiMessage = ValidationUtils.ensureNotNull(builder.aiMessage, "aiMessage");
        this.tokenUsage = builder.tokenUsage;
        this.finishReason = builder.finishReason;
    }

    public AiMessage aiMessage() {
        return this.aiMessage;
    }

    public TokenUsage tokenUsage() {
        return this.tokenUsage;
    }

    public FinishReason finishReason() {
        return this.finishReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatResponse that = (ChatResponse)o;
        return Objects.equals(this.aiMessage, that.aiMessage) && Objects.equals(this.tokenUsage, that.tokenUsage) && Objects.equals((Object)this.finishReason, (Object)that.finishReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aiMessage, this.tokenUsage, this.finishReason});
    }

    public String toString() {
        return "ChatResponse { aiMessage = " + String.valueOf(this.aiMessage) + ", tokenUsage = " + String.valueOf(this.tokenUsage) + ", finishReason = " + String.valueOf((Object)this.finishReason) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AiMessage aiMessage;
        private TokenUsage tokenUsage;
        private FinishReason finishReason;

        public Builder aiMessage(AiMessage aiMessage) {
            this.aiMessage = aiMessage;
            return this;
        }

        public Builder tokenUsage(TokenUsage tokenUsage) {
            this.tokenUsage = tokenUsage;
            return this;
        }

        public Builder finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public ChatResponse build() {
            return new ChatResponse(this);
        }
    }
}

