/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class ToolSpecification {
    private final String name;
    private final String description;
    private final JsonObjectSchema parameters;
    @Deprecated(forRemoval=true)
    private final ToolParameters toolParameters;

    private ToolSpecification(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        if (builder.parameters != null && builder.toolParameters != null) {
            throw new IllegalArgumentException("Both (new) JsonObjectSchema and (old) ToolParameters are used to specify tool parameters. Please use only (new) JsonObjectSchema.");
        }
        this.parameters = builder.parameters;
        this.toolParameters = builder.toolParameters;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public JsonObjectSchema parameters() {
        return this.parameters;
    }

    @Deprecated(forRemoval=true)
    public ToolParameters toolParameters() {
        return this.toolParameters;
    }

    public boolean equals(Object another) {
        ToolSpecification ts;
        if (this == another) {
            return true;
        }
        return another instanceof ToolSpecification && this.equalTo(ts = (ToolSpecification)another);
    }

    private boolean equalTo(ToolSpecification another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.parameters, another.parameters) && Objects.equals(this.toolParameters, another.toolParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + Objects.hashCode(this.toolParameters);
        return h;
    }

    public String toString() {
        return "ToolSpecification { name = " + Utils.quoted(this.name) + ", description = " + Utils.quoted(this.description) + ", parameters = " + String.valueOf(this.parameters) + ", toolParameters = " + String.valueOf(this.toolParameters) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private JsonObjectSchema parameters;
        @Deprecated(forRemoval=true)
        private ToolParameters toolParameters;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(JsonObjectSchema parameters) {
            this.parameters = parameters;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder parameters(ToolParameters parameters) {
            this.toolParameters = parameters;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder addParameter(String name, JsonSchemaProperty ... jsonSchemaProperties) {
            return this.addParameter(name, Arrays.asList(jsonSchemaProperties));
        }

        @Deprecated(forRemoval=true)
        public Builder addParameter(String name, Iterable<JsonSchemaProperty> jsonSchemaProperties) {
            this.addOptionalParameter(name, jsonSchemaProperties);
            this.toolParameters.required().add(name);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder addOptionalParameter(String name, JsonSchemaProperty ... jsonSchemaProperties) {
            return this.addOptionalParameter(name, Arrays.asList(jsonSchemaProperties));
        }

        @Deprecated(forRemoval=true)
        public Builder addOptionalParameter(String name, Iterable<JsonSchemaProperty> jsonSchemaProperties) {
            if (this.toolParameters == null) {
                this.toolParameters = ToolParameters.builder().build();
            }
            HashMap<String, Object> jsonSchemaPropertiesMap = new HashMap<String, Object>();
            for (JsonSchemaProperty jsonSchemaProperty : jsonSchemaProperties) {
                jsonSchemaPropertiesMap.put(jsonSchemaProperty.key(), jsonSchemaProperty.value());
            }
            this.toolParameters.properties().put(name, jsonSchemaPropertiesMap);
            return this;
        }

        public ToolSpecification build() {
            return new ToolSpecification(this);
        }
    }
}

