/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.FileMisc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;

class LockFile
implements AutoCloseable {
    final FileOutputStream lock;
    final File lockFile;
    private static final int WAIT_FOR_BUSY = 5000;
    private static final int WAIT_FOR_BUSY_CI = 50000;
    private static final Object LOCK_MONITOR = new Object();
    private static volatile long currentLockingPid = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockFile(File dir) throws IOException {
        FileMisc.mkdirs(dir);
        this.lockFile = new File(dir, ".lock").getCanonicalFile();
        Object object = LOCK_MONITOR;
        synchronized (object) {
            while (this.lockFile.exists()) {
                try {
                    long pid = Long.parseLong(Files.readString(this.lockFile.toPath()).trim());
                    if (pid == ProcessHandle.current().pid()) {
                        LOCK_MONITOR.wait();
                        continue;
                    }
                    int timeout = System.getProperty("lockFileGenerousTimeout") != null ? 50000 : 5000;
                    FileMisc.retry(this.lockFile, f -> {
                        if (f.exists()) {
                            throw new IllegalStateException("P2 operation already in progress, close other clients or delete stale lockfile at " + this.lockFile.getAbsolutePath());
                        }
                    }, timeout);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while waiting for lock", e);
                }
            }
            this.lock = new FileOutputStream(this.lockFile);
            long currentPid = ProcessHandle.current().pid();
            this.lock.write(Long.toString(currentPid).getBytes());
            this.lock.flush();
            currentLockingPid = currentPid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = LOCK_MONITOR;
        synchronized (object) {
            this.lock.close();
            FileMisc.delete(this.lockFile);
            currentLockingPid = -1L;
            LOCK_MONITOR.notifyAll();
        }
    }
}

