/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceInit {
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceInit.class);
    private final TreeMap<String, List<Function<byte[], byte[]>>> modifiers = new TreeMap();

    private void setFileBinary(String subpath, Function<byte[], byte[]> modifier) {
        this.modifiers.computeIfAbsent(subpath, k -> new ArrayList(1)).add(modifier);
    }

    private void setFile(String subpath, Function<String, String> modifier) {
        this.setFileBinary(subpath, bytes -> ((String)modifier.apply(new String((byte[])bytes, StandardCharsets.UTF_8))).getBytes(StandardCharsets.UTF_8));
    }

    public void setProperty(String subpath, String key, String value) {
        this.setFile(subpath, prev -> {
            Properties props = new Properties();
            try {
                props.load(new StringReader((String)prev));
                props.put("eclipse.preferences.version", "1");
                props.put(key, value);
                StringWriter writer = new StringWriter();
                props.store(writer, null);
                return writer.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void copyAllFrom(WorkspaceInit other) {
        for (Map.Entry<String, List<Function<byte[], byte[]>>> modifierList : other.modifiers.entrySet()) {
            for (Function<byte[], byte[]> modifier : modifierList.getValue()) {
                this.setFileBinary(modifierList.getKey(), modifier);
            }
        }
    }

    public void applyTo(File workspaceDir) {
        this.modifiers.forEach((subpath, modifiers) -> {
            File file = new File(workspaceDir, (String)subpath);
            file.getParentFile().mkdirs();
            try {
                byte[] content = file.exists() ? Files.readAllBytes(file.toPath()) : new byte[]{};
                for (Function modifier : modifiers) {
                    content = (byte[])modifier.apply(content);
                }
                Files.write(file.toPath(), content, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.warn("Failed to write workspace file " + subpath, (Throwable)e);
            }
        });
    }
}

