/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ReadWriteLock;
import de.schlichtherle.io.ReentrantLock;
import de.schlichtherle.util.ThreadLocalCounter;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ReentrantReadWriteLock
implements ReadWriteLock {
    private static final String CLASS_NAME = "de.schlichtherle.io.ReentrantReadWriteLock";
    private static final Logger logger = Logger.getLogger("de.schlichtherle.io.ReentrantReadWriteLock", "de.schlichtherle.io.ReentrantReadWriteLock");
    private final ReadLock readLock = new ReadLock();
    private final WriteLock writeLock = new WriteLock();
    private int totalWriteLockCount;
    private int totalReadLockCount;

    ReentrantReadWriteLock() {
    }

    public ReentrantLock readLock() {
        return this.readLock;
    }

    public ReentrantLock writeLock() {
        return this.writeLock;
    }

    private synchronized void lockRead() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalWriteLockCount - threadWriteLockCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.FINE, "interrupted", ex);
                    logger.log(Level.FINE, "continuing");
                }
            }
        }
        ++this.totalReadLockCount;
    }

    private synchronized void lockReadInterruptibly() throws InterruptedException {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalWriteLockCount - threadWriteLockCount > 0) {
                this.wait();
            }
        }
        ++this.totalReadLockCount;
    }

    private synchronized boolean tryLockRead() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0 && this.totalWriteLockCount - threadWriteLockCount > 0) {
            return false;
        }
        ++this.totalReadLockCount;
        return true;
    }

    private synchronized void unlockRead() {
        --this.totalReadLockCount;
        this.notifyAll();
    }

    private synchronized void lockWrite() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalReadLockCount > 0 || this.totalWriteLockCount - threadWriteLockCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.FINE, "interrupted", ex);
                    logger.log(Level.FINE, "continuing");
                }
            }
        }
        ++this.totalWriteLockCount;
    }

    private synchronized void lockWriteInterruptibly() throws InterruptedException {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalReadLockCount > 0 || this.totalWriteLockCount - threadWriteLockCount > 0) {
                this.wait();
            }
        }
        ++this.totalWriteLockCount;
    }

    private synchronized boolean tryLockWrite() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0 && (this.totalReadLockCount > 0 || this.totalWriteLockCount - threadWriteLockCount > 0)) {
            return false;
        }
        ++this.totalWriteLockCount;
        return true;
    }

    private synchronized void unlockWrite() {
        --this.totalWriteLockCount;
        this.notifyAll();
    }

    private class WriteLock
    extends AbstractLock {
        private WriteLock() {
        }

        public void lock() {
            ReentrantReadWriteLock.this.lockWrite();
            super.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            ReentrantReadWriteLock.this.lockWriteInterruptibly();
            super.lock();
        }

        public boolean tryLock() {
            boolean locked = ReentrantReadWriteLock.this.tryLockWrite();
            if (locked) {
                super.lock();
            }
            return locked;
        }

        public void unlock() {
            super.unlock();
            ReentrantReadWriteLock.this.unlockWrite();
        }
    }

    private class ReadLock
    extends AbstractLock {
        private ReadLock() {
        }

        public void lock() {
            ReentrantReadWriteLock.this.lockRead();
            super.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            ReentrantReadWriteLock.this.lockReadInterruptibly();
            super.lock();
        }

        public boolean tryLock() {
            boolean locked = ReentrantReadWriteLock.this.tryLockRead();
            if (locked) {
                super.lock();
            }
            return locked;
        }

        public void unlock() {
            super.unlock();
            ReentrantReadWriteLock.this.unlockRead();
        }
    }

    private static abstract class AbstractLock
    extends ThreadLocalCounter
    implements ReentrantLock {
        private AbstractLock() {
        }

        public final boolean isLocked() {
            return this.getCounter() > 0;
        }

        public final int lockCount() {
            return this.getCounter();
        }

        public void lock() {
            this.increment();
        }

        public void unlock() {
            int lockCount = this.getCounter();
            if (lockCount <= 0) {
                throw new IllegalMonitorStateException();
            }
            this.setCounter(lockCount - 1);
        }
    }
}

