/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap;

import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.malloc.MallocBytez;
import org.nustaq.offheap.bytez.malloc.MallocBytezAllocator;

public class OffHeapByteTree {
    MallocBytezAllocator alloc = new MallocBytezAllocator();
    MallocBytez base;
    long baseOff = 8L;
    long root;
    int tableCount;
    int keyLen = 0;
    FullPArray arrFull = new FullPArray();
    PArray[] arrs = new PArray[]{null, new PArray(1, 1), new PArray(4, 2), new PArray(16, 3), new PArray(32, 4), new PArray(64, 5)};
    ArrWrap arrWrap = new ArrWrap();

    static int estimateMBytesForIndex(int keylen, int numOfKeys) {
        return Math.max(10, 2 * keylen * numOfKeys / 1000 / 1000);
    }

    public OffHeapByteTree(int keyLen, int sizeMB) {
        this.keyLen = keyLen;
        this.base = (MallocBytez)this.alloc.alloc(0x100000L * (long)sizeMB);
        this.root = this.arrFull.newArr();
    }

    public void free() {
        this.alloc.freeAll();
    }

    public void dumpStats() {
        System.out.println("mem used:" + this.baseOff / 1024L / 1024L + "MB");
        for (int i = 0; i < this.arrs.length; ++i) {
            PArray arr = this.arrs[i];
            if (arr == null) continue;
            System.out.println("pa " + i + " tag " + arr.tag + " entries:" + arr.numEntries + " count:" + arr.count + " reuse:" + arr.reUsed + " freelist:" + arr.freeListIndex);
        }
        System.out.println("fa root count:" + this.arrFull.count + " freelist:" + this.arrFull.freeListIndex);
    }

    public long put(ByteSource key, long value) {
        if (key.length() != (long)this.keyLen) {
            throw new RuntimeException("invalid key length. Expect " + this.keyLen);
        }
        return this.put(key, 0L, this.root, value, 0L, 0);
    }

    long put(ByteSource key, long index, long arr, long toPut, long parentArray, int indexInParent) {
        byte b = key.get(index);
        int i = b + 256 & 0xFF;
        long lookup = this.arrWrap.getAt(arr, i);
        if (index == (long)(this.keyLen - 1)) {
            boolean success = this.arrWrap.put(arr, i, toPut);
            if (!success) {
                if (parentArray == 0L) {
                    throw new RuntimeException("No");
                }
                arr = this.arrWrap.stepUp(arr);
                this.arrWrap.put(parentArray, indexInParent, arr);
                this.arrWrap.put(arr, i, toPut);
            }
            return lookup;
        }
        if (lookup == 0L) {
            long newA = this.arrWrap.newArr();
            boolean success = this.arrWrap.put(arr, i, newA);
            if (!success) {
                if (parentArray == 0L) {
                    throw new RuntimeException("No");
                }
                arr = this.arrWrap.stepUp(arr);
                this.arrWrap.put(parentArray, indexInParent, arr);
                this.arrWrap.put(arr, i, newA);
            }
            return this.put(key, index + 1L, newA, toPut, arr, i);
        }
        return this.put(key, index + 1L, lookup, toPut, arr, i);
    }

    public long get(ByteSource key) {
        if (key.length() != (long)this.keyLen) {
            throw new RuntimeException("invalid key length. Expect " + this.keyLen);
        }
        return this.get(key, 0L, this.root);
    }

    long get(ByteSource key, long index, long arr) {
        byte b = key.get(index);
        int i = b + 256 & 0xFF;
        long lookup = this.arrWrap.getAt(arr, i);
        if (index == (long)(this.keyLen - 1)) {
            return lookup;
        }
        if (lookup == 0L) {
            return 0L;
        }
        return this.get(key, index + 1L, lookup);
    }

    public void remove(ByteSource key) {
        if (key.length() != (long)this.keyLen) {
            throw new RuntimeException("invalid key length. Expect " + this.keyLen);
        }
        this.remove(key, 0L, this.root);
    }

    boolean remove(ByteSource key, long index, long arr) {
        byte b = key.get(index);
        int i = b + 256 & 0xFF;
        long lookup = this.arrWrap.getAt(arr, i);
        if (index == (long)(this.keyLen - 1)) {
            if (lookup != 0L) {
                boolean empty = this.arrWrap.remove(arr, i);
                if (empty) {
                    this.arrWrap.addFree(arr);
                }
                return empty;
            }
            return false;
        }
        if (lookup == 0L) {
            return false;
        }
        boolean res = this.remove(key, index + 1L, lookup);
        if (res) {
            res = this.arrWrap.remove(arr, i);
            if (res && arr != this.root) {
                this.arrWrap.addFree(arr);
            }
            return res;
        }
        return res;
    }

    private void grow() {
        Bytez newBase = this.alloc.alloc(this.base.length() * 2L);
        this.base.copyTo(newBase, 0L, 0L, this.base.length());
        this.alloc.free(this.base);
        this.base = (MallocBytez)newBase;
        System.out.println("index grew to " + this.base.length() / 1024L / 1024L);
    }

    public static void dumpBT(OffHeapByteTree bt) {
        for (int i = 0; i < bt.arrs.length; ++i) {
            PArray arr = bt.arrs[i];
            if (arr == null) continue;
            System.out.println("pa " + i + " tag " + arr.tag + " entries:" + arr.numEntries + " count:" + arr.count + " reuse:" + arr.reUsed + " freelist:" + arr.freeListIndex);
        }
    }

    class ArrWrap {
        ArrWrap() {
        }

        void addFree(long offset) {
            short tag = OffHeapByteTree.this.base.getShort(offset);
            switch (tag) {
                case 0: {
                    OffHeapByteTree.this.arrFull.addFree(offset);
                    break;
                }
                default: {
                    OffHeapByteTree.this.arrs[tag].addFree(offset);
                }
            }
        }

        boolean put(long arr, int i, long value) {
            short tag = OffHeapByteTree.this.base.getShort(arr);
            switch (tag) {
                case 0: {
                    return OffHeapByteTree.this.arrFull.put(arr, i, value);
                }
            }
            return OffHeapByteTree.this.arrs[tag].put(arr, i, value);
        }

        boolean remove(long arr, int key) {
            short tag = OffHeapByteTree.this.base.getShort(arr);
            switch (tag) {
                case 0: {
                    return OffHeapByteTree.this.arrFull.remove(arr, key);
                }
            }
            return OffHeapByteTree.this.arrs[tag].remove(arr, key);
        }

        long getAt(long arr, int i) {
            short tag = OffHeapByteTree.this.base.getShort(arr);
            switch (tag) {
                case 0: {
                    return OffHeapByteTree.this.arrFull.getAt(arr, i);
                }
            }
            return OffHeapByteTree.this.arrs[tag].getAt(arr, i);
        }

        long newArr() {
            return OffHeapByteTree.this.arrs[1].newArr();
        }

        public long stepUp(long arr) {
            short tag = OffHeapByteTree.this.base.getShort(arr);
            switch (tag) {
                case 0: {
                    throw new RuntimeException("famous last words: cannot happen");
                }
                case 5: {
                    long res1 = OffHeapByteTree.this.arrFull.newArr();
                    OffHeapByteTree.this.arrs[tag].copyTo(OffHeapByteTree.this.arrFull, arr, res1);
                    OffHeapByteTree.this.arrs[tag].addFree(arr);
                    return res1;
                }
            }
            long res0 = OffHeapByteTree.this.arrs[tag + 1].newArr();
            OffHeapByteTree.this.arrs[tag].copyTo(OffHeapByteTree.this.arrs[tag + 1], arr, res0);
            OffHeapByteTree.this.arrs[tag].addFree(arr);
            return res0;
        }

        public void dump(long arr) {
            short tag = OffHeapByteTree.this.base.getShort(arr);
            System.out.println("TAG:" + tag);
            switch (tag) {
                case 0: {
                    OffHeapByteTree.this.arrFull.dump(arr);
                    break;
                }
                default: {
                    OffHeapByteTree.this.arrs[tag].dump(arr);
                }
            }
        }
    }

    class FullPArray {
        public static final int TABLE_SIZE = 2052;
        protected long[] freeList = new long[500];
        protected int freeListIndex = 0;
        int count = 0;

        FullPArray() {
        }

        private void addFree(long offset) {
            for (int i = 0; i < 256; ++i) {
                OffHeapByteTree.this.base.putLong(offset + (long)(i * 8), 0L);
            }
            if (this.freeListIndex > 0 && this.freeList[this.freeListIndex - 1] == offset) {
                throw new RuntimeException("double release");
            }
            if (this.freeListIndex >= this.freeList.length && this.freeListIndex * 3 / 2 >= this.freeList.length) {
                long[] newFree = new long[Math.min(this.freeList.length * 2, 0x7FFFFFFE)];
                System.arraycopy(this.freeList, 0, newFree, 0, this.freeListIndex);
                this.freeList = newFree;
            }
            this.freeList[this.freeListIndex++] = offset;
        }

        boolean put(long arr, int i, long value) {
            OffHeapByteTree.this.base.putLong(4L + arr + (long)(i * 8), value);
            return true;
        }

        private long getAt(long arr, int i) {
            return OffHeapByteTree.this.base.getLong(4L + arr + (long)(i * 8));
        }

        long newArr() {
            if (this.freeListIndex > 0) {
                --this.freeListIndex;
                return this.freeList[this.freeListIndex + 1];
            }
            if (OffHeapByteTree.this.baseOff + 2052L >= OffHeapByteTree.this.base.length()) {
                if (this.freeListIndex == 0) {
                    OffHeapByteTree.this.grow();
                } else {
                    return this.newArr();
                }
            }
            ++OffHeapByteTree.this.tableCount;
            long res = OffHeapByteTree.this.baseOff;
            OffHeapByteTree.this.base.putInt(res, 0);
            OffHeapByteTree.this.baseOff += 2052L;
            ++this.count;
            return res;
        }

        public boolean remove(long arr, int key) {
            OffHeapByteTree.this.base.putLong(4L + arr + (long)(key * 8), 0L);
            return this.isEmpty(arr);
        }

        private boolean isEmpty(long arr) {
            for (int i = 0; i < 256; ++i) {
                if (this.getAt(arr, i) == 0L) continue;
                return false;
            }
            return true;
        }

        public void dump(long arr) {
            for (int i = 0; i < 256; ++i) {
                long at = this.getAt(arr, i);
                if (at == 0L) continue;
                System.out.println(" " + i + " => " + at);
            }
        }
    }

    class PArray {
        int numEntries;
        int TABLE_SIZE;
        int count;
        int reUsed;
        int tag;
        protected long[] freeList = new long[500];
        protected int freeListIndex = 0;

        PArray(int numEntries, int tag) {
            this.numEntries = numEntries;
            this.TABLE_SIZE = numEntries * 8 + numEntries * 2 + 4;
            this.tag = tag;
        }

        private void addFree(long offset) {
            for (int i = 4; i < this.TABLE_SIZE; ++i) {
                OffHeapByteTree.this.base.put(offset + (long)i, (byte)0);
            }
            if (OffHeapByteTree.this.base.getInt(offset) != this.tag) {
                throw new RuntimeException("bad");
            }
            if (this.freeListIndex >= this.freeList.length && this.freeListIndex * 3 / 2 >= this.freeList.length) {
                long[] newFree = new long[Math.min(this.freeList.length * 2, 0x7FFFFFFE)];
                System.arraycopy(this.freeList, 0, newFree, 0, this.freeListIndex);
                this.freeList = newFree;
            }
            this.freeList[this.freeListIndex++] = offset;
        }

        boolean put(long arr, int index, long value) {
            int i;
            if (value == 0L) {
                throw new RuntimeException("0 value not allowed");
            }
            long off = arr + 4L;
            for (i = 0; i < this.numEntries; ++i) {
                short key = OffHeapByteTree.this.base.getShort(off);
                long debugVal = OffHeapByteTree.this.base.getLong(off + 2L);
                if (key == index) {
                    OffHeapByteTree.this.base.putLong(off + 2L, value);
                    return true;
                }
                off += 10L;
            }
            off = arr + 4L;
            for (i = 0; i < this.numEntries; ++i) {
                long readvalue = OffHeapByteTree.this.base.getLong(off + 2L);
                if (readvalue == 0L) {
                    OffHeapByteTree.this.base.putShort(off, (short)index);
                    OffHeapByteTree.this.base.putLong(off + 2L, value);
                    return true;
                }
                off += 10L;
            }
            return false;
        }

        private long getAt(long arr, int index) {
            long off = arr + 4L;
            for (int i = 0; i < this.numEntries; ++i) {
                if (OffHeapByteTree.this.base.getShort(off) == index) {
                    return OffHeapByteTree.this.base.getLong(off + 2L);
                }
                off += 10L;
            }
            return 0L;
        }

        long newArr() {
            if (this.freeListIndex > 0) {
                ++this.reUsed;
                return this.freeList[--this.freeListIndex];
            }
            if (OffHeapByteTree.this.baseOff + (long)this.TABLE_SIZE >= OffHeapByteTree.this.base.length()) {
                if (this.freeListIndex == 0) {
                    OffHeapByteTree.this.grow();
                } else {
                    return this.newArr();
                }
            }
            ++OffHeapByteTree.this.tableCount;
            long res = OffHeapByteTree.this.baseOff;
            OffHeapByteTree.this.base.putInt(res, this.tag);
            OffHeapByteTree.this.baseOff += (long)this.TABLE_SIZE;
            ++this.count;
            return res;
        }

        public void copyTo(PArray destAcc, long arrSrc, long arrDest) {
            long off = arrSrc + 4L;
            for (int i = 0; i < this.numEntries; ++i) {
                short index = OffHeapByteTree.this.base.getShort(off);
                long value = OffHeapByteTree.this.base.getLong(off + 2L);
                if (value >= 0L) {
                    destAcc.put(arrDest, index, value);
                }
                off += 10L;
            }
        }

        public void copyTo(FullPArray destAcc, long arrSrc, long arrDest) {
            long off = arrSrc + 4L;
            for (int i = 0; i < this.numEntries; ++i) {
                short index = OffHeapByteTree.this.base.getShort(off);
                long value = OffHeapByteTree.this.base.getLong(off + 2L);
                if (value >= 0L) {
                    destAcc.put(arrDest, index, value);
                }
                off += 10L;
            }
        }

        public void dump(long arr) {
            long off = arr + 4L;
            for (int i = 0; i < this.numEntries; ++i) {
                short index = OffHeapByteTree.this.base.getShort(off);
                long value = OffHeapByteTree.this.base.getLong(off + 2L);
                if (value > 0L) {
                    System.out.println(" " + index + " => " + value);
                }
                off += 10L;
            }
        }

        public boolean remove(long arr, int key) {
            long off = arr + 4L;
            boolean empty = true;
            for (int i = 0; i < this.numEntries; ++i) {
                short index = OffHeapByteTree.this.base.getShort(off);
                long value = OffHeapByteTree.this.base.getLong(off + 2L);
                if (index == key) {
                    OffHeapByteTree.this.base.putShort(off, (short)0);
                    OffHeapByteTree.this.base.putLong(off + 2L, 0L);
                } else if (index != 0) {
                    empty = false;
                }
                off += 10L;
            }
            return empty;
        }
    }
}

