/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.node.Visit;
import de.danielbechler.util.Strings;

public class NodeHierarchyVisitor
implements DiffNode.Visitor {
    public static final int UNLIMITED = -1;
    private final int maxDepth;

    public NodeHierarchyVisitor() {
        this(-1);
    }

    public NodeHierarchyVisitor(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void node(DiffNode node, Visit visit) {
        if (this.maxDepth == 0) {
            visit.stop();
        }
        int currentLevel = NodeHierarchyVisitor.calculateDepth(node);
        if (this.maxDepth > 0) {
            if (currentLevel <= this.maxDepth) {
                this.print(node, currentLevel);
            } else {
                visit.dontGoDeeper();
            }
        } else if (this.maxDepth < 0) {
            this.print(node, currentLevel);
        }
    }

    private static int calculateDepth(DiffNode node) {
        int count = 0;
        for (DiffNode parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            ++count;
        }
        return count;
    }

    protected void print(DiffNode node, int level) {
        String nodeAsString = node.getPath() + " ===> " + node.toString();
        String indentedNodeString = Strings.indent(level, nodeAsString);
        this.print(indentedNodeString);
    }

    protected void print(String text) {
        System.out.println(text);
    }
}

