/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.introspection;

import de.danielbechler.diff.access.PropertyAwareAccessor;
import de.danielbechler.diff.introspection.ObjectDiffProperty;
import de.danielbechler.diff.introspection.PropertyReadException;
import de.danielbechler.diff.introspection.PropertyWriteException;
import de.danielbechler.diff.selector.BeanPropertyElementSelector;
import de.danielbechler.util.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessor
implements PropertyAwareAccessor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyAccessor.class);
    private final String propertyName;
    private final Class<?> type;
    private final Method readMethod;
    private final Method writeMethod;

    public PropertyAccessor(String propertyName, Method readMethod, Method writeMethod) {
        Assert.notNull(propertyName, "propertyName");
        Assert.notNull(readMethod, "readMethod");
        this.propertyName = propertyName;
        this.readMethod = PropertyAccessor.makeAccessible(readMethod);
        this.writeMethod = PropertyAccessor.makeAccessible(writeMethod);
        this.type = this.readMethod.getReturnType();
    }

    private static Method makeAccessible(Method method) {
        if (method != null && !method.isAccessible()) {
            logger.debug("Making method accessible: {}", (Object)method.toString());
            method.setAccessible(true);
        }
        return method;
    }

    @Override
    public final Set<String> getCategoriesFromAnnotation() {
        ObjectDiffProperty annotation = this.readMethod.getAnnotation(ObjectDiffProperty.class);
        if (annotation != null) {
            return new TreeSet<String>(Arrays.asList(annotation.categories()));
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isExcludedByAnnotation() {
        ObjectDiffProperty annotation = this.readMethod.getAnnotation(ObjectDiffProperty.class);
        return annotation != null && annotation.excluded();
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    private Set<Annotation> getFieldAnnotations(Class<?> clazz) {
        try {
            return new LinkedHashSet<Annotation>(Arrays.asList(clazz.getDeclaredField(this.propertyName).getAnnotations()));
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return this.getFieldAnnotations(clazz.getSuperclass());
            }
            logger.debug("Cannot find propertyName: {}, declaring class: {}", (Object)this.propertyName, clazz);
            return new LinkedHashSet<Annotation>(0);
        }
    }

    @Override
    public Set<Annotation> getFieldAnnotations() {
        return this.getFieldAnnotations(this.readMethod.getDeclaringClass());
    }

    @Override
    public <T extends Annotation> T getFieldAnnotation(Class<T> annotationClass) {
        Set<Annotation> annotations = this.getFieldAnnotations();
        assert (annotations != null) : "Something is wrong here. The contract of getReadAnnotations() guarantees a non-null return value.";
        for (Annotation annotation : annotations) {
            if (!annotationClass.isAssignableFrom(annotation.annotationType())) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    @Override
    public Set<Annotation> getReadMethodAnnotations() {
        return new LinkedHashSet<Annotation>(Arrays.asList(this.readMethod.getAnnotations()));
    }

    @Override
    public <T extends Annotation> T getReadMethodAnnotation(Class<T> annotationClass) {
        Set<Annotation> annotations = this.getReadMethodAnnotations();
        assert (annotations != null) : "Something is wrong here. The contract of getReadAnnotations() guarantees a non-null return value.";
        for (Annotation annotation : annotations) {
            if (!annotationClass.isAssignableFrom(annotation.annotationType())) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    @Override
    public BeanPropertyElementSelector getElementSelector() {
        return new BeanPropertyElementSelector(this.propertyName);
    }

    @Override
    public Object get(Object target) {
        if (target == null) {
            return null;
        }
        try {
            return this.readMethod.invoke(target, new Object[0]);
        }
        catch (Exception cause) {
            throw new PropertyReadException(this.propertyName, target.getClass(), cause);
        }
    }

    @Override
    public void set(Object target, Object value) {
        if (target == null) {
            logger.info("Couldn't set new value '{}' for property '{}' because the target object is null", value, (Object)this.propertyName);
        } else if (this.writeMethod == null) {
            logger.debug("No setter found for property '{}'", (Object)this.propertyName);
            this.tryToReplaceContentOfCollectionTypes(target, value);
        } else {
            this.invokeWriteMethod(target, value);
        }
    }

    @Override
    public void unset(Object target) {
        this.set(target, null);
    }

    private void tryToReplaceContentOfCollectionTypes(Object target, Object value) {
        if (Collection.class.isAssignableFrom(this.readMethod.getReturnType()) && PropertyAccessor.tryToReplaceCollectionContent((Collection)this.get(target), (Collection)value)) {
            return;
        }
        if (Map.class.isAssignableFrom(this.readMethod.getReturnType()) && PropertyAccessor.tryToReplaceMapContent((Map)this.get(target), (Map)value)) {
            return;
        }
        logger.info("Couldn't set new value '{}' for property '{}'", value, (Object)this.propertyName);
    }

    private void invokeWriteMethod(Object target, Object value) {
        try {
            this.writeMethod.invoke(target, value);
        }
        catch (Exception cause) {
            throw new PropertyWriteException(this.propertyName, target.getClass(), value, cause);
        }
    }

    private static boolean tryToReplaceCollectionContent(Collection<Object> target, Collection<Object> value) {
        if (target == null) {
            return false;
        }
        try {
            target.clear();
            target.addAll(value);
            return true;
        }
        catch (Exception unmodifiable) {
            logger.debug("Failed to replace content of existing Collection", (Throwable)unmodifiable);
            return false;
        }
    }

    private static boolean tryToReplaceMapContent(Map<Object, Object> target, Map<Object, Object> value) {
        if (target == null) {
            return false;
        }
        try {
            target.clear();
            target.putAll(value);
            return true;
        }
        catch (Exception unmodifiable) {
            logger.debug("Failed to replace content of existing Map", (Throwable)unmodifiable);
            return false;
        }
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PropertyAccessor{");
        sb.append("propertyName='").append(this.propertyName).append('\'');
        sb.append(", type=").append(this.type.getCanonicalName());
        sb.append(", source=").append(this.readMethod.getDeclaringClass().getCanonicalName());
        sb.append(", hasWriteMethod=").append(this.writeMethod != null);
        sb.append('}');
        return sb.toString();
    }
}

