/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.introspection;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.instantiation.InstanceFactory;
import de.danielbechler.diff.instantiation.PublicNoArgsConstructorInstanceFactory;
import de.danielbechler.diff.instantiation.TypeInfo;
import de.danielbechler.diff.introspection.DefaultPropertyAccessExceptionHandler;
import de.danielbechler.diff.introspection.InstanceFactoryFallbackDecorator;
import de.danielbechler.diff.introspection.IntrospectionConfigurer;
import de.danielbechler.diff.introspection.Introspector;
import de.danielbechler.diff.introspection.IsIntrospectableResolver;
import de.danielbechler.diff.introspection.PropertyAccessExceptionHandler;
import de.danielbechler.diff.introspection.PropertyAccessExceptionHandlerResolver;
import de.danielbechler.diff.introspection.StandardIntrospector;
import de.danielbechler.diff.introspection.TypeInfoResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.path.NodePathValueHolder;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Classes;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionService
implements IntrospectionConfigurer,
IsIntrospectableResolver,
TypeInfoResolver,
PropertyAccessExceptionHandlerResolver {
    private final Map<Class<?>, Introspector> typeIntrospectorMap = new HashMap();
    private final Map<Class<?>, IntrospectionMode> typeIntrospectionModeMap = new HashMap();
    private final NodePathValueHolder<Introspector> nodePathIntrospectorHolder = new NodePathValueHolder();
    private final NodePathValueHolder<IntrospectionMode> nodePathIntrospectionModeHolder = new NodePathValueHolder();
    private final ObjectDifferBuilder objectDifferBuilder;
    private Introspector defaultIntrospector;
    private InstanceFactory instanceFactory = new PublicNoArgsConstructorInstanceFactory();
    private PropertyAccessExceptionHandler defaultPropertyAccessExceptionHandler = new DefaultPropertyAccessExceptionHandler();

    public IntrospectionService(ObjectDifferBuilder objectDifferBuilder) {
        this.objectDifferBuilder = objectDifferBuilder;
    }

    @Override
    public boolean isIntrospectable(DiffNode node) {
        Class<?> nodeType = node.getValueType();
        if (nodeType == null) {
            return false;
        }
        if (IntrospectionService.isPrimitiveTypeEnumOrArray(nodeType)) {
            return false;
        }
        if (this.nodePathIntrospectionModeHolder.valueForNodePath(node.getPath()) == IntrospectionMode.DISABLED) {
            return false;
        }
        return this.typeIntrospectionModeMap.get(nodeType) != IntrospectionMode.DISABLED;
    }

    private static boolean isPrimitiveTypeEnumOrArray(Class<?> nodeType) {
        return Classes.isPrimitiveType(nodeType) || Classes.isPrimitiveWrapperType(nodeType) || nodeType.isEnum() || nodeType.isArray();
    }

    @Override
    public PropertyAccessExceptionHandler resolvePropertyAccessExceptionHandler(Class<?> parentType, String propertyName) {
        return this.defaultPropertyAccessExceptionHandler;
    }

    @Override
    public TypeInfo typeInfoForNode(DiffNode node) {
        Class<?> beanType = node.getValueType();
        Introspector introspector = this.introspectorForNode(node);
        TypeInfo typeInfo = introspector.introspect(beanType);
        typeInfo.setInstanceFactory(this.instanceFactory);
        return typeInfo;
    }

    public Introspector introspectorForNode(DiffNode node) {
        Introspector typeIntrospector = this.typeIntrospectorMap.get(node.getValueType());
        if (typeIntrospector != null) {
            return typeIntrospector;
        }
        Introspector nodePathIntrospector = this.nodePathIntrospectorHolder.valueForNodePath(node.getPath());
        if (nodePathIntrospector != null) {
            return nodePathIntrospector;
        }
        if (this.defaultIntrospector == null) {
            this.defaultIntrospector = new StandardIntrospector();
        }
        return this.defaultIntrospector;
    }

    @Override
    public IntrospectionConfigurer setInstanceFactory(InstanceFactory instanceFactory) {
        Assert.notNull(instanceFactory, "instanceFactory");
        this.instanceFactory = new InstanceFactoryFallbackDecorator(instanceFactory);
        return this;
    }

    @Override
    public IntrospectionConfigurer setDefaultIntrospector(Introspector introspector) {
        Assert.notNull(introspector, "The default introspector must not be null");
        this.defaultIntrospector = introspector;
        return this;
    }

    @Override
    public IntrospectionConfigurer handlePropertyAccessExceptionsUsing(PropertyAccessExceptionHandler exceptionHandler) {
        Assert.notNull(exceptionHandler, "exceptionHandler");
        this.defaultPropertyAccessExceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public IntrospectionConfigurer.Of ofType(final Class<?> type) {
        return new IntrospectionConfigurer.Of(){

            public IntrospectionConfigurer toUse(Introspector introspector) {
                IntrospectionService.this.typeIntrospectorMap.put(type, introspector);
                return IntrospectionService.this;
            }

            public IntrospectionConfigurer toBeEnabled() {
                IntrospectionService.this.typeIntrospectionModeMap.put(type, IntrospectionMode.ENABLED);
                return IntrospectionService.this;
            }

            public IntrospectionConfigurer toBeDisabled() {
                IntrospectionService.this.typeIntrospectionModeMap.put(type, IntrospectionMode.DISABLED);
                return IntrospectionService.this;
            }
        };
    }

    @Override
    public IntrospectionConfigurer.Of ofNode(final NodePath path) {
        return new IntrospectionConfigurer.Of(){

            public IntrospectionConfigurer toUse(Introspector introspector) {
                IntrospectionService.this.nodePathIntrospectorHolder.put(path, introspector);
                return IntrospectionService.this;
            }

            public IntrospectionConfigurer toBeEnabled() {
                IntrospectionService.this.nodePathIntrospectionModeHolder.put(path, IntrospectionMode.ENABLED);
                return IntrospectionService.this;
            }

            public IntrospectionConfigurer toBeDisabled() {
                IntrospectionService.this.nodePathIntrospectionModeHolder.put(path, IntrospectionMode.DISABLED);
                return IntrospectionService.this;
            }
        };
    }

    @Override
    public ObjectDifferBuilder and() {
        return this.objectDifferBuilder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntrospectionMode {
        ENABLED,
        DISABLED;

    }
}

