/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.access;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.TypeAwareAccessor;
import de.danielbechler.diff.identity.EqualsIdentityStrategy;
import de.danielbechler.diff.identity.IdentityStrategy;
import de.danielbechler.diff.selector.CollectionItemElementSelector;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.util.Assert;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionItemAccessor
implements TypeAwareAccessor,
Accessor {
    private final Object referenceItem;
    private final IdentityStrategy identityStrategy;

    public CollectionItemAccessor(Object referenceItem) {
        this(referenceItem, EqualsIdentityStrategy.getInstance());
    }

    public CollectionItemAccessor(Object referenceItem, IdentityStrategy identityStrategy) {
        Assert.notNull(identityStrategy, "identityStrategy");
        this.referenceItem = referenceItem;
        this.identityStrategy = identityStrategy;
    }

    @Override
    public Class<?> getType() {
        return this.referenceItem != null ? this.referenceItem.getClass() : null;
    }

    public String toString() {
        return "collection item " + this.getElementSelector();
    }

    @Override
    public ElementSelector getElementSelector() {
        CollectionItemElementSelector selector = new CollectionItemElementSelector(this.referenceItem);
        return this.identityStrategy == null ? selector : selector.copyWithIdentityStrategy(this.identityStrategy);
    }

    @Override
    public Object get(Object target) {
        Collection<Object> targetCollection = CollectionItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return null;
        }
        for (Object item : targetCollection) {
            if (item == null || !this.identityStrategy.equals(item, this.referenceItem)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void set(Object target, Object value) {
        Collection<Object> targetCollection = CollectionItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return;
        }
        Object previous = this.get(target);
        if (previous != null) {
            this.unset(target);
        }
        targetCollection.add(value);
    }

    private static Collection<Object> objectAsCollection(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }

    @Override
    public void unset(Object target) {
        Collection<Object> targetCollection = CollectionItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return;
        }
        Iterator<Object> iterator = targetCollection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item == null || !this.identityStrategy.equals(item, this.referenceItem)) continue;
            iterator.remove();
            break;
        }
    }
}

