/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

public class CloudFoundryHttpHeaderProvider
implements HttpHeadersProvider {
    @Override
    public HttpHeaders getHeaders(Instance instance) {
        String applicationId = instance.getRegistration().getMetadata().get("applicationId");
        String instanceId = instance.getRegistration().getMetadata().get("instanceId");
        if (StringUtils.hasText((String)applicationId) && StringUtils.hasText((String)instanceId)) {
            HttpHeaders headers = new HttpHeaders();
            headers.set("X-CF-APP-INSTANCE", applicationId + ":" + instanceId);
            return headers;
        }
        return HttpHeaders.EMPTY;
    }
}

