/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import java.util.function.Function;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.retry.Retry;

public abstract class AbstractEventHandler<T extends InstanceEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Publisher<InstanceEvent> publisher;
    private final Class<T> eventType;
    @Nullable
    private Disposable subscription;
    @Nullable
    private Scheduler scheduler;

    protected AbstractEventHandler(Publisher<InstanceEvent> publisher, Class<T> eventType) {
        this.publisher = publisher;
        this.eventType = eventType;
    }

    public void start() {
        this.scheduler = this.createScheduler();
        this.subscription = Flux.from(this.publisher).subscribeOn(this.scheduler).log(this.log.getName(), Level.FINEST, new SignalType[0]).doOnSubscribe(s -> this.log.debug("Subscribed to {} events", this.eventType)).ofType(this.eventType).cast(this.eventType).transform(this::handle).retryWhen((Function)Retry.any().retryMax(Long.MAX_VALUE).doOnRetry(ctx -> this.log.warn("Unexpected error", ctx.exception()))).subscribe();
    }

    protected abstract Publisher<Void> handle(Flux<T> var1);

    protected Scheduler createScheduler() {
        return Schedulers.newElastic((String)this.getClass().getSimpleName());
    }

    public void stop() {
        if (this.subscription != null) {
            this.subscription.dispose();
            this.subscription = null;
        }
        if (this.scheduler != null) {
            this.scheduler.dispose();
            this.scheduler = null;
        }
    }
}

