/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.eventstore.InstanceEventStore;
import de.codecentric.boot.admin.server.services.InstanceRegistry;
import de.codecentric.boot.admin.server.web.AdminController;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@AdminController
@ResponseBody
public class InstancesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancesController.class);
    private static final ServerSentEvent<?> PING = ServerSentEvent.builder().comment("ping").build();
    private static final Flux<ServerSentEvent<?>> PING_FLUX = Flux.interval((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(10L)).map(tick -> PING);
    private final InstanceRegistry registry;
    private final InstanceEventStore eventStore;

    public InstancesController(InstanceRegistry registry, InstanceEventStore eventStore) {
        this.registry = registry;
        this.eventStore = eventStore;
    }

    @PostMapping(path={"/instances"}, consumes={"application/json"})
    public Mono<ResponseEntity<Map<String, InstanceId>>> register(@RequestBody Registration registration, UriComponentsBuilder builder) {
        Registration withSource = Registration.copyOf(registration).source("http-api").build();
        LOGGER.debug("Register instance {}", (Object)withSource);
        return this.registry.register(withSource).map(id -> {
            URI location = builder.replacePath("/instances/{id}").buildAndExpand(new Object[]{id}).toUri();
            return ResponseEntity.created((URI)location).body(Collections.singletonMap("id", id));
        });
    }

    @GetMapping(path={"/instances"}, produces={"application/json"})
    public Flux<Instance> instances(@RequestParam(value="name", required=false) String name) {
        LOGGER.debug("Deliver registered instances with name={}", (Object)name);
        if (name == null || name.isEmpty()) {
            return this.registry.getInstances().filter(Instance::isRegistered);
        }
        return this.registry.getInstances(name).filter(Instance::isRegistered);
    }

    @GetMapping(path={"/instances/{id}"}, produces={"application/json"})
    public Mono<ResponseEntity<Instance>> instance(@PathVariable String id) {
        LOGGER.debug("Deliver registered instance with ID '{}'", (Object)id);
        return this.registry.getInstance(InstanceId.of(id)).filter(Instance::isRegistered).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    @DeleteMapping(path={"/instances/{id}"})
    public Mono<ResponseEntity<Void>> unregister(@PathVariable String id) {
        LOGGER.debug("Unregister instance with ID '{}'", (Object)id);
        return this.registry.deregister(InstanceId.of(id)).map(v -> ResponseEntity.noContent().build()).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    @GetMapping(path={"/instances/events"}, produces={"application/json"})
    public Flux<InstanceEvent> events() {
        return this.eventStore.findAll();
    }

    @GetMapping(path={"/instances/events"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<InstanceEvent>> eventStream() {
        return Flux.from((Publisher)this.eventStore).map(event -> ServerSentEvent.builder((Object)event).build()).mergeWith(InstancesController.ping());
    }

    @GetMapping(path={"/instances/{id}"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<Instance>> instanceStream(@PathVariable String id) {
        return Flux.from((Publisher)this.eventStore).filter(event -> event.getInstance().equals(InstanceId.of(id))).flatMap(event -> this.registry.getInstance(event.getInstance())).map(event -> ServerSentEvent.builder((Object)event).build()).mergeWith(InstancesController.ping());
    }

    private static <T> Flux<ServerSentEvent<T>> ping() {
        return PING_FLUX;
    }
}

