/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import de.codecentric.boot.admin.server.config.AdminServerAutoConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerMarkerConfiguration;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.eventstore.HazelcastEventStore;
import de.codecentric.boot.admin.server.eventstore.InstanceEventStore;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={AdminServerMarkerConfiguration.Marker.class})
@ConditionalOnSingleCandidate(value=HazelcastInstance.class)
@ConditionalOnProperty(prefix="spring.boot.admin.hazelcast", name={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={AdminServerAutoConfiguration.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class AdminServerHazelcastAutoConfiguration {
    @Value(value="${spring.boot.admin.hazelcast.event-store:spring-boot-admin-event-store}")
    private String mapName;

    @Bean
    @ConditionalOnMissingBean(value={InstanceEventStore.class})
    public HazelcastEventStore eventStore(HazelcastInstance hazelcastInstance) {
        IMap map = hazelcastInstance.getMap(this.mapName);
        return new HazelcastEventStore((IMap<InstanceId, List<InstanceEvent>>)map);
    }
}

