/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.model.StatusInfo;
import de.codecentric.boot.admin.notify.AbstractEventNotifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class MicrosoftTeamsNotifier
extends AbstractEventNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftTeamsNotifier.class);
    private static final String STATUS_KEY = "Status";
    private static final String SERVICE_URL_KEY = "Service URL";
    private static final String HEALTH_URL_KEY = "Health URL";
    private static final String MANAGEMENT_URL_KEY = "Management URL";
    private static final String SOURCE_KEY = "Source";
    private RestTemplate restTemplate = new RestTemplate();
    private URI webhookUrl;
    private String themeColor = "6db33f";
    private String deregisterActivitySubtitlePattern = "%s with id %s has de-registered from Spring Boot Admin";
    private String registerActivitySubtitlePattern = "%s with id %s has registered from Spring Boot Admin";
    private String statusActivitySubtitlePattern = "%s with id %s changed status from %s to %s";
    private String deRegisteredTitle = "De-Registered";
    private String registeredTitle = "Registered";
    private String statusChangedTitle = "Status Changed";
    private String messageSummary = "Spring Boot Admin Notification";

    @Override
    protected void doNotify(ClientApplicationEvent event) throws Exception {
        Message message;
        if (event instanceof ClientApplicationRegisteredEvent) {
            message = this.getRegisteredMessage(event.getApplication());
        } else if (event instanceof ClientApplicationDeregisteredEvent) {
            message = this.getDeregisteredMessage(event.getApplication());
        } else if (event instanceof ClientApplicationStatusChangedEvent) {
            ClientApplicationStatusChangedEvent statusChangedEvent = (ClientApplicationStatusChangedEvent)event;
            message = this.getStatusChangedMessage(statusChangedEvent.getApplication(), statusChangedEvent.getFrom(), statusChangedEvent.getTo());
        } else {
            return;
        }
        this.restTemplate.postForEntity(this.webhookUrl, (Object)message, Void.class);
    }

    @Override
    protected boolean shouldNotify(ClientApplicationEvent event) {
        return event instanceof ClientApplicationRegisteredEvent || event instanceof ClientApplicationDeregisteredEvent || event instanceof ClientApplicationStatusChangedEvent;
    }

    protected Message getDeregisteredMessage(Application app) {
        String activitySubtitle = this.safeFormat(this.deregisterActivitySubtitlePattern, app.getName(), app.getId());
        return this.createMessage(app, this.deRegisteredTitle, activitySubtitle);
    }

    protected Message getRegisteredMessage(Application app) {
        String activitySubtitle = this.safeFormat(this.registerActivitySubtitlePattern, app.getName(), app.getId());
        return this.createMessage(app, this.registeredTitle, activitySubtitle);
    }

    protected Message getStatusChangedMessage(Application app, StatusInfo from, StatusInfo to) {
        String activitySubtitle = this.safeFormat(this.statusActivitySubtitlePattern, app.getName(), app.getId(), from.getStatus(), to.getStatus());
        return this.createMessage(app, this.statusChangedTitle, activitySubtitle);
    }

    private String safeFormat(String format, Object ... args) {
        try {
            return String.format(format, args);
        }
        catch (MissingFormatArgumentException e) {
            LOGGER.warn("Exception while trying to format the message. Falling back by using the format string.", (Throwable)e);
            return format;
        }
    }

    protected Message createMessage(Application app, String registeredTitle, String activitySubtitle) {
        Message message = new Message();
        message.setTitle(registeredTitle);
        message.setSummary(this.messageSummary);
        message.setThemeColor(this.themeColor);
        Section section = new Section();
        section.setActivityTitle(app.getName());
        section.setActivitySubtitle(activitySubtitle);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(new Fact(STATUS_KEY, app.getStatusInfo().getStatus()));
        facts.add(new Fact(SERVICE_URL_KEY, app.getServiceUrl()));
        facts.add(new Fact(HEALTH_URL_KEY, app.getHealthUrl()));
        facts.add(new Fact(MANAGEMENT_URL_KEY, app.getManagementUrl()));
        facts.add(new Fact(SOURCE_KEY, app.getSource()));
        section.setFacts(facts);
        message.setSections(Collections.singletonList(section));
        return message;
    }

    public void setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setThemeColor(String themeColor) {
        this.themeColor = themeColor;
    }

    public String getDeregisterActivitySubtitlePattern() {
        return this.deregisterActivitySubtitlePattern;
    }

    public void setDeregisterActivitySubtitlePattern(String deregisterActivitySubtitlePattern) {
        this.deregisterActivitySubtitlePattern = deregisterActivitySubtitlePattern;
    }

    public String getRegisterActivitySubtitlePattern() {
        return this.registerActivitySubtitlePattern;
    }

    public void setRegisterActivitySubtitlePattern(String registerActivitySubtitlePattern) {
        this.registerActivitySubtitlePattern = registerActivitySubtitlePattern;
    }

    public String getStatusActivitySubtitlePattern() {
        return this.statusActivitySubtitlePattern;
    }

    public void setStatusActivitySubtitlePattern(String statusActivitySubtitlePattern) {
        this.statusActivitySubtitlePattern = statusActivitySubtitlePattern;
    }

    public String getDeRegisteredTitle() {
        return this.deRegisteredTitle;
    }

    public void setDeRegisteredTitle(String deRegisteredTitle) {
        this.deRegisteredTitle = deRegisteredTitle;
    }

    public String getRegisteredTitle() {
        return this.registeredTitle;
    }

    public void setRegisteredTitle(String registeredTitle) {
        this.registeredTitle = registeredTitle;
    }

    public String getStatusChangedTitle() {
        return this.statusChangedTitle;
    }

    public void setStatusChangedTitle(String statusChangedTitle) {
        this.statusChangedTitle = statusChangedTitle;
    }

    public String getMessageSummary() {
        return this.messageSummary;
    }

    public void setMessageSummary(String messageSummary) {
        this.messageSummary = messageSummary;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static class Fact {
        private final String name;
        private final String value;

        public Fact(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Section {
        private String activityTitle;
        private String activitySubtitle;
        private List<Fact> facts = new ArrayList<Fact>();

        public String getActivityTitle() {
            return this.activityTitle;
        }

        public void setActivityTitle(String activityTitle) {
            this.activityTitle = activityTitle;
        }

        public String getActivitySubtitle() {
            return this.activitySubtitle;
        }

        public void setActivitySubtitle(String activitySubtitle) {
            this.activitySubtitle = activitySubtitle;
        }

        public void setFacts(List<Fact> facts) {
            this.facts = facts;
        }

        public List<Fact> getFacts() {
            return this.facts;
        }
    }

    public static class Message {
        private String summary;
        private String themeColor;
        private String title;
        private List<Section> sections = new ArrayList<Section>();

        public String getSummary() {
            return this.summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public String getTitle() {
            return this.title;
        }

        public String getThemeColor() {
            return this.themeColor;
        }

        public void setSections(List<Section> sections) {
            this.sections = sections;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setThemeColor(String themeColor) {
            this.themeColor = themeColor;
        }

        public List<Section> getSections() {
            return this.sections;
        }
    }
}

