/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.web.reactive;

import de.codecentric.boot.admin.server.ui.web.HomepageForwardingMatcher;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class HomepageForwardingFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(HomepageForwardingFilter.class);
    private final String homepage;
    private final HomepageForwardingMatcher<ServerHttpRequest> matcher;

    public HomepageForwardingFilter(String homepage, List<String> routeIncludes, List<String> routeExcludes) {
        this.homepage = homepage;
        this.matcher = new HomepageForwardingMatcher<ServerHttpRequest>(routeIncludes, routeExcludes, HttpRequest::getMethodValue, r -> r.getPath().pathWithinApplication().toString(), r -> r.getHeaders().getAccept());
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.matcher.test(exchange.getRequest())) {
            log.trace("Forwarding request with URL {} to index", (Object)exchange.getRequest().getURI());
            exchange = exchange.mutate().request(request -> request.path(this.homepage)).build();
        }
        return chain.filter(exchange);
    }
}

