/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.discovery;

import com.netflix.appinfo.InstanceInfo;
import de.codecentric.boot.admin.server.cloud.discovery.DefaultServiceInstanceConverter;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.util.StringUtils;

public class EurekaServiceInstanceConverter
extends DefaultServiceInstanceConverter {
    @Override
    protected URI getHealthUrl(ServiceInstance instance) {
        if (!(instance instanceof EurekaServiceInstance)) {
            return super.getHealthUrl(instance);
        }
        InstanceInfo instanceInfo = ((EurekaServiceInstance)instance).getInstanceInfo();
        String healthUrl = instanceInfo.getSecureHealthCheckUrl();
        if (!StringUtils.hasText((String)healthUrl)) {
            healthUrl = instanceInfo.getHealthCheckUrl();
        }
        return URI.create(healthUrl);
    }
}

