/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.compiler;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class AttributeExpressionParser {
    protected static Argument nextArgument(String string, int startPos, String filename, int line) {
        if (string.charAt(startPos) == ')') {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = startPos;
        int depth = 0;
        while (string.charAt(i) != ',' && string.charAt(i) != ')' || depth != 0) {
            block0 : switch (string.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    ++depth;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    --depth;
                    break;
                }
                case '\"': 
                case '\'': {
                    char endChar = string.charAt(i);
                    sb.append(string.charAt(i));
                    ++i;
                    while (true) {
                        char ch;
                        if ((ch = string.charAt(i)) == '\\') {
                            sb.append(ch);
                            ch = string.charAt(++i);
                            sb.append(ch);
                        } else {
                            if (ch == endChar) break block0;
                            sb.append(ch);
                        }
                        ++i;
                    }
                }
            }
            sb.append(string.charAt(i));
            if (++i != string.length()) continue;
            throw new BuildException(filename + ":" + line + ": Unterminated argument: " + string);
        }
        if (string.charAt(i) == ',') {
            ++i;
        }
        String text = sb.toString();
        String field = null;
        int eqPos = text.indexOf(61);
        if (eqPos > -1) {
            boolean identifier = true;
            int j = 0;
            while (j < eqPos) {
                char ch = text.charAt(j);
                if (!Character.isJavaIdentifierPart(ch) && ch != ' ') {
                    identifier = false;
                }
                ++j;
            }
            if (identifier) {
                field = text.substring(0, eqPos).trim();
                text = text.substring(eqPos + 1).trim();
            }
        }
        Argument arg = new Argument(field, text, i - startPos);
        return arg;
    }

    public static ParseResult parse(String string, String filename, int line) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < string.length() && (Character.isJavaIdentifierPart(string.charAt(i)) || string.charAt(i) == '.' || string.charAt(i) == ' ')) {
            sb.append(string.charAt(i));
            ++i;
        }
        if (i == string.length() || string.charAt(i) != '(') {
            throw new BuildException(filename + ":" + line + ": Illegal expression: " + string);
        }
        ParseResult result = new ParseResult(sb.toString());
        ++i;
        Argument arg = null;
        boolean seenField = false;
        while ((arg = AttributeExpressionParser.nextArgument(string, i, filename, line)) != null) {
            if (arg.field != null) {
                seenField = true;
            }
            if (seenField && arg.field == null) {
                throw new BuildException(filename + ":" + line + ": Un-named parameters must come before the named parameters: " + string);
            }
            result.arguments.add(arg);
            i += arg.length;
        }
        return result;
    }

    public static class ParseResult {
        public final List arguments = new ArrayList();
        public final String className;

        public ParseResult(String className) {
            this.className = className;
        }

        public boolean equals(Object o) {
            return o instanceof ParseResult && this.className.equals(((ParseResult)o).className) && this.arguments.equals(((ParseResult)o).arguments);
        }

        public String toString() {
            return "[ParseResult: " + this.className + ", " + this.arguments + "]";
        }
    }

    public static class Argument {
        public final String field;
        public final String text;
        public final int length;

        public Argument(String field, String text, int length) {
            this.field = field;
            this.text = text;
            this.length = length;
        }

        public boolean equalsOrNull(String a, String b) {
            if (a == null) {
                return b == null;
            }
            return b != null && a.equals(b);
        }

        public boolean equals(Object o) {
            return o instanceof Argument && this.equalsOrNull(this.field, ((Argument)o).field) && ((Argument)o).text.equals(this.text);
        }

        public String toString() {
            return "[Argument: " + this.field + ", " + this.text + ", " + this.length + "]";
        }
    }
}

