/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spring;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.aop.ICmpAroundAspect;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.script.ScriptBean;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.util.LOGOPrinter;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ComponentScanner
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentScanner.class);
    public static Map<String, NodeComponent> nodeComponentMap = new HashMap<String, NodeComponent>();
    private LiteflowConfig liteflowConfig;
    public static ICmpAroundAspect cmpAroundAspect;

    public ComponentScanner() {
        LOGOPrinter.print();
    }

    public ComponentScanner(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        if (liteflowConfig.getPrintBanner().booleanValue()) {
            LOGOPrinter.print();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (LiteFlowProxyUtil.isDeclareCmp(bean.getClass())) {
            LOG.info("proxy component[{}] has been found", (Object)beanName);
            List nodeComponents = LiteFlowProxyUtil.proxy2NodeComponent((Object)bean, (String)beanName);
            nodeComponents.forEach(nodeComponent -> {
                String nodeId = nodeComponent.getNodeId();
                nodeId = StrUtil.isEmpty((CharSequence)nodeId) ? beanName : nodeId;
                nodeComponentMap.put(nodeId, (NodeComponent)nodeComponent);
            });
            if (nodeComponents.size() == 1) {
                return nodeComponents.get(0);
            }
            return bean;
        }
        if (NodeComponent.class.isAssignableFrom(clazz)) {
            LOG.info("component[{}] has been found", (Object)beanName);
            NodeComponent nodeComponent2 = (NodeComponent)bean;
            nodeComponentMap.put(beanName, nodeComponent2);
            return nodeComponent2;
        }
        if (ICmpAroundAspect.class.isAssignableFrom(clazz)) {
            LOG.info("component aspect implement[{}] has been found", (Object)beanName);
            cmpAroundAspect = (ICmpAroundAspect)bean;
            return cmpAroundAspect;
        }
        ScriptBean scriptBean = (ScriptBean)AnnotationUtil.getAnnotation(bean.getClass(), ScriptBean.class);
        if (ObjectUtil.isNotNull((Object)scriptBean)) {
            ScriptBeanManager.addScriptBean((String)scriptBean.value(), (Object)bean);
        }
        return bean;
    }

    public static void cleanCache() {
        nodeComponentMap.clear();
    }
}

