/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.NoSwitchTargetNodeException;
import com.yomahub.liteflow.exception.SwitchTargetCannotBePreOrFinallyException;
import com.yomahub.liteflow.exception.SwitchTypeErrorException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import java.util.HashMap;
import java.util.Map;

public class SwitchCondition
extends Condition {
    private final Map<String, Executable> targetMap = new HashMap<String, Executable>();
    private final String TAG_PREFIX = "tag";
    private final String TAG_FLAG = ":";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        String errorInfo;
        Executable targetExecutor;
        if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.SWITCH, NodeTypeEnum.SWITCH_SCRIPT}).contains((Object)this.getSwitchNode().getType())) throw new SwitchTypeErrorException("switch instance must be NodeSwitchComponent");
        this.getSwitchNode().setCurrChainName(this.getCurrChainName());
        this.getSwitchNode().execute(slotIndex);
        Slot slot = DataBus.getSlot(slotIndex);
        Class<?> originalClass = LiteFlowProxyUtil.getUserClass(this.getSwitchNode().getInstance().getClass());
        String targetId = (String)slot.getSwitchResult(originalClass.getName());
        if (!StrUtil.isNotBlank((CharSequence)targetId)) return;
        if (targetId.contains(":")) {
            String[] target = targetId.split(":", 2);
            String _targetId = target[0];
            String _targetTag = target[1];
            targetExecutor = this.targetMap.values().stream().filter(executable -> {
                if (executable instanceof Node) {
                    Node node = (Node)executable;
                    return StrUtil.startWith((CharSequence)_targetId, (CharSequence)"tag") && _targetTag.equals(node.getTag()) || (StrUtil.isEmpty((CharSequence)_targetId) || _targetId.equals(node.getId())) && (StrUtil.isEmpty((CharSequence)_targetTag) || _targetTag.equals(node.getTag()));
                }
                return false;
            }).findFirst().orElse(null);
        } else {
            targetExecutor = this.targetMap.get(targetId);
        }
        if (ObjectUtil.isNotNull((Object)targetExecutor)) {
            if (targetExecutor instanceof PreCondition || targetExecutor instanceof FinallyCondition) {
                errorInfo = StrUtil.format((CharSequence)"[{}]:switch component[{}] error, switch target node cannot be pre or finally", (Object[])new Object[]{slot.getRequestId(), this.getSwitchNode().getInstance().getDisplayName()});
                throw new SwitchTargetCannotBePreOrFinallyException(errorInfo);
            }
            targetExecutor.setCurrChainName(this.getCurrChainName());
            targetExecutor.execute(slotIndex);
            return;
        } else {
            errorInfo = StrUtil.format((CharSequence)"[{}]:no target node find for the component[{}]", (Object[])new Object[]{slot.getRequestId(), this.getSwitchNode().getInstance().getDisplayName()});
            throw new NoSwitchTargetNodeException(errorInfo);
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_SWITCH;
    }

    public void addTargetItem(Executable executable) {
        this.targetMap.put(executable.getExecuteName(), executable);
    }

    public void setSwitchNode(Node switchNode) {
        this.getExecutableList().add(switchNode);
    }

    public Map<String, Executable> getTargetMap() {
        return this.targetMap;
    }

    public Node getSwitchNode() {
        return (Node)this.getExecutableList().get(0);
    }
}

