/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoForNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;

public class ForCondition
extends LoopCondition {
    private Node forNode;

    @Override
    public void execute(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        if (ObjectUtil.isNull((Object)this.forNode)) {
            String errorInfo = StrUtil.format((CharSequence)"[{}]:no for-node found", (Object[])new Object[]{slot.getRequestId()});
            throw new NoForNodeException(errorInfo);
        }
        this.forNode.setCurrChainName(this.getCurrChainName());
        this.forNode.execute(slotIndex);
        Class<?> originalForCountClass = LiteFlowProxyUtil.getUserClass(this.forNode.getInstance().getClass());
        int forCount = slot.getForResult(originalForCountClass.getName());
        Executable executableItem = this.getDoExecutor();
        for (int i = 0; i < forCount; ++i) {
            executableItem.execute(slotIndex);
            if (!ObjectUtil.isNotNull((Object)this.breakNode)) continue;
            this.breakNode.setCurrChainName(this.getCurrChainName());
            this.breakNode.execute(slotIndex);
            Class<?> originalBreakClass = LiteFlowProxyUtil.getUserClass(this.breakNode.getInstance().getClass());
            boolean isBreak = slot.getBreakResult(originalBreakClass.getName());
            if (isBreak) break;
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_FOR;
    }

    public Executable getDoExecutor() {
        return this.getExecutableList().get(0);
    }

    public Node getForNode() {
        return this.forNode;
    }

    public void setForNode(Node forNode) {
        this.forNode = forNode;
    }
}

