/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core.proxy;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.annotation.LiteflowRetry;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.proxy.LiteFlowMethodBean;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ComponentMethodDefineErrorException;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import com.yomahub.liteflow.util.SerialsUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentProxy {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String nodeId;
    private final Object bean;
    private final Class<?> clazz;

    public ComponentProxy(String nodeId, Object bean, Class<?> clazz) {
        this.nodeId = nodeId;
        this.bean = bean;
        this.clazz = clazz;
    }

    public List<NodeComponent> getProxyList() throws Exception {
        Class<?> beanClazz = LiteFlowProxyUtil.isCglibProxyClass(this.bean.getClass()) ? LiteFlowProxyUtil.getUserClass(this.bean.getClass()) : this.bean.getClass();
        Map<String, List<Method>> methodListMap = Arrays.stream(beanClazz.getDeclaredMethods()).filter(m -> m.getAnnotation(LiteflowMethod.class) != null).collect(Collectors.groupingBy(m -> m.getAnnotation(LiteflowMethod.class).nodeId()));
        return methodListMap.entrySet().stream().map(entry -> {
            boolean legal;
            Annotation[] beanClassAnnotation = this.bean.getClass().getAnnotations();
            boolean isMethodCreate = !StrUtil.isEmpty((CharSequence)((CharSequence)entry.getKey()));
            String activeNodeId = isMethodCreate ? (String)entry.getKey() : this.nodeId;
            List tupleList = ((List)entry.getValue()).stream().map(m -> new Tuple(new Object[]{m.getAnnotation(LiteflowRetry.class), m.getAnnotation(LiteflowMethod.class)})).collect(Collectors.toList());
            List methodList = tupleList.stream().map(tuple -> (LiteflowMethod)tuple.get(1)).filter(Objects::nonNull).collect(Collectors.toList());
            List classes = methodList.stream().map(LiteflowMethod::nodeType).map(NodeTypeEnum::getMappingClazz).distinct().collect(Collectors.toList());
            boolean bl = legal = classes.size() == 1;
            if (!legal) {
                throw new LiteFlowException("The cmpClass of the same nodeId must be the same,you declared nodeId:" + activeNodeId + ",cmpClass:" + classes);
            }
            AtomicReference<Object> liteflowRetryAtomicReference = new AtomicReference<Object>(null);
            boolean illegal = tupleList.stream().anyMatch(tuple -> {
                LiteflowRetry liteflowRetry = (LiteflowRetry)tuple.get(0);
                LiteflowMethod liteflowMethod = (LiteflowMethod)tuple.get(1);
                boolean existRetry = liteflowRetry != null;
                boolean isProcess = liteflowMethod.value().isMainMethod();
                if (isProcess && existRetry) {
                    liteflowRetryAtomicReference.set(liteflowRetry);
                }
                return existRetry && !isProcess;
            });
            if (illegal) {
                throw new LiteFlowException("the retry annotation (@LiteflowRetry) must be declared on the PROCESS method");
            }
            Class<Object> cmpClazz = this.clazz;
            if (isMethodCreate) {
                cmpClazz = ((LiteflowMethod)methodList.iterator().next()).nodeType().getMappingClazz();
                LiteflowRetry liteflowRetry = liteflowRetryAtomicReference.get();
                if (liteflowRetry != null) {
                    List<Annotation> annotations = Arrays.stream(beanClassAnnotation).filter(a -> !a.annotationType().equals(LiteflowRetry.class)).collect(Collectors.toList());
                    annotations.add(liteflowRetry);
                    beanClassAnnotation = new Annotation[annotations.size()];
                    annotations.toArray(beanClassAnnotation);
                }
            }
            try {
                Object instance = new ByteBuddy().subclass(cmpClazz).name(StrUtil.format((CharSequence)"{}.ByteBuddy${}${}", (Object[])new Object[]{ClassUtil.getPackage(this.bean.getClass()), activeNodeId, SerialsUtil.generateShortUUID()})).method((ElementMatcher)ElementMatchers.namedOneOf((String[])((String[])methodList.stream().map(m -> m.value().getMethodName()).toArray(String[]::new)))).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler(this.bean))).annotateType(beanClassAnnotation).make().load(ComponentProxy.class.getClassLoader()).getLoaded().newInstance();
                NodeComponent nodeComponent = (NodeComponent)instance;
                nodeComponent.setNodeId(activeNodeId);
                return nodeComponent;
            }
            catch (Exception e) {
                throw new LiteFlowException(e);
            }
        }).collect(Collectors.toList());
    }

    public class AopInvocationHandler
    implements InvocationHandler {
        private final Object bean;

        public AopInvocationHandler(Object bean) {
            this.bean = bean;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            List liteFlowMethodBeanList = Arrays.stream(ReflectUtil.getMethods(this.bean.getClass())).filter(m -> {
                LiteflowMethod liteFlowMethod = m.getAnnotation(LiteflowMethod.class);
                return ObjectUtil.isNotNull((Object)liteFlowMethod);
            }).filter(m -> {
                LiteflowMethod liteFlowMethod = m.getAnnotation(LiteflowMethod.class);
                return StrUtil.isEmpty((CharSequence)liteFlowMethod.nodeId()) || Objects.equals(liteFlowMethod.nodeId(), ((NodeComponent)proxy).getNodeId());
            }).map(m -> {
                LiteflowMethod liteFlowMethod = m.getAnnotation(LiteflowMethod.class);
                return new LiteFlowMethodBean(liteFlowMethod.value().getMethodName(), (Method)m);
            }).collect(Collectors.toList());
            LiteFlowMethodBean liteFlowMethodBean = liteFlowMethodBeanList.stream().filter(liteFlowMethodBean1 -> liteFlowMethodBean1.getMethodName().equals(method.getName())).findFirst().orElse(null);
            if (!ListUtil.toList((Object[])new String[]{"beforeProcess", "afterProcess"}).contains(liteFlowMethodBean.getMethodName())) {
                boolean checkFlag;
                boolean bl = checkFlag = liteFlowMethodBean.getMethod().getParameterTypes().length == 1 && Arrays.asList(liteFlowMethodBean.getMethod().getParameterTypes()).contains(NodeComponent.class);
                if (!checkFlag) {
                    String errMsg = StrUtil.format((CharSequence)"Method[{}.{}] must have NodeComponent parameter(and only one parameter)", (Object[])new Object[]{this.bean.getClass().getName(), liteFlowMethodBean.getMethod().getName()});
                    ComponentProxy.this.LOG.error(errMsg);
                    throw new ComponentMethodDefineErrorException(errMsg);
                }
                try {
                    return liteFlowMethodBean.getMethod().invoke(this.bean, proxy);
                }
                catch (Exception e) {
                    InvocationTargetException targetEx = (InvocationTargetException)e;
                    throw targetEx.getTargetException();
                }
            }
            try {
                return liteFlowMethodBean.getMethod().invoke(this.bean, args);
            }
            catch (Exception e) {
                InvocationTargetException targetEx = (InvocationTargetException)e;
                throw targetEx.getTargetException();
            }
        }
    }
}

