/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.op.OperatorBase;
import com.yomahub.liteflow.builder.el.operator.AnyOperator;
import com.yomahub.liteflow.builder.el.operator.BreakOperator;
import com.yomahub.liteflow.builder.el.operator.DataOperator;
import com.yomahub.liteflow.builder.el.operator.DoOperator;
import com.yomahub.liteflow.builder.el.operator.ElifOperator;
import com.yomahub.liteflow.builder.el.operator.ElseOperator;
import com.yomahub.liteflow.builder.el.operator.FinallyOperator;
import com.yomahub.liteflow.builder.el.operator.ForOperator;
import com.yomahub.liteflow.builder.el.operator.IdOperator;
import com.yomahub.liteflow.builder.el.operator.IfOperator;
import com.yomahub.liteflow.builder.el.operator.IgnoreErrorOperator;
import com.yomahub.liteflow.builder.el.operator.NodeOperator;
import com.yomahub.liteflow.builder.el.operator.PreOperator;
import com.yomahub.liteflow.builder.el.operator.SwitchOperator;
import com.yomahub.liteflow.builder.el.operator.TagOperator;
import com.yomahub.liteflow.builder.el.operator.ThenOperator;
import com.yomahub.liteflow.builder.el.operator.ThreadPoolOperator;
import com.yomahub.liteflow.builder.el.operator.ToOperator;
import com.yomahub.liteflow.builder.el.operator.WhenOperator;
import com.yomahub.liteflow.builder.el.operator.WhileOperator;
import com.yomahub.liteflow.exception.ELParseException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LiteFlowChainELBuilder {
    private Chain chain = new Chain();
    private final List<Condition> conditionList = new ArrayList<Condition>();
    private final List<Condition> preConditionList = new ArrayList<Condition>();
    private final List<Condition> finallyConditionList = new ArrayList<Condition>();
    private static final ExpressRunner EXPRESS_RUNNER = new ExpressRunner();

    public static LiteFlowChainELBuilder createChain() {
        return new LiteFlowChainELBuilder();
    }

    public LiteFlowChainELBuilder setChainName(String chainName) {
        if (FlowBus.containChain(chainName)) {
            this.chain = FlowBus.getChain(chainName);
        } else {
            this.chain.setChainName(chainName);
        }
        return this;
    }

    public LiteFlowChainELBuilder setChainId(String chainId) {
        if (FlowBus.containChain(chainId)) {
            this.chain = FlowBus.getChain(chainId);
        } else {
            this.chain.setChainId(chainId);
        }
        return this;
    }

    public LiteFlowChainELBuilder setEL(String elStr) {
        if (StrUtil.isBlank((CharSequence)elStr)) {
            String errMsg = StrUtil.format((CharSequence)"no conditionList in this chain[{}]", (Object[])new Object[]{this.chain.getChainName()});
            throw new FlowSystemException(errMsg);
        }
        ArrayList errorList = new ArrayList();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getChainMap().values().forEach(chain -> context.put((Object)chain.getChainName(), chain));
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode(nodeId)));
            Condition condition = (Condition)EXPRESS_RUNNER.execute(elStr, (IExpressContext)context, errorList, true, true);
            for (Executable executable : condition.getExecutableList()) {
                if (executable instanceof PreCondition) {
                    this.preConditionList.add((PreCondition)executable);
                    continue;
                }
                if (!(executable instanceof FinallyCondition)) continue;
                this.finallyConditionList.add((FinallyCondition)executable);
            }
            this.conditionList.add(condition);
            return this;
        }
        catch (QLException e) {
            if (Objects.equals(e.getCause().getMessage(), "DataNofFoundException")) {
                throw new ELParseException(String.format("[node/chain is not exist or node/chain not register]elStr=%s", elStr));
            }
            throw new ELParseException(e.getCause().getMessage());
        }
        catch (Exception e) {
            throw new ELParseException(e.getMessage());
        }
    }

    public void build() {
        this.chain.setConditionList(this.conditionList);
        this.chain.setPreConditionList(this.preConditionList);
        this.chain.setFinallyConditionList(this.finallyConditionList);
        this.checkBuild();
        FlowBus.addChain(this.chain);
    }

    private void checkBuild() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.chain.getChainName())) {
            errorList.add("name is blank");
        }
        if (CollUtil.isNotEmpty(errorList)) {
            throw new RuntimeException(CollUtil.join(errorList, (CharSequence)",", (String)"[", (String)"]"));
        }
    }

    static {
        EXPRESS_RUNNER.addFunction("THEN", (OperatorBase)new ThenOperator());
        EXPRESS_RUNNER.addFunction("WHEN", (OperatorBase)new WhenOperator());
        EXPRESS_RUNNER.addFunction("SWITCH", (OperatorBase)new SwitchOperator());
        EXPRESS_RUNNER.addFunction("PRE", (OperatorBase)new PreOperator());
        EXPRESS_RUNNER.addFunction("FINALLY", (OperatorBase)new FinallyOperator());
        EXPRESS_RUNNER.addFunction("IF", (OperatorBase)new IfOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ELSE", Object.class, (OperatorBase)new ElseOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ELIF", Object.class, (OperatorBase)new ElifOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("TO", Object.class, (OperatorBase)new ToOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("to", Object.class, (OperatorBase)new ToOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("tag", Object.class, (OperatorBase)new TagOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("any", Object.class, (OperatorBase)new AnyOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("id", Object.class, (OperatorBase)new IdOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ignoreError", Object.class, (OperatorBase)new IgnoreErrorOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("threadPool", Object.class, (OperatorBase)new ThreadPoolOperator());
        EXPRESS_RUNNER.addFunction("NODE", (OperatorBase)new NodeOperator());
        EXPRESS_RUNNER.addFunction("node", (OperatorBase)new NodeOperator());
        EXPRESS_RUNNER.addFunction("FOR", (OperatorBase)new ForOperator());
        EXPRESS_RUNNER.addFunction("WHILE", (OperatorBase)new WhileOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("DO", Object.class, (OperatorBase)new DoOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("BREAK", Object.class, (OperatorBase)new BreakOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("data", Object.class, (OperatorBase)new DataOperator());
    }
}

