/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.jsonrpc;

import com.google.gson.JsonElement;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.http.HttpTool;
import com.xxl.tool.jsonrpc.model.JsonRpcRequest;
import com.xxl.tool.jsonrpc.model.JsonRpcResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClient {
    private static Logger logger = LoggerFactory.getLogger(JsonRpcClient.class);
    private String url;
    private int timeout = 3000;
    private Map<String, String> headers = null;

    public static JsonRpcClient newClient() {
        return new JsonRpcClient();
    }

    public JsonRpcClient url(String url) {
        this.url = url;
        return this;
    }

    public JsonRpcClient timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public JsonRpcClient header(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public JsonRpcClient header(String key, String value) {
        if (StringTool.isBlank(key) || Objects.isNull(value)) {
            return this;
        }
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public <T> T proxy(Class<T> serviceInterface) {
        return this.proxy(null, serviceInterface);
    }

    public <T> T proxy(String service, Class<T> serviceInterface) {
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (proxy, method, args) -> {
            String serviceName = service != null ? service : serviceInterface.getName();
            String methodName = method.getName();
            Type responseType = method.getGenericReturnType();
            Class typeOfResponse = null;
            Type[] typeArguments = null;
            if (responseType == Void.TYPE) {
                typeOfResponse = null;
            } else if (responseType instanceof ParameterizedType) {
                typeOfResponse = (Class)((ParameterizedType)responseType).getRawType();
                typeArguments = ((ParameterizedType)responseType).getActualTypeArguments();
            } else {
                typeOfResponse = (Class)responseType;
            }
            return this.invoke(serviceName, methodName, args, typeOfResponse, typeArguments);
        });
    }

    public <T> T invoke(String service, String method, Object[] params, Class<T> responseType) {
        return this.invoke(service, method, params, responseType, null);
    }

    public <T> T invoke(String service, String method, Object[] params, Class<T> responseType, Type[] typeArguments) {
        try {
            JsonElement[] paramJsons = null;
            if (params != null) {
                paramJsons = new JsonElement[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramJsons[i] = GsonTool.toJsonElement(params[i]);
                }
            }
            JsonRpcRequest request = new JsonRpcRequest(service, method, paramJsons);
            String requestJson = GsonTool.toJson(request);
            String responseData = HttpTool.createPost(this.url).connectTimeout(this.timeout).readTimeout(this.timeout).header(this.headers).body(requestJson).execute().response();
            if (responseData.isEmpty()) {
                throw new RuntimeException("response data not found");
            }
            JsonRpcResponse response = GsonTool.fromJson(responseData, JsonRpcResponse.class);
            if (response.isError()) {
                throw new RuntimeException("invoke error: " + response.getError());
            }
            if (responseType == null) {
                return null;
            }
            if (typeArguments != null) {
                return GsonTool.fromJsonElement(response.getResult(), responseType, typeArguments);
            }
            return GsonTool.fromJsonElement(response.getResult(), responseType);
        }
        catch (Throwable e) {
            throw new RuntimeException("invoke error[2], service:" + service + ", method:" + method, e);
        }
    }
}

