/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.io;

import com.xxl.tool.core.AssertTool;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class IOTool {
    public static final int BUFFER_SIZE = 8192;

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOTool.copy(input, output, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output, boolean closeInput, boolean closeOutput) throws IOException {
        AssertTool.notNull(input, "No InputStream specified");
        AssertTool.notNull(output, "No OutputStream specified");
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            output.flush();
            int n = byteCount;
            return n;
        }
        finally {
            if (closeInput) {
                IOTool.close(input);
            }
            if (closeOutput) {
                IOTool.close(output);
            }
        }
    }

    public static void copy(byte[] input, OutputStream output) throws IOException {
        IOTool.copy(input, output, true);
    }

    public static void copy(byte[] input, OutputStream output, boolean closeOutput) throws IOException {
        AssertTool.notNull(input, "No input byte array specified");
        AssertTool.notNull(output, "No OutputStream specified");
        try {
            output.write(input);
        }
        finally {
            if (closeOutput) {
                IOTool.close(output);
            }
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        IOTool.copy(inputStream, (OutputStream)out);
        return out.toByteArray();
    }

    public static String readString(InputStream inputStream) throws IOException {
        return IOTool.readString(inputStream, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream inputStream, Charset charset) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(8192);
        InputStreamReader reader = null;
        try {
            int charsRead;
            reader = new InputStreamReader(inputStream, charset);
            char[] buffer = new char[8192];
            while ((charsRead = reader.read(buffer)) != -1) {
                out.append(buffer, 0, charsRead);
            }
        }
        finally {
            IOTool.close(inputStream);
            IOTool.close(reader);
        }
        return out.toString();
    }

    public static void writeString(String data, OutputStream output) throws IOException {
        IOTool.writeString(data, output, StandardCharsets.UTF_8);
    }

    public static void writeString(String data, OutputStream output, Charset charset) throws IOException {
        if (data == null) {
            return;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        Channels.newChannel(output).write(charset.encode(data));
    }

    public static BufferedWriter newBufferedWriter(File file, boolean append) throws IOException {
        return IOTool.newBufferedWriter(file, append, StandardCharsets.UTF_8, 8192);
    }

    public static BufferedWriter newBufferedWriter(File file, boolean append, Charset charset, int bufferSize) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset), bufferSize);
    }
}

