/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.http.client;

import com.xxl.tool.core.MapTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.http.HttpTool;
import com.xxl.tool.http.client.HttpClientMethod;
import com.xxl.tool.http.client.HttpClientService;
import com.xxl.tool.http.http.HttpRequest;
import com.xxl.tool.http.http.enums.ContentType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpClient {
    private String url;
    private Map<String, String> headers;
    private Map<String, String> cookies;
    private int timeout = 3000;
    private String auth;

    public HttpClient url(String url) {
        this.url = url;
        return this;
    }

    public HttpClient header(Map<String, String> header) {
        if (MapTool.isEmpty(header)) {
            return this;
        }
        if (MapTool.isNotEmpty(this.headers)) {
            this.headers.clear();
        }
        for (String key : header.keySet()) {
            this.header(key, header.get(key));
        }
        return this;
    }

    public HttpClient header(String key, String value) {
        if (StringTool.isBlank(key) || Objects.isNull(value)) {
            return this;
        }
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpClient cookie(Map<String, String> cookie) {
        if (MapTool.isEmpty(cookie)) {
            return this;
        }
        if (MapTool.isNotEmpty(this.cookies)) {
            this.cookies.clear();
        }
        for (String key : cookie.keySet()) {
            this.cookie(key, cookie.get(key));
        }
        return this;
    }

    public HttpClient cookie(String key, String value) {
        if (StringTool.isBlank(key) || Objects.isNull(value)) {
            return this;
        }
        if (null == this.cookies) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(key, value);
        return this;
    }

    public HttpClient timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpClient auth(String auth) {
        this.auth = auth;
        return this;
    }

    public <T> T proxy(Class<T> serviceInterface) {
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (proxy, method, args) -> this.invoke(serviceInterface, method, args));
    }

    private <T> T invoke(Class<T> serviceInterface, Method method, Object[] params) {
        HttpClientService httpClientService = serviceInterface.getAnnotation(HttpClientService.class);
        HttpClientMethod httpClientMethod = method.getAnnotation(HttpClientMethod.class);
        Type responseType = method.getGenericReturnType();
        String baseUrl = this.url;
        if (StringTool.isBlank(baseUrl) && httpClientService != null && StringTool.isNotBlank(httpClientService.url())) {
            baseUrl = httpClientService.url();
        }
        if (StringTool.isBlank(baseUrl)) {
            throw new RuntimeException("http client invoke fail, baseUrl is null");
        }
        baseUrl = StringTool.removeSuffix(baseUrl, "/");
        String servicePathFinal = HttpClient.parseServicePath(httpClientService, serviceInterface);
        String methodPathFinal = HttpClient.parseMethodPath(httpClientMethod, method);
        String finalUrl = StringTool.isNotBlank(servicePathFinal) ? baseUrl + "/" + servicePathFinal + "/" + methodPathFinal : baseUrl + "/" + methodPathFinal;
        int methodTimeout = -1;
        if (httpClientMethod != null && httpClientMethod.timeout() > 0) {
            methodTimeout = httpClientMethod.timeout();
        } else if (httpClientService != null && httpClientService.timeout() > 0) {
            methodTimeout = httpClientService.timeout();
        } else if (this.timeout > 0) {
            methodTimeout = this.timeout;
        }
        if (methodTimeout <= 0) {
            throw new RuntimeException("http client invoke fail, timeout invalid");
        }
        Object[] request = null;
        if (params != null) {
            request = params.length == 1 ? params[0] : params;
        }
        Class typeOfT = null;
        Type[] typeArguments = null;
        if (responseType instanceof ParameterizedType) {
            typeOfT = (Class)((ParameterizedType)responseType).getRawType();
            typeArguments = ((ParameterizedType)responseType).getActualTypeArguments();
        } else {
            typeOfT = responseType == Void.TYPE ? null : (Class)responseType;
        }
        HttpRequest httpRequest = HttpTool.createPost(finalUrl).contentType(ContentType.JSON).header(this.headers).cookie(this.cookies).connectTimeout(methodTimeout).readTimeout(methodTimeout).useCaches(false).auth(this.auth).request(request);
        if (typeOfT != null) {
            return httpRequest.execute().response(typeOfT, typeArguments);
        }
        httpRequest.execute();
        return null;
    }

    public static String parseServicePath(HttpClientService httpRpcService, Class<?> serviceInterface) {
        String servicePathFinal = null;
        if (httpRpcService != null && StringTool.isNotBlank(httpRpcService.path())) {
            servicePathFinal = httpRpcService.path();
        }
        servicePathFinal = StringTool.removePrefix(servicePathFinal, "/");
        servicePathFinal = StringTool.removeSuffix(servicePathFinal, "/");
        return servicePathFinal;
    }

    public static String parseMethodPath(HttpClientMethod httpRpcMethod, Method method) {
        String methodPath = httpRpcMethod != null && StringTool.isNotBlank(httpRpcMethod.path()) ? httpRpcMethod.path() : method.getName();
        methodPath = StringTool.removePrefix(methodPath, "/");
        methodPath = StringTool.removeSuffix(methodPath, "/");
        return methodPath;
    }
}

