/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.http;

import com.xxl.tool.core.MapTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.http.client.HttpClient;
import com.xxl.tool.http.http.HttpRequest;
import com.xxl.tool.http.http.enums.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTool {
    private static final Logger logger = LoggerFactory.getLogger(HttpTool.class);

    public static HttpRequest createRequest() {
        return new HttpRequest();
    }

    public static HttpRequest createRequest(String url) {
        return new HttpRequest().url(url).method(Method.POST);
    }

    public static HttpRequest createGet(String url) {
        return new HttpRequest().url(url).method(Method.GET);
    }

    public static HttpRequest createPost(String url) {
        return new HttpRequest().url(url).method(Method.POST);
    }

    public static HttpClient createClient() {
        return new HttpClient();
    }

    public static boolean isHttps(String url) {
        return url != null && url.toLowerCase().startsWith("https:");
    }

    public static boolean isHttp(String url) {
        return url != null && url.toLowerCase().startsWith("http:");
    }

    public static String generateUrlParam(Map<String, String> map) {
        if (MapTool.isEmpty(map)) {
            return null;
        }
        StringBuilder param = new StringBuilder();
        for (String key : map.keySet()) {
            if (!param.isEmpty()) {
                param.append("&");
            }
            param.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(map.get(key), StandardCharsets.UTF_8));
        }
        return param.toString();
    }

    public static Map<String, String> parseUrlParam(String url) {
        url = url != null && url.contains("?") ? url.substring(url.indexOf("?") + 1) : url;
        HashMap<String, String> map = MapTool.newMap();
        if (StringTool.isNotBlank(url)) {
            String[] params;
            for (String param : params = url.split("&")) {
                String[] kv = param.split("=");
                if (kv.length != 2) continue;
                map.put(kv[0], kv[1]);
            }
        }
        return map;
    }
}

