/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.emoji.model;

import com.xxl.tool.emoji.exception.XxlEmojiException;
import com.xxl.tool.emoji.fitzpatrick.Fitzpatrick;
import java.util.Collections;
import java.util.List;

public class Emoji {
    private final String unicode;
    private final List<String> aliases;
    private final List<String> tags;
    private final boolean supportsFitzpatrick;
    private final String htmlDec;
    private final String htmlHex;

    public Emoji(String unicode, List<String> aliases, List<String> tags, boolean supportsFitzpatrick) {
        int codePoint;
        this.unicode = unicode;
        this.aliases = Collections.unmodifiableList(aliases);
        this.tags = Collections.unmodifiableList(tags);
        this.supportsFitzpatrick = supportsFitzpatrick;
        int stringLength = this.getUnicode().length();
        String[] pointCodes = new String[stringLength];
        String[] pointCodesHex = new String[stringLength];
        int count = 0;
        for (int offset = 0; offset < stringLength; offset += Character.charCount(codePoint)) {
            codePoint = this.getUnicode().codePointAt(offset);
            pointCodes[count] = String.format("&#%d;", codePoint);
            pointCodesHex[count++] = String.format("&#x%x;", codePoint);
        }
        this.htmlDec = this.stringJoin(pointCodes, count);
        this.htmlHex = this.stringJoin(pointCodesHex, count);
    }

    private String stringJoin(String[] array, int count) {
        Object joined = "";
        for (int i = 0; i < count; ++i) {
            joined = (String)joined + array[i];
        }
        return joined;
    }

    public boolean supportsFitzpatrick() {
        return this.supportsFitzpatrick;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public String getHtmlDecimal() {
        return this.htmlDec;
    }

    public String getHtmlHexadecimal() {
        return this.htmlHex;
    }

    public String getUnicode(Fitzpatrick fitzpatrick) {
        if (!this.supportsFitzpatrick()) {
            throw new XxlEmojiException("cannot get unicode with given fitzpatrick modifier, the emoji doesn't support fitzpatrick.");
        }
        if (fitzpatrick == null) {
            return this.getUnicode();
        }
        return this.getUnicode() + fitzpatrick.unicode;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Emoji && ((Emoji)other).getUnicode().equals(this.getUnicode());
    }

    public int hashCode() {
        return this.unicode.hashCode();
    }
}

