/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache.impl;

import com.xxl.tool.cache.impl.ReentrantCache;
import com.xxl.tool.cache.model.CacheObject;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFUCache<K, V>
extends ReentrantCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(LFUCache.class);
    private static final long serialVersionUID = 42L;

    public LFUCache(int capacity, long timeout, boolean expireType) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must large than 0");
        }
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.expireType = expireType;
        this.cacheMap = new ConcurrentHashMap(capacity + 1, 1.0f);
    }

    @Override
    protected int doPrune() {
        int count = 0;
        CacheObject leastVisitedCacheObject = null;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObject cacheObject = values.next();
            if (cacheObject.isExpired()) {
                values.remove();
                this.onRemove(cacheObject);
                ++count;
                continue;
            }
            if (leastVisitedCacheObject != null && cacheObject.getAccessCount().get() >= leastVisitedCacheObject.getAccessCount().get()) continue;
            leastVisitedCacheObject = cacheObject;
        }
        if (this.isFull() && leastVisitedCacheObject != null) {
            this.removeWithoutLock(leastVisitedCacheObject.getKey());
            this.onRemove(leastVisitedCacheObject);
            ++count;
            long minAccessCount = leastVisitedCacheObject.getAccessCount().get();
            for (CacheObject cacheObject : this.cacheMap.values()) {
                cacheObject.getAccessCount().addAndGet(-minAccessCount);
            }
        }
        return count;
    }
}

