/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.jsonrpc.model;

import com.google.gson.JsonElement;
import com.xxl.tool.jsonrpc.model.JsonRpcResponseError;
import java.io.Serializable;

public class JsonRpcResponse
implements Serializable {
    public static final long serialVersionUID = 42L;
    JsonRpcResponseError error;
    JsonElement result;

    public JsonRpcResponseError getError() {
        return this.error;
    }

    public void setError(JsonRpcResponseError error) {
        this.error = error;
    }

    public JsonElement getResult() {
        return this.result;
    }

    public void setResult(JsonElement result) {
        this.result = result;
    }

    public String toString() {
        return "JsonRpcResponse{error=" + this.error + ", result=" + this.result + "}";
    }

    public boolean isSuccess() {
        return !this.isError();
    }

    public boolean isError() {
        return this.error != null && this.error.getCode() > 0;
    }

    public static JsonRpcResponse ofSuccess(JsonElement result) {
        JsonRpcResponse response = new JsonRpcResponse();
        response.setResult(result);
        return response;
    }

    public static JsonRpcResponse ofError(String error) {
        JsonRpcResponse response = new JsonRpcResponse();
        response.setError(new JsonRpcResponseError(3000, error));
        return response;
    }

    public static JsonRpcResponse ofError(int errorCode, String errorMsg) {
        JsonRpcResponse response = new JsonRpcResponse();
        response.setError(new JsonRpcResponseError(errorCode, errorMsg));
        return response;
    }
}

