/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.jsonrpc;

import com.google.gson.JsonElement;
import com.xxl.tool.core.MapTool;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.jsonrpc.model.JsonRpcRequest;
import com.xxl.tool.jsonrpc.model.JsonRpcResponse;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcServer {
    private static final Logger logger = LoggerFactory.getLogger(JsonRpcServer.class);
    private final Map<String, Object> serviceStore = new ConcurrentHashMap<String, Object>();

    public static JsonRpcServer newServer() {
        return new JsonRpcServer();
    }

    public JsonRpcServer register(String service, Object serviceInstance) {
        this.serviceStore.put(service, serviceInstance);
        return this;
    }

    public JsonRpcServer register(Map<String, Object> initServiceStore) {
        if (MapTool.isEmpty(initServiceStore)) {
            return this;
        }
        for (Map.Entry<String, Object> entry : initServiceStore.entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String invoke(String requestBody) {
        JsonRpcRequest jsonRpcRequest = GsonTool.fromJson(requestBody, JsonRpcRequest.class);
        JsonRpcResponse jsonRpcResponse = this.doInvoke(jsonRpcRequest);
        return GsonTool.toJson(jsonRpcResponse);
    }

    private JsonRpcResponse doInvoke(JsonRpcRequest request) {
        String service = request.getService();
        String method = request.getMethod();
        JsonElement[] params = request.getParams();
        try {
            Object serviceInstance = this.serviceStore.get(service);
            if (serviceInstance == null) {
                return JsonRpcResponse.ofError(3001, "service[" + service + "] not found.");
            }
            Method methodObj = null;
            for (Method m : serviceInstance.getClass().getMethods()) {
                if (!m.getName().equals(method)) continue;
                methodObj = m;
                break;
            }
            if (methodObj == null) {
                return JsonRpcResponse.ofError(3002, "method [" + method + "] not found.");
            }
            Object[] parameters = null;
            Class<?>[] parameterTypes = methodObj.getParameterTypes();
            if (parameterTypes.length > 0) {
                if (params == null || params.length != parameterTypes.length) {
                    return JsonRpcResponse.ofError(3003, "method[" + method + "] params number not match.");
                }
                parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = GsonTool.fromJsonElement(params[i], parameterTypes[i]);
                }
            }
            methodObj.setAccessible(true);
            Object resultObj = methodObj.invoke(serviceInstance, parameters);
            JsonElement resultJson = GsonTool.toJsonElement(resultObj);
            return JsonRpcResponse.ofSuccess(resultJson);
        }
        catch (Exception e) {
            logger.error("server invoke error:{}", (Object)e.getMessage(), (Object)e);
            return JsonRpcResponse.ofError("server invoke error: " + e.getMessage());
        }
    }
}

