/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.id;

public class SnowflakeIdTool {
    private final long workerId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;
    private static final long WORKER_BITS = 10L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_SEQUENCE = 4095L;

    public SnowflakeIdTool(long workerId) {
        if (workerId > this.getMaxWorkerId() || workerId < 0L) {
            throw new IllegalArgumentException("workerId is illegal");
        }
        this.workerId = workerId;
    }

    private long getMaxWorkerId() {
        return 1023L;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("\u65f6\u949f\u56de\u62e8");
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp << 22 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

