/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.id;

import com.xxl.tool.core.StringTool;
import java.util.Random;

public class RandomIdTool {
    private static final int DEFAULT_LENGTH = 20;
    private static final String DIGITS = "0123456789";
    private static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String SPECIAL_CHARS = "!@#$%^&*()-_=+[]{}|;:,.<>?/";

    public static String getDigitId() {
        return RandomIdTool.getDigitId(20);
    }

    public static String getDigitId(int length) {
        return RandomIdTool.getRandomId(DIGITS, length);
    }

    public static String getLowercaseId() {
        return RandomIdTool.getLowercaseId(20);
    }

    public static String getLowercaseId(int length) {
        return RandomIdTool.getRandomId(LOWERCASE, length);
    }

    public static String getUppercaseId() {
        return RandomIdTool.getUppercaseId(20);
    }

    public static String getUppercaseId(int length) {
        return RandomIdTool.getRandomId(UPPERCASE, length);
    }

    public static String getAlphaNumeric() {
        return RandomIdTool.getAlphaNumeric(20);
    }

    public static String getAlphaNumeric(int length) {
        String alphaNumeric = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        return RandomIdTool.getRandomId(alphaNumeric, length);
    }

    public static String getAlphaNumericWithSpecial() {
        return RandomIdTool.getAlphaNumericWithSpecial(20);
    }

    public static String getAlphaNumericWithSpecial(int length) {
        String allChars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*()-_=+[]{}|;:,.<>?/";
        return RandomIdTool.getRandomId(allChars, length);
    }

    public static String getRandomId(String characters, int length) {
        if (length < 1 || length > 1000) {
            throw new IllegalArgumentException("random length must be between 1 and 1000.");
        }
        if (StringTool.isBlank(characters)) {
            throw new IllegalArgumentException("random characters can't be empty.");
        }
        StringBuilder sb = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            sb.append(characters.charAt(index));
        }
        return sb.toString();
    }
}

