/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.http.http;

import com.xxl.tool.core.StringTool;
import com.xxl.tool.gson.GsonTool;
import java.lang.reflect.Type;
import java.util.Map;

public class HttpResponse {
    private int statusCode;
    private String response;
    private String url;
    private Map<String, String> cookies;

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public boolean isSuccess() {
        return this.statusCode == 200;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String response() {
        return this.response;
    }

    public <T> T response(Class<T> typeOfT, Type ... typeArguments) {
        if (StringTool.isBlank(this.response) || typeOfT == null) {
            return null;
        }
        if (!this.isSuccess()) {
            throw new RuntimeException("Http Request fail, statusCode(" + this.statusCode + ") for url : " + this.url);
        }
        if (typeArguments != null && typeArguments.length > 0 && typeArguments[0] != null) {
            return GsonTool.fromJson(this.response, typeOfT, typeArguments);
        }
        return GsonTool.fromJson(this.response, typeOfT);
    }

    public String url() {
        return this.url;
    }

    public Map<String, String> cookies() {
        return this.cookies;
    }

    public String cookie(String key) {
        return this.cookies != null ? this.cookies.get(key) : null;
    }
}

