/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.http;

import com.xxl.tool.core.MapTool;
import com.xxl.tool.core.StringTool;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTool1 {
    private static Logger logger = LoggerFactory.getLogger(HttpTool1.class);
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};

    private static void trustAllHosts(HttpsURLConnection connection) {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        connection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    private static String doRequest(String method, String url, String requestBody, Map<String, String> headers, int timeout) {
        HttpURLConnection connection = null;
        FilterOutputStream dataOutputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String responseBody;
            String line;
            int statusCode;
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            boolean useHttps = url.startsWith("https");
            if (useHttps) {
                HttpsURLConnection https = (HttpsURLConnection)connection;
                HttpTool1.trustAllHosts(https);
            }
            connection.setRequestMethod(method);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setReadTimeout(timeout);
            connection.setConnectTimeout(3000);
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("Accept-Charset", "application/json;charset=UTF-8");
            if (MapTool.isNotEmpty(headers)) {
                for (String key : headers.keySet()) {
                    connection.setRequestProperty(key, headers.get(key));
                }
            }
            connection.connect();
            if (StringTool.isNotBlank(requestBody)) {
                dataOutputStream = new DataOutputStream(connection.getOutputStream());
                dataOutputStream.write(requestBody.getBytes(StandardCharsets.UTF_8));
                ((DataOutputStream)dataOutputStream).flush();
                dataOutputStream.close();
            }
            if ((statusCode = connection.getResponseCode()) != 200) {
                throw new RuntimeException("StatusCode(" + statusCode + ") invalid. for url : " + url);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder result = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line);
            }
            String string = responseBody = result.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Http Request Error (" + e.getMessage() + "). for url : " + url);
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    public static String postBody(String url, String requestBody, Map<String, String> headers, int timeout) {
        return HttpTool1.doRequest("POST", url, requestBody, headers, timeout);
    }

    public static String postBody(String url, String requestBody, int timeout) {
        return HttpTool1.doRequest("POST", url, requestBody, null, timeout);
    }

    public static String postBody(String url, String requestBody) {
        return HttpTool1.doRequest("POST", url, requestBody, null, 1000);
    }

    public static String get(String url, int timeout, Map<String, String> headers) {
        return HttpTool1.doRequest("POST", url, null, headers, timeout);
    }

    public static String get(String url, int timeout) {
        return HttpTool1.doRequest("POST", url, null, null, timeout);
    }

    public static String get(String url) {
        return HttpTool1.doRequest("POST", url, null, null, 1000);
    }
}

