/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache.model;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class CacheObject<K, V>
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final K key;
    private final V value;
    private volatile long lastAccess;
    private volatile long createTime;
    private volatile boolean expireType;
    private final AtomicLong accessCount = new AtomicLong();
    private final long ttl;

    public CacheObject(K key, V value, long ttl, boolean expireType) {
        this.key = key;
        this.value = value;
        this.ttl = ttl;
        this.createTime = System.currentTimeMillis();
        this.lastAccess = System.currentTimeMillis();
        this.expireType = expireType;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Date getExpiredTime() {
        if (this.ttl > 0L) {
            return new Date(this.lastAccess + this.ttl);
        }
        return null;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public String toString() {
        return "CacheObject{key=" + this.key + ", value=" + this.value + ", lastAccess=" + this.lastAccess + ", createTime=" + this.createTime + ", accessCount=" + this.accessCount + ", ttl=" + this.ttl + "}";
    }

    public boolean isExpired() {
        if (this.ttl > 0L) {
            if (this.expireType) {
                return System.currentTimeMillis() - this.createTime > this.ttl;
            }
            return System.currentTimeMillis() - this.lastAccess > this.ttl;
        }
        return false;
    }

    public V get(boolean isUpdateLastAccess) {
        if (isUpdateLastAccess) {
            this.lastAccess = System.currentTimeMillis();
        }
        this.accessCount.getAndIncrement();
        return this.value;
    }

    public AtomicLong getAccessCount() {
        return this.accessCount;
    }
}

