/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache.impl;

import com.xxl.tool.cache.impl.ReentrantCache;
import com.xxl.tool.cache.model.CacheKey;
import com.xxl.tool.cache.model.CacheObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V>
extends ReentrantCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(LRUCache.class);
    private static final long serialVersionUID = 42L;

    public LRUCache(int capacity, long timeout, boolean expireType) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must large than 0");
        }
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.expireType = expireType;
        final int finalCapacity = capacity;
        this.cacheMap = new LinkedHashMap<CacheKey<K>, CacheObject<K, V>>(finalCapacity + 1, 1.0f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<CacheKey<K>, CacheObject<K, V>> eldest) {
                if (this.size() > finalCapacity) {
                    if (null != LRUCache.this.listener) {
                        try {
                            LRUCache.this.listener.onRemove(eldest.getValue().getKey(), eldest.getValue().getValue());
                        }
                        catch (Exception e) {
                            logger.error("cache listener onRemove error, cacheObject:{}", eldest, (Object)e);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected int doPrune() {
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObject cacheObject = values.next();
            if (!cacheObject.isExpired()) continue;
            values.remove();
            this.onRemove(cacheObject);
            ++count;
        }
        return count;
    }
}

