/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.executor.impl;

import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.glue.GlueFactory;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.handler.impl.MethodJobHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class XxlJobSpringExecutor
extends XxlJobExecutor
implements ApplicationContextAware,
SmartInitializingSingleton,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobSpringExecutor.class);
    private static ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        this.initJobHandlerMethodRepository(applicationContext);
        GlueFactory.refreshInstance(1);
        try {
            super.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private void initJobHandlerMethodRepository(ApplicationContext applicationContext) {
        String[] beanDefinitionNames;
        if (applicationContext == null) {
            return;
        }
        for (String beanDefinitionName : beanDefinitionNames = applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<XxlJob>(){

                    public XxlJob inspect(Method method) {
                        return (XxlJob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlJob.class);
                    }
                });
            }
            catch (Throwable ex) {
                logger.error("xxl-job method-jobhandler resolve error for bean[" + beanDefinitionName + "].", ex);
            }
            if (annotatedMethods == null || annotatedMethods.isEmpty()) continue;
            for (Map.Entry methodXxlJobEntry : annotatedMethods.entrySet()) {
                Method executeMethod = (Method)methodXxlJobEntry.getKey();
                XxlJob xxlJob = (XxlJob)methodXxlJobEntry.getValue();
                if (xxlJob == null) continue;
                String name = xxlJob.value();
                if (name.trim().length() == 0) {
                    throw new RuntimeException("xxl-job method-jobhandler name invalid, for[" + bean.getClass() + "#" + executeMethod.getName() + "] .");
                }
                if (XxlJobSpringExecutor.loadJobHandler(name) != null) {
                    throw new RuntimeException("xxl-job jobhandler[" + name + "] naming conflicts.");
                }
                executeMethod.setAccessible(true);
                Method initMethod = null;
                Method destroyMethod = null;
                if (xxlJob.init().trim().length() > 0) {
                    try {
                        initMethod = bean.getClass().getDeclaredMethod(xxlJob.init(), new Class[0]);
                        initMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("xxl-job method-jobhandler initMethod invalid, for[" + bean.getClass() + "#" + executeMethod.getName() + "] .");
                    }
                }
                if (xxlJob.destroy().trim().length() > 0) {
                    try {
                        destroyMethod = bean.getClass().getDeclaredMethod(xxlJob.destroy(), new Class[0]);
                        destroyMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("xxl-job method-jobhandler destroyMethod invalid, for[" + bean.getClass() + "#" + executeMethod.getName() + "] .");
                    }
                }
                XxlJobSpringExecutor.registJobHandler(name, new MethodJobHandler(bean, executeMethod, initMethod, destroyMethod));
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        XxlJobSpringExecutor.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

