/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Blob;
import com.xugu.cloudjdbc.Clob;
import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Field;
import com.xugu.cloudjdbc.LogWriter;
import com.xugu.cloudjdbc.NClob;
import com.xugu.cloudjdbc.ResultSetMetaData;
import com.xugu.cloudjdbc.RowData;
import com.xugu.cloudjdbc.RowId;
import com.xugu.cloudjdbc.SQLXml;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ResultSet
implements java.sql.ResultSet {
    private int rsType = 1004;
    private int rsDirection = 1000;
    private int rsConcurrency = 1007;
    private boolean isReturnRowid;
    public RowData resRowData = null;
    public Field[] fields = null;
    protected Object[] currentRow = null;
    public int rsCurIndex = -1;
    public volatile boolean rsIsOver = false;
    protected boolean cursorHasMoreRows = true;
    protected boolean isClosed = false;
    protected Connection connection = null;
    protected Statement statement = null;
    protected java.sql.Statement statementWrapp;
    protected String catalog = null;
    protected boolean hasBuiltIndexMapping = false;
    protected Map columnNameToIndex = null;
    protected Map fullColumnNameToIndex = null;
    protected boolean wasNullFlag = false;
    private ByteBuffer byteBuffer = null;
    private String err_str = "";
    private boolean isOnInsertRow = false;
    private String insertString;
    private String insertRows = "";
    private String insertValues = "";
    private String updateTabName = null;
    private StringBuffer updateRowsValues = null;
    private byte[][] updateRowsBytes = null;
    private String rowIdValues = null;
    private int hugeParamCount = 0;
    private Vector<Vector> param;
    private byte[] paramBytes;
    private boolean isUpdate = false;
    private boolean isCalendar = false;
    private boolean isUpdateRow = false;
    private boolean isCancle = false;
    byte[][] copyRow = null;
    private SQLException nullException;
    private SQLException updateTypeConverExcpt;
    byte[] lobBuffer = new byte[1028];
    boolean isAD = true;
    short tz_short;
    int rowNum = 0;
    int year;
    int month;
    int day;
    int hour;
    int second;
    int minute;
    int ms;
    int rowCount = 0;
    String rs_sql;
    String cur_num = null;
    boolean isCursor = false;
    boolean isAbsolute = false;
    int absolutRows = -1;
    int moveIndex = -1;
    int fetchSize = 1000;
    boolean isFistAb = false;
    MessageFormat messFormat = null;
    private byte[][] newRow = null;
    private boolean isMoveTOData = false;
    private int rsLogCount = 0;
    private boolean innerFetchSize = false;
    private boolean isManificateRs = false;
    private int cursorFirstCounts = 0;

    ResultSet() {
    }

    ResultSet(Connection connection, Statement statement, String catalog, Field[] fields, RowData rowData, String executeSql) throws SQLException {
        this.connection = connection;
        this.statement = statement;
        this.rsType = statement.getResultSetType();
        this.rsDirection = statement.getFetchDirection();
        this.rsConcurrency = statement.getResultSetConcurrency();
        this.isReturnRowid = statement.isReturnRowid();
        this.cursorFirstCounts = statement.getCursorFirstCount();
        this.catalog = catalog;
        this.resRowData = rowData;
        this.fields = fields;
        this.resRowData.setRowSize(rowData.size());
        this.byteBuffer = ByteBuffer.allocate(1024);
        this.updateRowsValues = new StringBuffer();
        this.updateTabName = fields.length >= 2 ? "\"" + this.fields[this.fields.length - 2].getTableSchema() + "\".\"" + this.fields[this.fields.length - 2].getTableName() + "\"" : (fields.length == 0 ? "" : "\"" + this.fields[this.fields.length - 1].getTableSchema() + "\".\"" + this.fields[this.fields.length - 1].getTableName() + "\"");
        this.param = new Vector();
        this.hugeParamCount = 0;
        this.fetchSize = statement.getFetchSize();
        if (this.fetchSize == 0) {
            this.fetchSize = 1000;
        }
        this.rs_sql = executeSql;
        this.nullException = Error.createSQLException("[E50090]The parameter can not be empty", ReplaceEnum.excStr.getReplaceStr() + 50090, 50090);
        this.updateTypeConverExcpt = Error.createSQLException("[E50069]ResultSet: an illegal type conversion", ReplaceEnum.excStr.getReplaceStr() + 50069, 50069);
    }

    void addRow(byte[][] row) {
        this.getRowData().addRow(row);
    }

    private void buildIndexMapping() throws SQLException {
        this.columnNameToIndex = new HashMap(this.fields.length);
        this.fullColumnNameToIndex = new HashMap(this.fields.length);
        for (int i = this.fields.length - 1; i >= 0; --i) {
            Integer index = new Integer(i);
            String columnName = this.fields[i].getColumnName();
            String lableName = this.fields[i].getColumnLabel();
            String fullColumnName = this.fields[i].getTableName() + "." + this.fields[i].getColumnName();
            if (columnName.equalsIgnoreCase("ROWID")) {
                columnName = fullColumnName;
            }
            if (this.connection.getCata_Caps() == 0) {
                if (columnName != null && lableName == null) {
                    this.columnNameToIndex.put(columnName, index);
                    this.columnNameToIndex.put(columnName.toUpperCase(), index);
                    this.columnNameToIndex.put(columnName.toLowerCase(), index);
                } else if (lableName != null) {
                    this.columnNameToIndex.put(lableName, index);
                    this.columnNameToIndex.put(lableName.toUpperCase(), index);
                    this.columnNameToIndex.put(lableName.toLowerCase(), index);
                }
                if (fullColumnName == null) continue;
                this.fullColumnNameToIndex.put(fullColumnName, index);
                this.fullColumnNameToIndex.put(fullColumnName.toUpperCase(), index);
                this.fullColumnNameToIndex.put(fullColumnName.toLowerCase(), index);
                continue;
            }
            if (columnName != null && lableName == null) {
                this.columnNameToIndex.put(columnName, index);
            } else if (lableName != null) {
                this.columnNameToIndex.put(lableName, index);
            }
            if (fullColumnName == null) continue;
            this.fullColumnNameToIndex.put(fullColumnName, index);
        }
        this.hasBuiltIndexMapping = true;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Error.createSQLException("[E50038]ResultSet: \u7ed3\u679c\u96c6\u5df2\u5173\u95ed", ReplaceEnum.excStr.getReplaceStr() + 50038, 50038);
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw Error.createSQLException("[E50042]ResultSet: Column Index out of range" + columnIndex, ReplaceEnum.excStr.getReplaceStr() + 50042, 50042);
        }
    }

    private void checkCellNull(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        try {
            this.wasNullFlag = this.currentRow[columnIndex - 1] == null;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.next(false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next(boolean isRowSet, java.sql.Connection rowsetCon) throws SQLException {
        boolean backBoolean;
        block40: {
            block37: {
                byte[][] rowBytes;
                block41: {
                    block36: {
                        block35: {
                            int fetchCount;
                            String[] nextObj;
                            ResultSet cur_rs;
                            block34: {
                                block38: {
                                    block39: {
                                        block30: {
                                            block31: {
                                                block32: {
                                                    block33: {
                                                        if (Command.debug) {
                                                            Command.logRSmethods(this.connection.io, this.logString("next    "), this.rsLogCount, false);
                                                        }
                                                        this.checkClosed();
                                                        backBoolean = false;
                                                        cur_rs = null;
                                                        this.messFormat = null;
                                                        nextObj = null;
                                                        if (!this.isCursor()) break block30;
                                                        fetchCount = 0;
                                                        if (this.hasMoreRows()) break block31;
                                                        if (!this.isCursorHasMoreRows()) break block32;
                                                        if (isRowSet) {
                                                            this.connection = (Connection)rowsetCon;
                                                            if (this.statement == null || this.statement.isClosed()) {
                                                                this.statement = (Statement)this.connection.createStatement();
                                                            }
                                                        }
                                                        this.messFormat = SQLCommon.getMessageFormat("ResultSet.fetchCursor");
                                                        nextObj = new String[]{String.valueOf(this.getFecheSizeInner()), this.getCur_num()};
                                                        this.statement.setFetchSql(true);
                                                        if (!this.isAbsolute) break block33;
                                                        fetchCount = 0;
                                                        this.setMoveIndex(this.absolutRows);
                                                        break block34;
                                                    }
                                                    this.statement.executeQueryFetch(this.messFormat.format(nextObj), this.getFecheSizeInner(), this.getRowData(), false);
                                                    this.statement.setFetchSql(false);
                                                    this.rowCount = this.rowdataSize();
                                                    this.getRowData().setIndex(-1);
                                                    if (this.getRowCount() < this.getFecheSizeInner()) {
                                                        this.setCursorHasMoreRows(false);
                                                    }
                                                    break block35;
                                                }
                                                if (this.connection.closeCurrResult) {
                                                    this.close();
                                                    return backBoolean;
                                                }
                                                this.resumeUpdateString();
                                                return backBoolean;
                                            }
                                            if (this.isAbsolute) {
                                                this.setMoveIndex(this.absolutRows);
                                                int rowDataIndexMove = this.absolutRows % this.fetchSize;
                                                if (rowDataIndexMove > 0) {
                                                    this.getRowData().setIndex(rowDataIndexMove - 2);
                                                } else {
                                                    this.getRowData().setIndex(this.fetchSize - 2);
                                                }
                                                this.absolutRows = -1;
                                                this.isAbsolute = false;
                                            }
                                            break block36;
                                        }
                                        if (this.statement.getRecv_mod() != 1 || this.isManificateRs()) break block37;
                                        if (this.currentRow == null || this.isRsIsOver()) {
                                            if (!this.connection.closeCurrResult) return backBoolean;
                                            this.close();
                                            return backBoolean;
                                        }
                                        backBoolean = true;
                                        if (this.rowNum == 0) break block38;
                                        byte bt = this.connection.io.readByte();
                                        if (bt == 82) break block39;
                                        if (bt == 75) {
                                            this.setRsIsOver(true);
                                            this.statement.setStmIsOver(true);
                                            this.connection.io.setBLocked(false);
                                            if (Command.debug) {
                                                if (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("endK") != -1) {
                                                    this.connection.io.lw.write(this.connection.io.sessionId, this.rs_sql, LogWriter.CmdState.endK, System.currentTimeMillis() - this.connection.io.serverStartT);
                                                }
                                                Command.logBlockedState(this.connection.io, "next K  " + this.rs_sql, this.connection.io.isBLocked());
                                                Command.logStmOverState(this.connection.io, "next K  " + this.rs_sql, this.statement.isStmIsOver());
                                                Command.logRsOverState(this.connection.io, "next K  " + this.rs_sql, this.isRsIsOver());
                                            }
                                            if (this.err_str.equals("")) return false;
                                            throw Error.createSQLException(this.err_str);
                                        }
                                        if (bt == 87 || bt == 77) {
                                            String strWM = this.connection.io.readStr();
                                            this.statement.setStmWarning(strWM);
                                            if (!Command.debug) return this.next();
                                            if (!Command.debugLevel.equals("ALL")) {
                                                if (Command.debugLevel.indexOf("endWM") == -1) return this.next();
                                            }
                                            this.connection.io.lw.write(this.connection.io.sessionId, "next recv_mode=1," + strWM, LogWriter.CmdState.endWM);
                                            return this.next();
                                        }
                                        if (bt == 69 || bt == 70) {
                                            String err_str1 = this.connection.io.readStr();
                                            this.err_str = this.err_str + "\r\n" + err_str1;
                                            if (!Command.debug) return this.next();
                                            if (!Command.debugLevel.equals("ALL")) {
                                                if (Command.debugLevel.indexOf("endEF") == -1) return this.next();
                                            }
                                            if (this.err_str.length() <= 1) return this.next();
                                            this.connection.io.lw.write(this.connection.io.sessionId, "next recv_mode=1," + this.err_str, LogWriter.CmdState.endEF);
                                            return this.next();
                                        }
                                        break block40;
                                    }
                                    rowBytes = new byte[this.fields.length][];
                                    break block41;
                                }
                                ++this.rowNum;
                                backBoolean = true;
                                break block40;
                            }
                            for (fetchCount = (this.absolutRows - this.getMoveIndex()) / this.getFecheSizeInner(); fetchCount >= 0; --fetchCount) {
                                cur_rs = this.statement.executeQueryFetch(this.messFormat.format(nextObj), this.getFecheSizeInner(), this.getRowData(), true);
                                if (this.getRowCount() >= this.getFecheSizeInner()) continue;
                                this.setCursorHasMoreRows(false);
                                return false;
                            }
                            this.statement.setFetchSql(false);
                            this.resRowData = cur_rs.getRowData();
                            this.resRowData.setIndex(this.getMoveIndex() % this.getFecheSizeInner() - 2);
                            this.isAbsolute = false;
                            this.absolutRows = -1;
                        }
                        this.statement.setFetchSql(false);
                    }
                    if (this.getRowCount() > 0) {
                        this.currentRow = this.getRowData().getNextRow();
                        backBoolean = true;
                    }
                    break block40;
                }
                for (int j = 0; j < this.fields.length; ++j) {
                    int rowLength = this.connection.io.readInt();
                    if (rowLength > 0) {
                        Field ff = this.fields[j];
                        if (ff.getFiledFlag()) {
                            this.connection.io.is_Object = true;
                        }
                        rowBytes[j] = this.connection.io.readBytes(rowLength);
                        continue;
                    }
                    rowBytes[j] = null;
                }
                this.currentRow = (Object[])rowBytes;
                backBoolean = true;
                break block40;
            }
            while (!this.isRsIsOver() && !this.hasMoreRows()) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception bt) {
                    // empty catch block
                }
                if (!Command.debug) continue;
                Command.logRsOverState(this.connection.io, "next \u7b49\u5f85\u6570\u636e.  " + this.rs_sql, this.isRsIsOver());
            }
            if (this.getRowData().isEmpty() || !this.hasMoreRows()) {
                if (!this.connection.closeCurrResult) return false;
                this.close();
                return false;
            }
            this.clearWarnings();
            if (this.statement.getRecv_type()) {
                this.currentRow = this.getRowData().currentRow();
                this.getRowData().removeCurrRow();
            } else {
                this.currentRow = this.getRowData().getNextRow();
            }
            backBoolean = true;
        }
        this.resumeUpdateString();
        this.isCancle = false;
        this.isOnInsertRow = false;
        this.isUpdateRow = false;
        if (this.currentRow != null) {
            this.copyRow = new byte[this.currentRow.length][];
            for (int i = 0; i < this.currentRow.length; ++i) {
                this.copyRow[i] = (byte[])this.currentRow[i];
            }
            if (this.isReturnRowid && this.fields[this.fields.length - 1].getColumnName().equalsIgnoreCase("ROWID")) {
                this.rowIdValues = new String((byte[])this.currentRow[this.fields.length - 1]);
            }
        }
        this.isMoveTOData = true;
        ++this.moveIndex;
        return backBoolean;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection == null || this.statement == null || this.isClosed || this.connection.isClosed() || this.statement.isClosed()) {
            return;
        }
        if (Command.debug) {
            Command.logCloseMethods(this.connection.io, "ReseltSet |" + this.rs_sql);
            Command.logRSmethods(this.connection.io, "close    " + this.rsLogCount, this.rsLogCount, true);
        }
        if (!this.isRsIsOver() && this.statement.sqlQuery && !this.statement.isStreamExecute && this.connection.io.getConnState() == 0) {
            this.connection.io.sendByte((byte)46);
            if (Command.debug) {
                Command.logStmOverState(this.connection.io, "close send(.) " + this.rs_sql, this.isRsIsOver());
            }
        }
        while (!this.isRsIsOver()) {
            if (this.statement.getRecv_mod() == 1) {
                this.next();
                if (!Command.debug) continue;
                Command.logStmOverState(this.connection.io, "close--recv_mode1. " + this.rs_sql, this.isRsIsOver());
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!Command.debug) continue;
            Command.logRsOverState(this.connection.io, "close \u7b49\u5f85\u63a5\u6536\u5269\u4f59\u6570\u636e .  " + this.rs_sql, this.isRsIsOver());
        }
        if (this.getCur_num() != null && this.connection.io.getConnState() == 0 && (!this.connection.is301Protocol() || this.isCursorHasMoreRows())) {
            this.messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("ResultSet.closeCursor"));
            String closeSql = this.messFormat.format(new String[]{this.getCur_num()});
            this.statement.executeWithNoCallCheck(closeSql);
        }
        if (this.resRowData != null) {
            this.resRowData.clear();
            this.resRowData = null;
        }
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = null;
            }
        }
        this.fields = null;
        this.currentRow = null;
        if (this.byteBuffer != null) {
            this.byteBuffer.clear();
            this.byteBuffer = null;
        }
        this.columnNameToIndex = null;
        this.fullColumnNameToIndex = null;
        this.copyRow = null;
        this.currentRow = null;
        this.param = null;
        this.paramBytes = null;
        this.rs_sql = null;
        this.updateTabName = null;
        this.insertRows = null;
        this.insertString = null;
        this.insertValues = null;
        this.updateRowsValues = null;
        this.catalog = null;
        this.isClosed = true;
        if (this.statement != null && this.statement.allOpenRsultSet != null) {
            this.statement.allOpenRsultSet.removeResultSet(this);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getString    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        byte[] bytes = (byte[])this.currentRow[columnIndex - 1];
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 3: {
                int byteLen = bytes.length;
                byte bt = bytes[byteLen - 1];
                return String.valueOf(bt);
            }
            case 4: {
                this.byteBuffer.clear();
                this.byteBuffer.put(bytes);
                this.byteBuffer.flip();
                short i2 = this.byteBuffer.getShort();
                return String.valueOf(i2);
            }
            case 5: {
                this.byteBuffer.clear();
                this.byteBuffer.put(bytes);
                this.byteBuffer.flip();
                int i4 = this.byteBuffer.getInt();
                return String.valueOf(i4);
            }
            case 6: {
                this.byteBuffer.clear();
                this.byteBuffer.put(bytes);
                this.byteBuffer.flip();
                long i8 = this.byteBuffer.getLong();
                return String.valueOf(i8);
            }
            case 8: {
                this.byteBuffer.clear();
                this.byteBuffer.put(bytes);
                this.byteBuffer.flip();
                float r4 = this.byteBuffer.getFloat();
                return String.valueOf(r4);
            }
            case 9: {
                this.byteBuffer.clear();
                this.byteBuffer.put(bytes);
                this.byteBuffer.flip();
                double r8 = this.byteBuffer.getDouble();
                return String.valueOf(r8);
            }
            case 2: 
            case 7: {
                return new String(bytes);
            }
            case 28: 
            case 29: 
            case 30: 
            case 45: {
                String char_string = null;
                if (bytes.length == 1 && bytes[0] == 0) {
                    if (this.connection.isIsora() && this.connection.isEmptyStringAsNull()) {
                        return null;
                    }
                    return "";
                }
                char_string = this.connection.io.getStringWithCharactor(bytes);
                return char_string;
            }
            case 32: 
            case 33: 
            case 47: {
                if (bytes.length == 1 && bytes[0] == 0) {
                    return "";
                }
                String str = this.connection.io.getStringWithCharactor(bytes);
                if (this.getField(columnIndex - 1).getFiledFlag() && this.connection.useLobDescribMode()) {
                    boolean flag = this.statement.isDirectLob(bytes[0]);
                    if (!flag) {
                        str = str.substring(1);
                    } else {
                        int sepIndex = str.indexOf(32);
                        this.messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Statement.getLobResultSet"));
                        Statement stmLob = (Statement)this.connection.createStatement();
                        java.sql.ResultSet rs = stmLob.executeLob(this.messFormat.format(new String[]{"'" + str.substring(0, sepIndex) + "'", "0", str.substring(sepIndex + 1)}));
                        rs.next();
                        str = rs.getString(1);
                        rs.close();
                        stmLob.close();
                    }
                }
                return str;
            }
            case 10: {
                if (this.connection.isIsora() || this.connection.compatibleQX) {
                    return this.getDate(columnIndex).toString();
                }
                return this.getDate(columnIndex).toString() + (this.getIsAD() ? " AD" : " BC");
            }
            case 11: {
                return this.getTime(columnIndex).toString();
            }
            case 13: {
                if (this.connection.isIsora() || this.connection.compatibleQX) {
                    return this.getTimestamp(columnIndex).toString();
                }
                return this.getTimestamp(columnIndex).toString() + (this.getIsAD() ? " AD" : " BC");
            }
            case 14: {
                this.isCalendar = true;
                if (this.connection.isIsora() || this.connection.compatibleQX) {
                    return this.getTimeStamp_TZ(columnIndex).toString();
                }
                return this.getTimeStamp_TZ(columnIndex).toString() + (this.getIsAD() ? " AD" : " BC");
            }
            case 12: {
                this.isCalendar = true;
                return this.getTime_TZ(columnIndex);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (this.connection.compatibleQX) {
                    return this.getInterval_str(columnIndex);
                }
                return this.getInterval(columnIndex);
            }
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getBoolean    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNull()) {
            return false;
        }
        byte[] boolAsBytes = (byte[])this.currentRow[columnIndex - 1];
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 2: {
                if (boolAsBytes.length == 1 && (boolAsBytes[0] == 84 || boolAsBytes[0] == 116 || boolAsBytes[0] == 49) || boolAsBytes.length == 4 && new String(boolAsBytes).equalsIgnoreCase("true") || boolAsBytes.length == 1 && boolAsBytes[0] == 85 || boolAsBytes.length == 6 && new String(boolAsBytes).equalsIgnoreCase("UNKNOW")) {
                    return true;
                }
                if (boolAsBytes.length == 1 && (boolAsBytes[0] == 70 || boolAsBytes[0] == 102 || boolAsBytes[0] == 48) || boolAsBytes.length == 5 && new String(boolAsBytes).equalsIgnoreCase("false")) {
                    return false;
                }
                throw Error.createSQLException("[E50043]ResultSet: The data can't be switched to boolean type", ReplaceEnum.excStr.getReplaceStr() + 50043, 50043);
            }
            case 3: {
                return boolAsBytes[0] == -1 || boolAsBytes[0] > 0;
            }
            case 4: {
                return this.getShort(columnIndex) == -1 || this.getShort(columnIndex) > 0;
            }
            case 5: {
                return this.getInt(columnIndex) == -1 || this.getInt(columnIndex) > 0;
            }
            case 6: {
                return this.getLong(columnIndex) == -1L || this.getLong(columnIndex) > 0L;
            }
            case 8: {
                return this.getFloat(columnIndex) == -1.0f || this.getFloat(columnIndex) > 0.0f;
            }
            case 9: {
                return this.getDouble(columnIndex) == -1.0 || this.getDouble(columnIndex) > 0.0;
            }
            case 7: {
                return this.getBigDecimal(columnIndex).doubleValue() == -1.0 || this.getBigDecimal(columnIndex).doubleValue() > 0.0;
            }
            case 30: {
                String stringVal = new String(boolAsBytes);
                if (this.connection.isIsora() && stringVal != null && stringVal.length() > 0) {
                    char c = Character.toLowerCase(stringVal.charAt(0));
                    if (c == '1' || c == 't' || c == '\uffffffff') {
                        return Boolean.valueOf("true");
                    }
                    return Boolean.valueOf("false");
                }
                if (stringVal != null && stringVal.length() > 0) {
                    if (stringVal.indexOf("1") != -1) {
                        stringVal = "true";
                    }
                    return Boolean.valueOf(stringVal);
                }
                return new Boolean("");
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getByte    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        byte[] dataBytes = (byte[])this.currentRow[columnIndex - 1];
        int len = dataBytes.length;
        byte cellByte = 0;
        if (len == 0) {
            cellByte = 0;
        } else if (len == 1) {
            if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 2) {
                if (dataBytes[0] < 48 || dataBytes[0] > 57 || this.fields[columnIndex - 1].getRedhorseType() == 2) {
                    throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
                }
                cellByte = Byte.valueOf(String.valueOf((char)dataBytes[0]));
            } else {
                cellByte = dataBytes[0];
            }
        } else {
            BigDecimal x = this.getBigDecimal(columnIndex);
            if (x.longValue() > 127L || x.longValue() < -128L) {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
            cellByte = x.byteValue();
        }
        return cellByte;
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getShort    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        byte[] IntAsBytes = (byte[])this.currentRow[columnIndex - 1];
        int bytesLen = IntAsBytes.length;
        if (this.isCalendar) {
            byte[] cal = new byte[]{IntAsBytes[IntAsBytes.length - 2], IntAsBytes[IntAsBytes.length - 1]};
            this.byteBuffer.clear();
            this.byteBuffer.put(cal);
            this.byteBuffer.flip();
            short dataShort = this.byteBuffer.getShort();
            return dataShort;
        }
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 2: {
                if (IntAsBytes.length == 1 && IntAsBytes[0] == 84) {
                    return 1;
                }
                if (IntAsBytes.length == 1 && IntAsBytes[0] == 70) {
                    return 0;
                }
                if (IntAsBytes.length == 1 && IntAsBytes[0] == 85) {
                    return -1;
                }
                throw Error.createSQLException("[E50045]The data can't be switched to short type", ReplaceEnum.excStr.getReplaceStr() + 50045, 50045);
            }
            case 3: {
                return this.getByte(columnIndex);
            }
            case 4: {
                for (int i = 0; i < bytesLen - 2; ++i) {
                    if (IntAsBytes[i] <= 0) continue;
                    throw Error.createSQLException("[E50045]The data can't be switched to short type", ReplaceEnum.excStr.getReplaceStr() + 50045, 50045);
                }
                this.byteBuffer.clear();
                byte[] shortData = null;
                shortData = new byte[2];
                switch (IntAsBytes.length) {
                    case 1: {
                        shortData[0] = 0;
                        shortData[1] = IntAsBytes[0];
                        break;
                    }
                    default: {
                        shortData[0] = IntAsBytes[bytesLen - 2];
                        shortData[1] = IntAsBytes[bytesLen - 1];
                    }
                }
                this.byteBuffer.put(shortData);
                this.byteBuffer.flip();
                short dataShort = this.byteBuffer.getShort();
                return dataShort;
            }
            case 5: 
            case 30: {
                Integer intVal = new Integer(this.getInt(columnIndex));
                return intVal.shortValue();
            }
            case 6: {
                Long longVal = new Long(this.getLong(columnIndex));
                return longVal.shortValue();
            }
            case 8: {
                Float floatVal = new Float(this.getFloat(columnIndex));
                return floatVal.shortValue();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(columnIndex));
                return doubleVal.shortValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(columnIndex);
                return decimalVal.shortValue();
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0;
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getInt    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        byte[] IntAsBytes = (byte[])this.currentRow[columnIndex - 1];
        int bytesLen = IntAsBytes.length;
        if (this.isCalendar) {
            byte[] cal = new byte[]{IntAsBytes[IntAsBytes.length - 6], IntAsBytes[IntAsBytes.length - 5], IntAsBytes[IntAsBytes.length - 4], IntAsBytes[IntAsBytes.length - 3]};
            this.byteBuffer.clear();
            this.byteBuffer.put(cal);
            this.byteBuffer.flip();
            int dataInt = this.byteBuffer.getInt();
            return dataInt;
        }
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 2: {
                if (IntAsBytes.length == 1 && IntAsBytes[0] == 84) {
                    return 1;
                }
                if (IntAsBytes.length == 1 && IntAsBytes[0] == 70) {
                    return 0;
                }
                throw Error.createSQLException("The data can't be switched to int type", ReplaceEnum.excStr.getReplaceStr() + 50046, 50046);
            }
            case 3: {
                return this.getByte(columnIndex);
            }
            case 4: {
                return this.getShort(columnIndex);
            }
            case 5: {
                for (int i = 0; i < bytesLen - 4; ++i) {
                    if (IntAsBytes[i] <= 0) continue;
                    throw Error.createSQLException("[E50045]The data can't be switched to short type", ReplaceEnum.excStr.getReplaceStr() + 50045, 50045);
                }
                this.byteBuffer.clear();
                byte[] intData = this.polishBytesByLen(4, IntAsBytes);
                this.byteBuffer.put(intData);
                this.byteBuffer.flip();
                int dataInt = this.byteBuffer.getInt();
                return dataInt;
            }
            case 6: {
                Long longVal = new Long(this.getLong(columnIndex));
                return longVal.intValue();
            }
            case 8: {
                Float floatVal = new Float(this.getFloat(columnIndex));
                return floatVal.intValue();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(columnIndex));
                return doubleVal.intValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(columnIndex);
                return decimalVal.intValue();
            }
            case 29: 
            case 30: {
                int s;
                try {
                    String charInt = this.getString(columnIndex);
                    s = charInt.equals("") ? 0 : Integer.parseInt(charInt);
                }
                catch (NumberFormatException e) {
                    Byte byteVal = new Byte(IntAsBytes[0]);
                    s = byteVal.intValue();
                }
                return s;
            }
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.byteBuffer.clear();
                this.byteBuffer.put(IntAsBytes);
                this.byteBuffer.flip();
                return this.byteBuffer.getInt();
            }
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0;
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getLong    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return 0L;
        }
        byte[] longAsBytes = (byte[])this.currentRow[columnIndex - 1];
        if (this.isCalendar) {
            byte[] cal = new byte[8];
            System.arraycopy(longAsBytes, 0, cal, 0, 8);
            this.byteBuffer.clear();
            this.byteBuffer.put(cal);
            this.byteBuffer.flip();
            long dataInt = this.byteBuffer.getLong();
            return dataInt;
        }
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 2: {
                if (longAsBytes.length == 1 && longAsBytes[0] == 84) {
                    return 1L;
                }
                if (longAsBytes.length == 1 && longAsBytes[0] == 70) {
                    return 0L;
                }
                throw Error.createSQLException("[E50043]Resultset: The data can't be switched to boolean type", ReplaceEnum.excStr.getReplaceStr() + 50043, 50043);
            }
            case 3: {
                return this.getByte(columnIndex);
            }
            case 4: {
                return this.getShort(columnIndex);
            }
            case 5: {
                return this.getInt(columnIndex);
            }
            case 6: {
                this.byteBuffer.clear();
                if (longAsBytes.length > 8 && !this.isUpdate) {
                    throw Error.createSQLException("[E50046]The data can't be switched to int type", ReplaceEnum.excStr.getReplaceStr() + 50046, 50046);
                }
                this.byteBuffer.clear();
                byte[] longData = this.polishBytesByLen(8, longAsBytes);
                this.byteBuffer.put(longData);
                this.byteBuffer.flip();
                long dataLong = this.byteBuffer.getLong();
                return dataLong;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (longAsBytes.length == 4) {
                    byte[] tempLong = new byte[]{0, 0, 0, 0, longAsBytes[0], longAsBytes[1], longAsBytes[2], longAsBytes[3]};
                    this.byteBuffer.clear();
                    this.byteBuffer.put(tempLong);
                    this.byteBuffer.flip();
                } else {
                    this.byteBuffer.clear();
                    this.byteBuffer.put(longAsBytes);
                    this.byteBuffer.flip();
                }
                long dLong = this.byteBuffer.getLong();
                return dLong;
            }
            case 8: {
                Float floatVal = new Float(this.getFloat(columnIndex));
                return floatVal.longValue();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(columnIndex));
                return doubleVal.longValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(columnIndex);
                return decimalVal.longValue();
            }
            case 30: {
                String longString = this.getString(columnIndex);
                if (longString.equals("")) {
                    return 0L;
                }
                return Long.parseLong(longString);
            }
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0L;
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getFloat    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return 0.0f;
        }
        byte[] dataAsBytes = (byte[])this.currentRow[columnIndex - 1];
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 2: {
                if (dataAsBytes.length == 1 && dataAsBytes[0] == 84) {
                    return 1.0f;
                }
                if (dataAsBytes.length == 1 && dataAsBytes[0] == 70) {
                    return 0.0f;
                }
                throw Error.createSQLException("[E50047]The data can't be switched to float type", ReplaceEnum.excStr.getReplaceStr() + 50047, 50047);
            }
            case 3: {
                return this.getByte(columnIndex);
            }
            case 4: {
                return this.getShort(columnIndex);
            }
            case 5: {
                return this.getInt(columnIndex);
            }
            case 6: {
                return this.getLong(columnIndex);
            }
            case 8: {
                this.byteBuffer.clear();
                byte[] floatBytes = this.polishBytesByLen(4, dataAsBytes);
                this.byteBuffer.put(floatBytes);
                this.byteBuffer.flip();
                return this.byteBuffer.getFloat();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(columnIndex));
                return doubleVal.floatValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(columnIndex);
                return decimalVal.floatValue();
            }
            case 29: 
            case 30: {
                String str = this.getString(columnIndex);
                if (str.equals("")) {
                    return 0.0f;
                }
                return Float.parseFloat(str);
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0.0f;
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getDouble    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return 0.0;
        }
        byte[] doubleAsBytes = (byte[])this.currentRow[columnIndex - 1];
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 2: {
                if (doubleAsBytes.length == 1 && doubleAsBytes[0] == 84) {
                    return 1.0;
                }
                if (doubleAsBytes.length == 1 && doubleAsBytes[0] == 70) {
                    return 0.0;
                }
                throw Error.createSQLException("[E50048]The data can't be switched to double type", ReplaceEnum.excStr.getReplaceStr() + 50048, 50048);
            }
            case 3: {
                return this.getByte(columnIndex);
            }
            case 4: {
                return this.getShort(columnIndex);
            }
            case 5: {
                return this.getInt(columnIndex);
            }
            case 6: {
                return this.getLong(columnIndex);
            }
            case 8: {
                return Double.valueOf(String.valueOf(this.getFloat(columnIndex)));
            }
            case 9: {
                this.byteBuffer.clear();
                byte[] doubleBytes = this.polishBytesByLen(8, doubleAsBytes);
                this.byteBuffer.put(doubleAsBytes);
                this.byteBuffer.flip();
                double dataDouble = this.byteBuffer.getDouble();
                return dataDouble;
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(columnIndex);
                return decimalVal.doubleValue();
            }
            case 30: {
                String str = this.getString(columnIndex);
                if (str.equals("")) {
                    return 0.0;
                }
                return Double.parseDouble(str);
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getBigDecimal    " + columnIndex + "     " + scale, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 9 || this.fields[columnIndex - 1].getRedhorseType() == 8 || this.fields[columnIndex - 1].getRedhorseType() == 3 || this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 7) {
            BigInteger biginteger = null;
            try {
                String str = this.getString(columnIndex);
                biginteger = new BigInteger(str);
            }
            catch (NumberFormatException e) {
                throw Error.createSQLException("[E50050]The data can't be switched to bigint type", ReplaceEnum.excStr.getReplaceStr() + 50050, 50050);
            }
            return new BigDecimal(biginteger, scale);
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getBytes    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        byte[] b_data = null;
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 33: 
            case 34: {
                if (this.fields[columnIndex - 1].isBigObject_FetchDirect()) {
                    return (byte[])this.currentRow[columnIndex - 1];
                }
                java.sql.Blob byteBlob = this.getBlob(columnIndex);
                InputStream byteIn = byteBlob.getBinaryStream();
                try {
                    int totalLen = Long.valueOf(byteBlob.length()).intValue();
                    if (totalLen == 0) {
                        return new byte[0];
                    }
                    b_data = new byte[totalLen];
                    int index = 0;
                    int readLen = byteIn.read(b_data);
                    while (readLen < totalLen) {
                        index = readLen;
                        readLen = byteIn.read(b_data, index, totalLen -= readLen);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return b_data;
            }
            case 32: {
                if (this.fields[columnIndex - 1].isBigObject_FetchDirect()) {
                    return (byte[])this.currentRow[columnIndex - 1];
                }
                try {
                    return this.getString(columnIndex).getBytes(this.connection.getCharSet());
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLCommon.EncodingException(e);
                }
            }
        }
        return (byte[])this.currentRow[columnIndex - 1];
    }

    private Object getDateInternal(int columnIndex, boolean local) throws SQLException {
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        this.isAD = true;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 11 || this.fields[columnIndex - 1].getRedhorseType() == 10 || this.fields[columnIndex - 1].getRedhorseType() == 13) {
            int d;
            if (this.fields[columnIndex - 1].getRedhorseType() == 10) {
                long tt1 = this.getInt(columnIndex);
                boolean s = false;
                boolean ms = false;
                d = (int)tt1;
                if (tt1 <= -719528L) {
                    this.isAD = false;
                }
            } else {
                long tt1 = this.fields[columnIndex - 1].getRedhorseType() == 11 ? (long)this.getInt(columnIndex) : this.getLong(columnIndex);
                if (tt1 <= -62135596800000L) {
                    this.isAD = false;
                }
                int ms = (int)(tt1 % 1000L);
                if (tt1 >= 0L) {
                    long tt = tt1 / 1000L;
                    int s = (int)(tt % 86400L);
                    d = (int)(tt / 86400L);
                } else {
                    long tt = tt1 / 1000L;
                    if (ms != 0) {
                        ms += 1000;
                        --tt;
                    }
                    int s = (int)(tt % 86400L);
                    d = (int)(tt / 86400L);
                    if (s != 0) {
                        s += 86400;
                        --d;
                    }
                }
            }
            int d1 = (d += 40896202) - 10;
            int y = d1 / 146097 * 400;
            y += (d1 %= 146097) / 36524 * 100;
            y += (d1 %= 36524) / 1461 * 4;
            d1 %= 1461;
            if ((d -= (d1 = (y += d1 / 365) * 365 + (y - 1) / 4 - (y - 1) / 100 + (y - 1) / 400)) >= 365) {
                if (ResultSet.isRn(y)) {
                    if (d > 365) {
                        ++y;
                        d -= 366;
                    }
                } else {
                    ++y;
                    d -= 365;
                }
            }
            this.year = y - 110000 < 1 ? 1 - (y - 110000) : y - 110000;
            if (ResultSet.isRn(y)) {
                this.month = Connection.day2md_rn[d][0];
                this.day = Connection.day2md_rn[d][1];
            } else {
                this.month = Connection.day2md[d][0];
                this.day = Connection.day2md[d][1];
            }
            if (!local) {
                return new Date(y - 1900 - 110000, this.month - 1, this.day);
            }
            return LocalDate.of(this.year, this.month, this.day);
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getDate    " + columnIndex, this.rsLogCount, false);
        }
        return (Date)this.getDateInternal(columnIndex, false);
    }

    private LocalDate getLocalDate(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getLocalDate    " + columnIndex, this.rsLogCount, false);
        }
        return (LocalDate)this.getDateInternal(columnIndex, true);
    }

    private String getTime_TZ(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTime_TZ    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            this.isCalendar = false;
            return null;
        }
        StringBuilder twtz = new StringBuilder();
        if (this.isCalendar) {
            short shor = this.getShort(columnIndex);
            StringBuilder timeZon = new StringBuilder();
            int minute = 0;
            int hours = 0;
            Time tt = this.getTime(columnIndex);
            if (shor > 0) {
                minute = shor % 60;
                hours = shor / 60;
                timeZon.append("+").append(String.format("%02d:%02d", hours, minute));
            } else {
                shor = (short)(shor - 2 * shor);
                minute = shor % 60;
                hours = shor / 60;
                timeZon.append("-").append(String.format("%02d:%02d", hours, minute));
            }
            twtz.append(tt).append(" ").append((CharSequence)timeZon);
        }
        this.isCalendar = false;
        return twtz.toString();
    }

    private Object getTimeInternal(int columnIndex, boolean local) throws SQLException {
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (!local) {
            if (this.fields[columnIndex - 1].getRedhorseType() == 13 || this.fields[columnIndex - 1].getRedhorseType() == 11 || this.fields[columnIndex - 1].getRedhorseType() == 10 || this.fields[columnIndex - 1].getRedhorseType() == 12) {
                int s;
                int ms;
                if (this.fields[columnIndex - 1].getRedhorseType() == 10) {
                    long tt1 = this.getInt(columnIndex);
                    ms = 0;
                    s = 0;
                } else {
                    long tt1;
                    if (this.fields[columnIndex - 1].getRedhorseType() == 11 || this.fields[columnIndex - 1].getRedhorseType() == 12) {
                        if (this.fields[columnIndex - 1].getRedhorseType() == 12) {
                            this.isCalendar = true;
                        }
                        tt1 = this.getInt(columnIndex);
                    } else {
                        tt1 = this.getLong(columnIndex);
                    }
                    ms = (int)(tt1 % 1000L);
                    long tt = tt1 / 1000L;
                    if (tt1 < 0L) {
                        if (ms != 0) {
                            ms += 1000;
                            --tt;
                        }
                        if ((s = (int)(tt % 86400L)) != 0) {
                            s += 86400;
                        }
                    } else {
                        s = (int)(tt % 86400L);
                    }
                }
                int h = s / 3600;
                int m = (s %= 3600) / 60;
                int se = s % 60;
                Time time = new Time(new Timestamp(-1900, 0, 0, h, m, se, ms * 1000000).getTime());
                Time returnTime = null;
                if (this.fields[columnIndex - 1].getRedhorseType() == 12) {
                    short shor = this.getShort(columnIndex);
                    Time times = null;
                    int minute = 0;
                    int hours = 0;
                    if (shor > 0) {
                        minute = shor % 60;
                        hours = shor / 60;
                        times = new Time(time.getHours() + hours, time.getMinutes() + minute, time.getSeconds());
                    } else {
                        shor = (short)(shor - 2 * shor);
                        minute = shor % 60;
                        hours = shor / 60;
                        times = new Time(time.getHours() - hours, time.getMinutes() - minute, time.getSeconds());
                    }
                    returnTime = times;
                } else {
                    returnTime = time;
                }
                this.isCalendar = false;
                return returnTime;
            }
            throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 13 || this.fields[columnIndex - 1].getRedhorseType() == 11 || this.fields[columnIndex - 1].getRedhorseType() == 10 || this.fields[columnIndex - 1].getRedhorseType() == 12) {
            int s;
            int ms;
            if (this.fields[columnIndex - 1].getRedhorseType() == 10) {
                long tt1 = this.getInt(columnIndex);
                ms = 0;
                s = 0;
            } else {
                long tt1;
                if (this.fields[columnIndex - 1].getRedhorseType() == 11 || this.fields[columnIndex - 1].getRedhorseType() == 12) {
                    if (this.fields[columnIndex - 1].getRedhorseType() == 12) {
                        this.isCalendar = true;
                    }
                    tt1 = this.getInt(columnIndex);
                } else {
                    tt1 = this.getLong(columnIndex);
                }
                ms = (int)(tt1 % 1000L);
                long tt = tt1 / 1000L;
                if (tt1 < 0L) {
                    if (ms != 0) {
                        ms += 1000;
                        --tt;
                    }
                    if ((s = (int)(tt % 86400L)) != 0) {
                        s += 86400;
                    }
                } else {
                    s = (int)(tt % 86400L);
                }
            }
            int h = s / 3600;
            int m = (s %= 3600) / 60;
            int se = s % 60;
            LocalTime time = LocalTime.of(h, m, se, ms * 1000000);
            LocalTime returnTime = null;
            if (this.fields[columnIndex - 1].getRedhorseType() == 12) {
                short shor = this.getShort(columnIndex);
                LocalTime times = null;
                int minute = 0;
                int hours = 0;
                if (shor > 0) {
                    minute = shor % 60;
                    hours = shor / 60;
                    times = LocalTime.of(time.getHour() + hours, time.getMinute() + minute, time.getSecond(), time.getNano());
                } else {
                    shor = (short)(shor - 2 * shor);
                    minute = shor % 60;
                    hours = shor / 60;
                    times = LocalTime.of(time.getHour() - hours, time.getMinute() - minute, time.getSecond(), time.getNano());
                }
                returnTime = times;
            } else {
                returnTime = time;
            }
            this.isCalendar = false;
            return returnTime;
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTime    " + columnIndex, this.rsLogCount, false);
        }
        return (Time)this.getTimeInternal(columnIndex, false);
    }

    private LocalTime getLocalTime(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getLocalTime    " + columnIndex, this.rsLogCount, false);
        }
        return (LocalTime)this.getTimeInternal(columnIndex, true);
    }

    private String getTimeStamp_TZ(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTimeStamp_TZ    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            this.isCalendar = false;
            return null;
        }
        String twtz = null;
        if (this.isCalendar) {
            short shor = this.getShort(columnIndex);
            String timeZon = null;
            String times = null;
            int minute = 0;
            int hours = 0;
            Timestamp tt = this.getTimestamp(columnIndex);
            String tzSign = null;
            if (shor > 0) {
                tzSign = " +";
                minute = shor % 60;
                hours = shor / 60;
            } else {
                tzSign = " -";
                shor = (short)(shor - 2 * shor);
                minute = shor % 60;
                hours = shor / 60;
            }
            timeZon = String.format("%02d:%02d", hours, minute);
            times = tt.toString();
            twtz = times + tzSign + timeZon;
            this.isCalendar = false;
        }
        return twtz;
    }

    private Object getTimestampInternal(int columnIndex, boolean local) throws SQLException {
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        this.isAD = true;
        if (this.wasNullFlag) {
            return null;
        }
        long t = 0L;
        int date_t = 0;
        Comparable<ChronoLocalDateTime<?>> times = null;
        if (this.fields[columnIndex - 1].getRedhorseType() == 13 || this.fields[columnIndex - 1].getRedhorseType() == 14 || this.fields[columnIndex - 1].getRedhorseType() == 10) {
            int i;
            if (this.fields[columnIndex - 1].getRedhorseType() == 10) {
                date_t = this.getInt(columnIndex);
                t = (long)date_t * 86400000L;
            } else {
                if (this.fields[columnIndex - 1].getRedhorseType() == 14) {
                    this.isCalendar = true;
                }
                t = this.getLong(columnIndex);
            }
            if (this.isCalendar) {
                t += (long)this.tz_short * 60000000L;
            }
            this.dt2tm(t);
            int s = this.second;
            int h = s / 3600;
            int m = (s %= 3600) / 60;
            this.hour = h;
            this.minute = m;
            this.second = s %= 60;
            for (i = 0; i < 6 && this.ms % 10 == 0; ++i) {
                this.ms /= 10;
            }
            int zeroNum = i - 3;
            int msMultiplier = this.getMSMultiplier(zeroNum);
            if (local) {
                times = LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.ms * msMultiplier);
            } else {
                Timestamp innerTS = new Timestamp(this.year - 1900, this.month - 1, this.day, this.hour, this.minute, this.second, this.ms * msMultiplier);
                if (this.fields[columnIndex - 1].getRedhorseType() == 14) {
                    short shor = this.getShort(columnIndex);
                    int minute = 0;
                    int hours = 0;
                    if (shor > 0) {
                        minute = shor % 60;
                        hours = shor / 60;
                        times = new Timestamp(innerTS.getTime() + (long)(hours * 3600 * 1000) + (long)(minute * 60 * 1000));
                    } else {
                        shor = (short)(shor - 2 * shor);
                        minute = shor % 60;
                        hours = shor / 60;
                        times = new Timestamp(innerTS.getTime() - (long)(hours * 3600 * 1000) - (long)(minute * 60 * 1000));
                    }
                } else {
                    times = innerTS;
                }
            }
            this.isAD = this.year >= 0;
            this.isCalendar = false;
            return times;
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTimestamp    " + columnIndex, this.rsLogCount, false);
        }
        return (Timestamp)this.getTimestampInternal(columnIndex, false);
    }

    public LocalDateTime getLocalDatetime(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTimestamp    " + columnIndex, this.rsLogCount, false);
        }
        return (LocalDateTime)this.getTimestampInternal(columnIndex, true);
    }

    public String getInterval(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getInterval    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        StringBuilder returnStr = new StringBuilder();
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 10: 
            case 11: 
            case 13: {
                long msCount = this.getLong(columnIndex);
                if (msCount < 0L) {
                    returnStr.append("-");
                    msCount = Math.abs(msCount);
                }
                long second = msCount / 1000L;
                int mssecond1 = (int)(msCount % 1000L);
                long minute = second / 60L;
                int second1 = (int)(second % 60L);
                long hour = minute / 60L;
                int minute1 = (int)(minute % 60L);
                long day = hour / 24L;
                int hour1 = (int)(hour % 24L);
                long month = day / 30L;
                int day1 = (int)(day % 30L);
                long year = month / 12L;
                int month1 = (int)(month % 12L);
                return returnStr.append(year).append("-").append(month1).append("-").append(day1).append(" ").append(hour1).append(":").append(minute1).append(":").append(second1).append(".").append(this.handleMS(mssecond1)).toString();
            }
            case 24: {
                String usD2SString;
                long usD2S = this.getLong(columnIndex);
                if (usD2S < 0L) {
                    returnStr.append("-");
                    usD2S = Math.abs(usD2S);
                }
                if ((usD2SString = String.valueOf(usD2S)).length() <= 6) {
                    returnStr.append("0 0:0:0.").append(this.handleMS(usD2S));
                } else {
                    long all_se = usD2S / 1000000L;
                    int real_sse = Integer.valueOf(usD2SString.substring(usD2SString.length() - 6));
                    long se = all_se / 60L;
                    long real_se = all_se % 60L;
                    long minu = se % 60L;
                    long hur = se / 60L % 24L;
                    long dayse = all_se / 86400L;
                    returnStr.append(dayse).append(" ").append(hur).append(":").append(minu).append(":").append(real_se).append(".").append(this.handleMS(real_sse));
                }
                return returnStr.toString();
            }
            case 25: {
                String usH2SString;
                long usH2S = this.getLong(columnIndex);
                if (usH2S < 0L) {
                    returnStr.append("-");
                    usH2S = Math.abs(usH2S);
                }
                if ((usH2SString = String.valueOf(usH2S)).length() <= 6) {
                    returnStr.append("0:0:0.").append(this.handleMS(usH2S));
                } else {
                    long all_seH2S = usH2S / 1000000L;
                    int real_see = Integer.valueOf(usH2SString.substring(usH2SString.length() - 6));
                    long allminuH2S = all_seH2S / 60L;
                    long real_seH2S = all_seH2S % 60L;
                    long minuH2S = allminuH2S % 60L;
                    long hourH2S = all_seH2S / 60L / 60L;
                    returnStr.append(hourH2S).append(":").append(minuH2S).append(":").append(real_seH2S).append(".").append(this.handleMS(real_see));
                }
                return returnStr.toString();
            }
            case 26: {
                String usM2SString;
                long usM2S = this.getLong(columnIndex);
                if (usM2S < 0L) {
                    returnStr.append("-");
                    usM2S = Math.abs(usM2S);
                }
                if ((usM2SString = String.valueOf(usM2S)).length() <= 6) {
                    returnStr.append("0:0.").append(this.handleMS(usM2S));
                } else {
                    long all_seM2S = usM2S / 1000000L;
                    int millisM2S = Integer.valueOf(usM2SString.substring(usM2SString.length() - 6));
                    long real_seM2S = all_seM2S % 60L;
                    int minuM2S = (int)all_seM2S / 60;
                    returnStr.append(minuM2S).append(":").append(real_seM2S).append(".").append(this.handleMS(millisM2S));
                }
                return returnStr.toString();
            }
            case 27: {
                String usSString;
                long usS = this.getLong(columnIndex);
                if (usS < 0L) {
                    returnStr.append("-");
                    usS = Math.abs(usS);
                }
                if ((usSString = String.valueOf(usS)).length() <= 6) {
                    returnStr.append("0.").append(this.handleMS(usS));
                } else {
                    long real_seS = usS / 1000000L;
                    int milliS = Integer.valueOf(usSString.substring(usSString.length() - 6));
                    returnStr.append(real_seS).append(".").append(this.handleMS(milliS));
                }
                return returnStr.toString();
            }
            case 21: {
                int allMinute = this.getInt(columnIndex);
                if (allMinute < 0) {
                    returnStr.append("-");
                    allMinute = Math.abs(allMinute);
                }
                int allHour = allMinute / 60;
                int minuteD2M = allMinute % 60;
                int hourD2M = allHour % 24;
                int dayD2M = allHour / 24;
                returnStr.append(dayD2M).append(" ").append(hourD2M).append(":").append(minuteD2M);
                return returnStr.toString();
            }
            case 22: {
                int allMinuH2M = this.getInt(columnIndex);
                if (allMinuH2M < 0) {
                    returnStr.append("-");
                    allMinuH2M = Math.abs(allMinuH2M);
                }
                int realHourH2M = allMinuH2M / 60;
                int realMinuH2M = allMinuH2M % 60;
                returnStr.append(realHourH2M).append(":").append(realMinuH2M);
                return returnStr.toString();
            }
            case 19: {
                int allHourD2H = this.getInt(columnIndex);
                if (allHourD2H < 0) {
                    returnStr.append("-");
                    allHourD2H = Math.abs(allHourD2H);
                }
                int realHour = allHourD2H % 24;
                int realDay = allHourD2H / 24;
                returnStr.append(realDay).append(" ").append(realHour);
                return returnStr.toString();
            }
            case 16: {
                int allDate = this.getInt(columnIndex);
                if (allDate < 0) {
                    returnStr.append("-");
                    allDate = Math.abs(allDate);
                }
                int m = allDate % 12;
                int y = allDate / 12;
                returnStr.append(y).append("-").append(m);
                return returnStr.toString();
            }
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                return String.valueOf(this.getInt(columnIndex));
            }
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    private String getInterval_str(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getInterval_str    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 10: 
            case 11: 
            case 13: {
                long msCount = this.getLong(columnIndex);
                long second = msCount / 1000L;
                int mssecond1 = (int)(msCount % 1000L);
                long minute = second / 60L;
                int second1 = (int)(second % 60L);
                long hour = minute / 60L;
                int minute1 = (int)(minute % 60L);
                long day = hour / 24L;
                int hour1 = (int)(hour % 24L);
                long month = day / 30L;
                int day1 = (int)(day % 30L);
                long year = month / 12L;
                int month1 = (int)(month % 12L);
                return new String(year + "-" + Math.abs(month1) + "-" + Math.abs(day1) + " " + Math.abs(hour1) + ":" + Math.abs(minute1) + ":" + Math.abs(second1) + "." + Math.abs(mssecond1));
            }
            case 24: {
                long usD2S = this.getLong(columnIndex);
                long d2s_se = usD2S / 1000000L;
                String bediv = d2s_se + ".0000000";
                BigDecimal big = new BigDecimal(bediv);
                BigDecimal div = BigDecimal.valueOf(86400L);
                BigDecimal day_d2s = big.divide(div, 10, RoundingMode.FLOOR);
                return String.valueOf(day_d2s);
            }
            case 25: {
                long usH2S = this.getLong(columnIndex);
                long h2s_se = usH2S / 1000000L;
                float day_h2s = (float)Math.abs(h2s_se) / 3600.0f;
                return String.valueOf(day_h2s);
            }
            case 26: {
                long usM2S = this.getLong(columnIndex);
                long m2s_se = usM2S / 1000000L;
                float day_m2s = (float)Math.abs(m2s_se) / 60.0f;
                return String.valueOf(day_m2s);
            }
            case 27: {
                long usS = Math.abs(this.getLong(columnIndex));
                float day_s = (float)usS / 1000000.0f;
                return String.valueOf(day_s);
            }
            case 21: {
                int allMinute_d2m = this.getInt(columnIndex);
                float d2m_me = (float)Math.abs(allMinute_d2m) / 1440.0f;
                return String.valueOf(d2m_me);
            }
            case 22: {
                int allMinu_h2m = this.getInt(columnIndex);
                float h2m_me = (float)allMinu_h2m / 60.0f;
                return String.valueOf(h2m_me);
            }
            case 23: {
                int allMinu_mi = this.getInt(columnIndex);
                return String.valueOf(Math.abs(allMinu_mi));
            }
            case 19: {
                int allHourD2H = this.getInt(columnIndex);
                float d2h_hour = (float)Math.abs(allHourD2H) / 24.0f;
                return String.valueOf(d2h_hour);
            }
            case 20: {
                return String.valueOf(Math.abs(this.getInt(columnIndex)));
            }
            case 18: {
                return String.valueOf(Math.abs(this.getInt(columnIndex)));
            }
            case 16: {
                int allMonth = this.getInt(columnIndex);
                float y2m_mon = (float)Math.abs(allMonth) / 12.0f;
                return String.valueOf(y2m_mon);
            }
            case 17: {
                return String.valueOf(Math.abs(this.getInt(columnIndex)));
            }
            case 15: {
                return String.valueOf(Math.abs(this.getInt(columnIndex)));
            }
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    private String getGuid(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getGuid    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 29) {
            byte[] bytes = (byte[])this.currentRow[columnIndex - 1];
            return new String(bytes);
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Object returnStream = null;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getAsciiStream    " + columnIndex, this.rsLogCount, false);
        }
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        int colType = this.fields[columnIndex - 1].getRedhorseType();
        if (colType == 32) {
            java.sql.Clob clobData = this.getClob(columnIndex);
            if (clobData == null) {
                return null;
            }
            return clobData.getAsciiStream();
        }
        if (colType == 34) {
            java.sql.Blob blobData = this.getBlob(columnIndex);
            if (blobData == null) {
                return null;
            }
            return blobData.getBinaryStream();
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getUnicodeStream    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        StringBuffer unicodeString = new StringBuffer();
        String unicodeStr = null;
        try {
            InputStream in_data = this.getBinaryStream(columnIndex);
            if (in_data == null) {
                return null;
            }
            InputStreamReader read = new InputStreamReader(in_data, this.connection.getCharSet());
            BufferedReader reader = new BufferedReader(read);
            String line = null;
            while ((line = reader.readLine()) != null) {
                unicodeString.append(line).append("\r\n");
            }
            unicodeStr = this.getUnicodeString(unicodeString.substring(0, unicodeString.length() - 2));
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        catch (IOException e) {
            throw SQLCommon.innerIOException(e);
        }
        return new StringBufferInputStream(unicodeStr);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        java.sql.Blob blobData;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getBinaryStream    " + columnIndex, this.rsLogCount, false);
        }
        if ((blobData = this.getBlob(columnIndex)) == null) {
            return null;
        }
        return blobData.getBinaryStream();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public String getInterval(String columnName) throws SQLException {
        return this.getInterval(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SQLCommon.unSupportException("ResultSet.getCursorName", null);
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new ResultSetMetaData(this.fields, this.connection.isIsora(), this.connection);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getObject    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        this.isCalendar = false;
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 3: {
                if (this.getByte(columnIndex) == 0 && this.wasNullFlag) {
                    return null;
                }
                return this.getBigDecimal(columnIndex);
            }
            case 4: {
                if (this.getShort(columnIndex) == 0 && this.wasNullFlag) {
                    return null;
                }
                if (this.connection.isIsora()) {
                    return this.getBigDecimal(columnIndex);
                }
                return new Short(this.getShort(columnIndex));
            }
            case 5: {
                if (this.getInt(columnIndex) == 0 && this.wasNullFlag) {
                    return null;
                }
                if (this.connection.isIsora()) {
                    return this.getBigDecimal(columnIndex);
                }
                return new Integer(this.getInt(columnIndex));
            }
            case 6: {
                if (this.getLong(columnIndex) == 0L && this.wasNullFlag) {
                    return null;
                }
                if (this.connection.isIsora()) {
                    return this.getBigDecimal(columnIndex);
                }
                return this.getBigDecimal(columnIndex);
            }
            case 8: {
                if ((double)this.getFloat(columnIndex) == 0.0 && this.wasNullFlag) {
                    return null;
                }
                if (this.connection.isIsora()) {
                    return this.getBigDecimal(columnIndex);
                }
                return new Float(this.getFloat(columnIndex));
            }
            case 9: {
                if (this.getDouble(columnIndex) == 0.0 && this.wasNullFlag) {
                    return null;
                }
                if (this.connection.isIsora()) {
                    return this.getBigDecimal(columnIndex);
                }
                return new Double(this.getDouble(columnIndex));
            }
            case 7: {
                return this.getBigDecimal(columnIndex);
            }
            case 2: {
                if (this.wasNull()) {
                    return null;
                }
                return new Boolean(this.getBoolean(columnIndex));
            }
            case 28: 
            case 30: 
            case 45: 
            case 47: {
                return this.getString(columnIndex);
            }
            case 10: {
                Date dd = this.getDate(columnIndex);
                return this.getDate(columnIndex);
            }
            case 11: {
                return this.getTime(columnIndex);
            }
            case 12: {
                this.isCalendar = true;
                return this.getTime_TZ(columnIndex);
            }
            case 13: {
                return this.getTimestamp(columnIndex);
            }
            case 14: {
                this.isCalendar = true;
                return this.getTimeStamp_TZ(columnIndex);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (this.connection.compatibleQX || this.connection.isIsora()) {
                    return this.getInterval_str(columnIndex);
                }
                return this.getInterval(columnIndex);
            }
            case 33: {
                return this.getBinaryStream(columnIndex);
            }
            case 34: {
                return this.getBlob(columnIndex);
            }
            case 32: {
                return this.getClob(columnIndex);
            }
            case 29: {
                return this.getGuid(columnIndex);
            }
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer index;
        this.checkClosed();
        if (!this.hasBuiltIndexMapping) {
            this.buildIndexMapping();
        }
        if (this.connection.getCata_Caps() == 0) {
            index = (Integer)this.columnNameToIndex.get(columnName.toUpperCase().trim());
            if (index == null) {
                index = (Integer)this.fullColumnNameToIndex.get(columnName.toUpperCase().trim());
            }
        } else {
            index = (Integer)this.columnNameToIndex.get(columnName.trim());
            if (index == null) {
                index = (Integer)this.fullColumnNameToIndex.get(columnName.trim());
            }
        }
        if (index == null) {
            throw Error.createSQLException("[E51040]\u65e0\u6cd5\u67e5\u627e\u5230\u7ed9\u5b9a\u5217\u540d\u7684\u5bf9\u5e94\u5217\u503c: " + columnName, ReplaceEnum.excStr.getReplaceStr() + 51040, 51040);
        }
        int colIndex = index + 1;
        return colIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        java.sql.Clob clobData;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getCharacterStream    " + columnIndex, this.rsLogCount, false);
        }
        if ((clobData = this.getClob(columnIndex)) == null) {
            return null;
        }
        return clobData.getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getBigDecimal    " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkCellNull(columnIndex);
        BigDecimal decimal = null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 9 || this.fields[columnIndex - 1].getRedhorseType() == 8 || this.fields[columnIndex - 1].getRedhorseType() == 3 || this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 7 || this.fields[columnIndex - 1].getRedhorseType() == 30) {
            try {
                String temp = this.getString(columnIndex);
                if (temp == null) return decimal;
                if (temp.equals("")) return decimal;
                return new BigDecimal(temp);
            }
            catch (NumberFormatException e) {
                throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 10) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 11) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 12) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 18) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 19) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 21) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 20) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 22) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 17) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 23) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 15) return new BigDecimal(this.getInt(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 16) {
            return new BigDecimal(this.getInt(columnIndex));
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 13) return new BigDecimal(this.getLong(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 24) return new BigDecimal(this.getLong(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 14) return new BigDecimal(this.getLong(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 25) return new BigDecimal(this.getLong(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() == 26) return new BigDecimal(this.getLong(columnIndex));
        if (this.fields[columnIndex - 1].getRedhorseType() != 27) throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
        return new BigDecimal(this.getLong(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "isBeforeFirst    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        return this.getRowData().isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "isAfterLast    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        this.checkCursor();
        while (!this.isRsIsOver()) {
            if (!Command.debug) continue;
            Command.logRsOverState(this.connection.io, "isAfterLast  " + this.rs_sql, this.isRsIsOver());
        }
        return this.getRowData().isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "isFirst    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        return this.getRowData().isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "isLast    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        this.checkCursor();
        while (!this.isRsIsOver()) {
            if (!Command.debug) continue;
            Command.logRsOverState(this.connection.io, "isLast  " + this.rs_sql, this.isRsIsOver());
        }
        return this.getRowData().isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "beforeFirst    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.getRowData().getIndex() != -1) {
            this.checkReverseable();
            if (this.getRowData().size() != 0) {
                this.getRowData().beforeFirst();
                this.currentRow = null;
            }
        }
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        this.isMoveTOData = false;
    }

    @Override
    public void afterLast() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "afterLast    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.getRowData().size() != 0) {
            while (!this.isRsIsOver()) {
                if (!Command.debug) continue;
                Command.logRsOverState(this.connection.io, "afterLast  " + this.rs_sql, this.isRsIsOver());
            }
            this.getRowData().afterLast();
            this.currentRow = null;
        }
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        this.isMoveTOData = false;
    }

    @Override
    public boolean first() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, this.logString("first"), this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        this.currentRow = null;
        if (this.getRowData().getIndex() != -1) {
            this.checkReverseable();
        }
        this.getRowData().beforeFirst();
        this.currentRow = this.getRowData().getNextRow();
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        this.isMoveTOData = true;
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, this.logString("last"), this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkCursor();
        if (this.isRowDataNull()) {
            return false;
        }
        while (!this.isRsIsOver()) {
            if (!Command.debug) continue;
            Command.logRsOverState(this.connection.io, "last  " + this.rs_sql, this.isRsIsOver());
        }
        this.getRowData().beforeLast();
        this.currentRow = this.getRowData().getNextRow();
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        this.isMoveTOData = true;
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getRow    ", this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.getRowData().size() == 0) {
            return 0;
        }
        return this.getRowData().getIndex() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, this.logString("absolute  " + row), this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull() && !this.isCursor()) {
            return false;
        }
        boolean backBoolean = true;
        this.currentRow = null;
        if (row <= 0) {
            if (row == 0) {
                return true;
            }
            this.checkReverseable();
            while (!this.isRsIsOver()) {
                if (!Command.debug) continue;
                Command.logRsOverState(this.connection.io, "absolute " + row + ".  " + this.rs_sql, this.isRsIsOver());
            }
            if (row == -1) {
                backBoolean = this.last();
            } else {
                int newRowPosition = this.getRowData().size() + row + 1;
                if (newRowPosition <= 0) {
                    this.beforeFirst();
                    return false;
                }
                this.getRowData().setIndex(newRowPosition - 1);
                this.currentRow = this.getRowData().getAt(newRowPosition - 1);
                backBoolean = true;
            }
        } else if (this.isCursor()) {
            if (row - this.getMoveIndex() < 0) {
                this.checkReverseable();
            }
            if (this.getMoveIndex() == -1) {
                this.isFistAb = true;
            }
            this.absolutRows = row;
            this.isAbsolute = true;
            backBoolean = this.next();
        } else {
            while (this.getRowCount() < row && !this.isRsIsOver()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.getRowCount() < row) {
                this.afterLast();
                return false;
            }
            this.getRowData().setIndex(--row);
            this.currentRow = this.getRowData().getAt(row);
            backBoolean = true;
        }
        this.isMoveTOData = true;
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        return backBoolean;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, this.logString("relative  " + rows), this.rsLogCount, true);
        }
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        if (rows == 0) {
            return true;
        }
        this.currentRow = null;
        int rowIndex = this.getRowData().getIndex();
        if (rows < 0) {
            this.checkReverseable();
        }
        if (rows + rowIndex > this.getRowData().size()) {
            while (!this.isRsIsOver()) {
                if (!Command.debug) continue;
                Command.logRsOverState(this.connection.io, "relative " + rows + ".  " + this.rs_sql, this.isRsIsOver());
            }
        }
        if (rowIndex + rows > -1 && rowIndex + rows < this.getRowData().size()) {
            this.getRowData().setIndex(rowIndex += rows);
            this.currentRow = this.getRowData().getAt(rowIndex);
            this.isMoveTOData = true;
        } else if (rowIndex + rows <= -1) {
            this.getRowData().beforeFirst();
            this.isMoveTOData = false;
            this.currentRow = null;
        } else {
            this.getRowData().afterLast();
            this.isMoveTOData = false;
            this.currentRow = null;
        }
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, this.logString("previous  "), this.rsLogCount, true);
        }
        boolean preBoolean = false;
        this.checkClosed();
        if (this.isRowDataNull()) {
            return false;
        }
        this.checkReverseable();
        this.currentRow = null;
        int rowIndex = this.getRowData().getIndex();
        if (rowIndex - 1 >= 0) {
            this.getRowData().setIndex(--rowIndex);
            this.currentRow = this.getRowData().getAt(rowIndex);
            preBoolean = true;
        } else if (rowIndex - 1 == -1) {
            this.getRowData().setIndex(--rowIndex);
            this.currentRow = null;
            preBoolean = false;
        } else {
            this.getRowData().setIndex(-2);
            preBoolean = false;
        }
        this.resumeUpdateString();
        this.isOnInsertRow = false;
        this.isCancle = false;
        this.isUpdateRow = false;
        this.isMoveTOData = true;
        return preBoolean;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "setFetchDirection   " + direction, this.rsLogCount, true);
        }
        if (direction == 1001 && (this.isCursor() || this.rsType == 1003)) {
            throw Error.createSQLException("[E51041]ResultSet:\u5bf9\u53ea\u5411\u524d\u7ed3\u679c\u96c6\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u9006\u5411\u5904\u7406\u65b9\u5411", ReplaceEnum.excStr.getReplaceStr() + 51041, 51041);
        }
        this.rsDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getFetchDirection   ", this.rsLogCount, true);
        }
        return this.rsDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "setFetchSize   " + rows, this.rsLogCount, true);
        }
        if (rows < 0) {
            throw Error.createSQLException("[E51042]ResultSet:\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u884c\u6570\u4e0d\u80fd\u5c0f\u4e8e\u96f6", ReplaceEnum.excStr.getReplaceStr() + 51042, 51042);
        }
        if (rows == 0) {
            rows = 1000;
        }
        this.getStatement().setFetchSize(rows);
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (Command.debug && !this.innerFetchSize) {
            Command.logRSmethods(this.connection.io, "getFetchSize   ", this.rsLogCount, true);
        }
        return this.fetchSize;
    }

    private int getFecheSizeInner() throws SQLException {
        this.innerFetchSize = true;
        int size = this.getFetchSize();
        this.innerFetchSize = false;
        return size;
    }

    @Override
    public int getType() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getType  ", this.rsLogCount, true);
        }
        return this.getStatement().getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getConcurrency  ", this.rsLogCount, true);
        }
        return this.getStatement().getResultSetConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "rowUpdated  ", this.rsLogCount, true);
        }
        this.checkClosed();
        return this.isUpdateRow;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "rowInserted  ", this.rsLogCount, true);
        }
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "rowDeleted  ", this.rsLogCount, true);
        }
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNull  " + columnIndex, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        this.initUpString(columnIndex, null, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBoolean  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() != 2) {
            throw this.updateTypeConverExcpt;
        }
        byte[] data = new byte[]{x ? (byte)84 : 70};
        this.initUpString(columnIndex, String.valueOf(x), data);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateByte  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() != 6 && this.fields[columnIndex - 1].getRedhorseType() != 5 && this.fields[columnIndex - 1].getRedhorseType() != 4 && this.fields[columnIndex - 1].getRedhorseType() != 8 && this.fields[columnIndex - 1].getRedhorseType() != 9 && this.fields[columnIndex - 1].getRedhorseType() != 30 && this.fields[columnIndex - 1].getRedhorseType() != 3) {
            throw this.updateTypeConverExcpt;
        }
        byte[] data = new byte[]{x};
        this.initUpString(columnIndex, String.valueOf(x), data);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateShort  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 3) {
            byte[] data = this.convert_byte(2, x);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 7) {
            byte[] updateBytes = String.valueOf(x).getBytes();
            this.initUpString(columnIndex, "'" + x + "'", updateBytes);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 8) {
            byte[] data = this.convert_byte_double(x, 4);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 9) {
            byte[] data = this.convert_byte_double(x, 8);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateInt  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 3) {
            byte[] realData = this.convert_byte(4, x);
            this.initUpString(columnIndex, String.valueOf(x), realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 7) {
            byte[] updateBytes = String.valueOf(x).getBytes();
            this.initUpString(columnIndex, "'" + x + "'", updateBytes);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 8) {
            byte[] data = this.convert_byte_double(x, 4);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 9) {
            byte[] data = this.convert_byte_double(x, 8);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateLong  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 3) {
            byte[] data = this.convert_byte(8, x);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 7) {
            byte[] updateBytes = String.valueOf(x).getBytes();
            this.initUpString(columnIndex, "'" + x + "'", updateBytes);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 8) {
            byte[] data = this.convert_byte_double(x, 4);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 9) {
            byte[] data = this.convert_byte_double(x, 8);
            this.initUpString(columnIndex, String.valueOf(x), data);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateFloat  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() == 8 || this.fields[columnIndex - 1].getRedhorseType() == 9) {
            byte[] realData = this.convert_byte_double(x, 4);
            this.initUpString(columnIndex, String.valueOf(x), realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 3) {
            String pointStr;
            String floatStr = String.valueOf(x);
            int point = 0;
            point = floatStr.indexOf(".");
            if (point != -1 && Integer.parseInt(pointStr = floatStr.substring(point + 1)) > 0) {
                throw this.updateTypeConverExcpt;
            }
            byte[] realData = this.convert_byte(4, Float.valueOf(x).longValue());
            this.initUpString(columnIndex, String.valueOf(x), realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 7) {
            byte[] updateBytes = String.valueOf(x).getBytes();
            this.initUpString(columnIndex, "'" + x + "'", updateBytes);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateDouble  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (this.fields[columnIndex - 1].getRedhorseType() == 9) {
            byte[] realData = this.convert_byte_double(x, 8);
            this.initUpString(columnIndex, String.valueOf(x), realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 8) {
            if (x >= 3.4E38 || x <= -3.4E38) {
                throw this.updateTypeConverExcpt;
            }
            byte[] realData = this.convert_byte_double(x, 4);
            this.initUpString(columnIndex, String.valueOf(x), realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 6 || this.fields[columnIndex - 1].getRedhorseType() == 5 || this.fields[columnIndex - 1].getRedhorseType() == 4 || this.fields[columnIndex - 1].getRedhorseType() == 3) {
            String pointStr;
            String doubleStr = String.valueOf(x);
            int point = 0;
            point = doubleStr.indexOf(".");
            if (point != -1 && Integer.parseInt(pointStr = doubleStr.substring(point + 1)) > 0) {
                throw this.updateTypeConverExcpt;
            }
            byte[] realData = this.convert_byte(4, Double.valueOf(x).longValue());
            this.initUpString(columnIndex, String.valueOf(x), realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 7) {
            byte[] updateBytes = String.valueOf(x).getBytes();
            this.initUpString(columnIndex, "'" + x + "'", updateBytes);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBigDecimal  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int type = this.fields[columnIndex - 1].getRedhorseType();
        byte[] realData = null;
        switch (type) {
            case 3: {
                realData = new byte[]{x.byteValue()};
                break;
            }
            case 4: {
                realData = ByteBuffer.allocate(2).putShort(x.shortValue()).array();
                break;
            }
            case 5: {
                realData = ByteBuffer.allocate(4).putInt(x.intValue()).array();
                break;
            }
            case 6: {
                realData = ByteBuffer.allocate(8).putLong(x.longValue()).array();
                break;
            }
            case 8: {
                realData = ByteBuffer.allocate(4).putFloat(x.floatValue()).array();
                break;
            }
            case 9: {
                realData = ByteBuffer.allocate(8).putDouble(x.doubleValue()).array();
                break;
            }
            case 7: 
            case 30: {
                realData = this.convert_byte_bigdecimal(x.doubleValue());
                break;
            }
            default: {
                throw this.updateTypeConverExcpt;
            }
        }
        this.initUpString(columnIndex, "'" + String.valueOf(x) + "'", realData);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateString  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        if (this.fields[columnIndex - 1].getRedhorseType() != 30 && this.fields[columnIndex - 1].getRedhorseType() != 32) {
            throw this.updateTypeConverExcpt;
        }
        this.initUpString(columnIndex, "'" + x + "'", x.getBytes());
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBytes  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        Vector<Object> cellVector = new Vector<Object>();
        String columnName = this.fields[columnIndex - 1].getColumnName();
        this.insertRows = this.insertRows + "\"" + columnName + "\",";
        this.currentRow[columnIndex - 1] = x;
        if (this.updateRowsBytes == null) {
            this.updateRowsBytes = new byte[this.currentRow.length][];
        }
        switch (this.fields[columnIndex - 1].getRedhorseType()) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                this.insertValues = this.insertValues + new String(x) + ",";
                this.updateRowsValues.append("\"" + columnName + "\"='" + new String(x) + "',");
                break;
            }
            case 6: {
                long realIntb = this.conver_byte_long(x, 8);
                this.insertValues = this.insertValues + realIntb + ",";
                this.updateRowsValues.append("\"" + columnName + "\"=" + realIntb + ",");
                break;
            }
            case 5: {
                long realInti = this.conver_byte_long(x, 4);
                this.insertValues = this.insertValues + realInti + ",";
                this.updateRowsValues.append("\"" + columnName + "\"=" + realInti + ",");
                break;
            }
            case 4: {
                long realInts = this.conver_byte_long(x, 2);
                this.insertValues = this.insertValues + realInts + ",";
                this.updateRowsValues.append("\"" + columnName + "\"=" + realInts + ",");
                break;
            }
            case 3: {
                long realIntT = this.conver_byte_long(x, 1);
                this.insertValues = this.insertValues + realIntT + ",";
                this.updateRowsValues.append("\"" + columnName + "\"=" + realIntT + ",");
                break;
            }
            case 7: 
            case 9: {
                double dd = new Double(new String(x));
                this.insertValues = this.insertValues + dd + ",";
                this.updateRowsValues.append("\"" + columnName + "\"=" + dd + ",");
                break;
            }
            case 8: {
                float ff = new Double(new String(x)).floatValue();
                this.insertValues = this.insertValues + ff + ",";
                this.updateRowsValues.append("\"" + columnName + "\"=" + ff + ",");
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                this.insertValues = this.insertValues + "?,";
                this.updateRowsValues.append("\"" + columnName + "\"=?,");
                cellVector.add(x);
                cellVector.add(TypesUtil.getRedhorseType("BINARY"));
                this.param.add(cellVector);
                ++this.hugeParamCount;
                break;
            }
            default: {
                throw this.updateTypeConverExcpt;
            }
        }
        System.arraycopy(this.currentRow, 0, this.updateRowsBytes, 0, this.currentRow.length);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateDate  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        Date hd = x;
        int yd = 0;
        int md = 0;
        int rn_num = 0;
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        if (this.fields[columnIndex - 1].getRedhorseType() == 10 || this.fields[columnIndex - 1].getRedhorseType() == 32 || this.fields[columnIndex - 1].getRedhorseType() == 30) {
            int yy = x.getYear() + 1900;
            int mm = x.getMonth() + 1;
            int dd = x.getDate();
            if (yy - 1970 > 0) {
                rn_num = (yy - 1) / 4 - (yy - 1) / 100 + (yy - 1) / 400;
                rn_num = rn_num - 477 - 1;
            } else {
                rn_num = (yy + 1) / 4 - (yy + 1) / 100 + (yy + 1) / 400;
                rn_num = rn_num - 477 - 1;
            }
            yd = (yy - 1970) * 365 + rn_num;
            if (mm >= 1) {
                md = ResultSet.isRn(yy) ? Connection.MTOD[1][mm - 1] : Connection.MTOD[0][mm - 1];
            } else {
                throw Error.createSQLException("[E50089]\u975e\u6cd5\u7684DATE\u6570\u636e", ReplaceEnum.excStr.getReplaceStr() + 50089, 50089);
            }
            byte[] realData = new byte[4];
            this.time_convert_byte(realData, yd + md + dd);
            this.currentRow[columnIndex - 1] = realData;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String str = sdf.format(x);
            this.initUpString(columnIndex, "'" + str + "'", realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 13) {
            Timestamp createTime = new Timestamp(x.getTime());
            this.updateTimestamp(columnIndex, createTime);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateTime  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        if (this.fields[columnIndex - 1].getRedhorseType() != 11 && this.fields[columnIndex - 1].getRedhorseType() != 25 && this.fields[columnIndex - 1].getRedhorseType() != 30 && this.fields[columnIndex - 1].getRedhorseType() != 32) {
            throw this.updateTypeConverExcpt;
        }
        int all_time = x.getHours() * 3600000 + x.getMinutes() * 60000 + x.getSeconds() * 1000;
        byte[] realData = new byte[4];
        this.time_convert_byte(realData, all_time);
        this.initUpString(columnIndex, "'" + x.toString() + "'", realData);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateTimestamp  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        long all_time = 0L;
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int fieldType = this.fields[columnIndex - 1].getRedhorseType();
        if (this.fields[columnIndex - 1].getRedhorseType() == 13 || this.fields[columnIndex - 1].getRedhorseType() == 32 || this.fields[columnIndex - 1].getRedhorseType() == 30 || this.fields[columnIndex - 1].getRedhorseType() == 11) {
            Timestamp tspm = new Timestamp(62167132800000L);
            int compare = x.compareTo(new Timestamp(tspm.getYear() - 1970, tspm.getMonth(), tspm.getDay(), tspm.getHours() - 8, tspm.getMinutes(), tspm.getSeconds(), tspm.getNanos()));
            all_time = compare > 0 ? x.getTime() + 28800000L : x.getTime() - 576000000L;
            byte[] realData = new byte[8];
            this.time_convert_byte(realData, all_time);
            this.initUpString(columnIndex, "'" + x.toString() + "'", realData);
        } else if (this.fields[columnIndex - 1].getRedhorseType() == 10) {
            Date createDate = new Date(x.getTime());
            this.updateDate(columnIndex, createDate);
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateAsciiStream  " + columnIndex + "   " + x + "  (int) " + length, this.rsLogCount, true);
        }
        this.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBytesinaryStream  " + columnIndex + "   " + x + "  (int) " + length, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkConcurrency();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.checkObj_length(length);
        this.cancelUpdate();
        if (x == null || length == 0) {
            this.updateNull(columnIndex);
            return;
        }
        int len = 0;
        byte[] data = null;
        Vector<Object> cellVector = new Vector<Object>();
        Vector dataVector = new Vector();
        try {
            dataVector = this.getInRealLength(x, length);
            len = (Integer)dataVector.get(1);
            this.checkObj_length(len);
            data = (byte[])dataVector.get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 33 || this.fields[columnIndex - 1].getRedhorseType() == 34 || this.fields[columnIndex - 1].getRedhorseType() == 32) {
            this.initUpString(columnIndex, "?", data);
            cellVector.add(data);
            cellVector.add(TypesUtil.getRedhorseType("BINARY"));
            this.param.add(cellVector);
            ++this.hugeParamCount;
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateCharacterStream  " + columnIndex + "   " + x + "  (int) " + length, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.checkObj_length(length);
        this.cancelUpdate();
        if (x == null || length == 0) {
            this.updateNull(columnIndex);
            return;
        }
        int len = 0;
        String data = null;
        Vector<Object> cellVector = new Vector<Object>();
        Vector dataVector = new Vector();
        try {
            dataVector = this.getReaderRealData(x, length);
            len = (Integer)dataVector.get(1);
            this.checkObj_length(len);
            data = (String)dataVector.get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 33 || this.fields[columnIndex - 1].getRedhorseType() == 34 || this.fields[columnIndex - 1].getRedhorseType() == 32) {
            this.initUpString(columnIndex, "?", data.getBytes());
            cellVector.add(data.getBytes());
            cellVector.add(TypesUtil.getRedhorseType("CLOB"));
            this.param.add(cellVector);
            ++this.hugeParamCount;
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateObject  " + columnIndex + "   " + x + "   " + scale, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] buffer = new byte[1024];
        int length = -1;
        if (x instanceof BigDecimal) {
            BigDecimal x1 = (BigDecimal)x;
            x1.setScale(scale);
            this.updateObject(columnIndex, (Object)x1);
        }
        if (x instanceof InputStream) {
            InputStream ips = (InputStream)x;
            try {
                if (ips.available() < scale) {
                    throw Error.createSQLException("[E50093]\u6570\u636e\u6d41\u957f\u5ea6\u4e0d\u591f\u6307\u5b9a\u7684\u5b57\u8282\u6570", ReplaceEnum.excStr.getReplaceStr() + 50093, 50093);
                }
                byte[] inbuffer = new byte[scale];
                length = ips.read(inbuffer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (length != -1) {
                ByteArrayInputStream baps = new ByteArrayInputStream(buffer);
                this.updateObject(columnIndex, (Object)baps);
            } else {
                throw Error.createSQLException("[E50049]ResultSet: the scale has gone beyond the size of Object ", ReplaceEnum.excStr.getReplaceStr() + 50049, 50049);
            }
        }
        if (x instanceof Reader) {
            Reader rd = (Reader)x;
            BufferedReader r = new BufferedReader(rd);
            StringBuffer b = new StringBuffer();
            String line = null;
            char[] cbuffer = new char[scale];
            try {
                while ((line = r.readLine()) != null) {
                    b.append(line);
                }
                if (b.length() < scale) {
                    throw Error.createSQLException("[E50093]\u6570\u636e\u6d41\u957f\u5ea6\u4e0d\u591f\u6307\u5b9a\u7684\u5b57\u8282\u6570", ReplaceEnum.excStr.getReplaceStr() + 50093, 50093);
                }
                rd.read(cbuffer);
                CharArrayReader crd = new CharArrayReader(cbuffer);
                this.updateObject(columnIndex, (Object)crd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.updateObject(columnIndex, x);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateObject  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        if (x instanceof Byte) {
            this.updateByte(columnIndex, (byte)((Byte)x));
        } else if (x instanceof String) {
            this.updateString(columnIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.updateBigDecimal(columnIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.updateShort(columnIndex, (short)((Short)x));
        } else if (x instanceof Integer) {
            this.updateInt(columnIndex, (int)((Integer)x));
        } else if (x instanceof Long) {
            this.updateLong(columnIndex, (long)((Long)x));
        } else if (x instanceof Float) {
            this.updateFloat(columnIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.updateDouble(columnIndex, (double)((Double)x));
        } else if (x instanceof byte[]) {
            this.updateBytes(columnIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.updateDate(columnIndex, (Date)x);
        } else if (x instanceof Time) {
            this.updateTime(columnIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.updateTimestamp(columnIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.updateBoolean(columnIndex, (boolean)((Boolean)x));
        } else if (x instanceof InputStream) {
            this.updateBinaryStream(columnIndex, (InputStream)x);
        } else if (x instanceof Reader) {
            this.updateCharacterStream(columnIndex, (Reader)x);
        } else if (x instanceof java.sql.Blob) {
            this.updateBlob(columnIndex, (java.sql.Blob)x);
        } else if (x instanceof java.sql.Clob) {
            this.updateClob(columnIndex, (java.sql.Clob)x);
        } else if (x instanceof java.util.Date) {
            this.updateTimestamp(columnIndex, new Timestamp(((java.util.Date)x).getTime()));
        } else if (x instanceof BigInteger) {
            this.updateString(columnIndex, x.toString());
        } else {
            throw Error.createSQLException("[E50094]\u9519\u8bef\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 50094, 50094);
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x, -1);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void insertRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "insertRow  ", this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkConcurrency();
        if (!this.isOnInsertRow) {
            throw Error.createSQLException("[E50057]Resultset: the cursor doesn't on the insert row", ReplaceEnum.excStr.getReplaceStr() + 50057, 50057);
        }
        if (this.insertRows.length() == 0) {
            throw Error.createSQLException("[E50058]Resultset: can't insert a row with no values", ReplaceEnum.excStr.getReplaceStr() + 50058, 50058);
        }
        this.messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("ResultSet.insertString"));
        this.insertRows = this.insertRows.substring(0, this.insertRows.length() - 1);
        this.insertValues = this.insertValues.substring(0, this.insertValues.length() - 1);
        this.insertString = this.messFormat.format(new String[]{this.updateTabName, "(" + this.insertRows + ")", "(" + this.insertValues + ")"});
        if (this.hugeParamCount != 0) {
            this.joinParamSQL();
            this.statement.paramBytes = this.paramBytes;
        }
        try {
            this.statement.execute(this.insertString);
            this.newRow[this.fields.length - 1] = this.statement.getRowid().get(1).getBytes();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.resumeUpdateString();
            this.isOnInsertRow = false;
        }
    }

    void joinParamSQL() {
        int totalLength = 4;
        byte[] typeAsByte = new byte[2];
        byte[] lengthAsByte = new byte[4];
        int mask = 255;
        for (int i = 0; i < this.hugeParamCount; ++i) {
            totalLength += this.getParamLength(i) + 10;
        }
        this.paramBytes = new byte[totalLength];
        this.paramBytes[0] = (byte)(this.hugeParamCount >>> 24 & 0xFF);
        this.paramBytes[1] = (byte)(this.hugeParamCount >>> 16 & 0xFF);
        this.paramBytes[2] = (byte)(this.hugeParamCount >>> 8 & 0xFF);
        this.paramBytes[3] = (byte)(this.hugeParamCount & 0xFF);
        int currentPosition = 4;
        for (int i = 0; i < this.hugeParamCount; ++i) {
            int j;
            int paramLen = this.getParamLength(i);
            for (j = 0; j < 2; ++j) {
                typeAsByte[j] = 0;
            }
            System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
            currentPosition += 2;
            for (j = 0; j < 2; ++j) {
                typeAsByte[j] = (byte)(1 >>> 8 - 8 * j & mask);
            }
            System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
            currentPosition += 2;
            for (j = 0; j < 2; ++j) {
                typeAsByte[j] = (byte)(this.getParamType(i) >>> 8 - 8 * j & mask);
            }
            System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
            currentPosition += 2;
            for (j = 0; j < 4; ++j) {
                lengthAsByte[j] = (byte)(paramLen >>> 24 - 8 * j & mask);
            }
            System.arraycopy(lengthAsByte, 0, this.paramBytes, currentPosition, 4);
            System.arraycopy(this.getParamData(i), 0, this.paramBytes, currentPosition += 4, paramLen);
            currentPosition += paramLen;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateRow  ", this.rsLogCount, true);
        }
        if (this.updateRowsValues == null || this.updateRowsValues.equals("")) {
            return;
        }
        if (this.currentRow == null) {
            throw Error.createSQLException("[E50059]Resultset: \u5f53\u524d\u884c\u65e0\u6570\u636e\uff0c\u8bf7\u8c03\u7528ResultSet.next\u65b9\u6cd5\u3002", ReplaceEnum.excStr.getReplaceStr() + 50059, 50059);
        }
        this.checkClosed();
        this.checkConcurrency();
        this.checkRowid();
        if (!this.isCancle) {
            this.messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("ResultSet.updateString"));
            String updateCol = this.updateRowsValues.toString();
            String updateStr = this.messFormat.format(new String[]{this.updateTabName, updateCol.substring(0, updateCol.length() - 1), "'" + this.rowIdValues + "'"});
            this.connection.checkOpen();
            if (this.statement.isClosed()) {
                this.statement = (Statement)this.connection.createStatement(1004, 1008);
            }
            if (this.hugeParamCount != 0) {
                this.joinParamSQL();
                this.statement.paramBytes = this.paramBytes;
            }
            try {
                this.statement.executeUpdate(updateStr);
                System.arraycopy(this.updateRowsBytes, 0, this.currentRow, 0, this.currentRow.length);
                this.isUpdateRow = true;
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                this.resumeUpdateString();
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "deleteRow  ", this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkConcurrency();
        this.checkRowPosition();
        this.checkRowid();
        if (this.isOnInsertRow) {
            throw Error.createSQLException("[E50059]Resultset: can't delete a row when the cursor is on the insert row", ReplaceEnum.excStr.getReplaceStr() + 50059, 50059);
        }
        this.messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("ResultSet.deleteString"));
        this.statement.executeUpdate(this.messFormat.format(new String[]{this.updateTabName, "'" + this.rowIdValues + "'"}));
    }

    @Override
    public void refreshRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "refreshRow  ", this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.refreshRow", null);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "cancelRowUpdates  ", this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkConcurrency();
        if (!this.isOnInsertRow) {
            throw Error.createSQLException("[E50057]Resultset: the cursor doesn't on the insert row", ReplaceEnum.excStr.getReplaceStr() + 50057, 50057);
        }
        if (!this.isUpdateRow) {
            this.currentRow = (Object[])this.copyRow;
            this.resumeUpdateString();
            this.isCancle = true;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "moveToInsertRow  ", this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkConcurrency();
        if (!this.getRowData().isEmpty()) {
            this.newRow = new byte[this.fields.length][];
            this.isOnInsertRow = true;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "moveToCurrentRow  ", this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkConcurrency();
        if (this.isOnInsertRow) {
            this.isOnInsertRow = false;
            this.resumeUpdateString();
        }
    }

    @Override
    public java.sql.Statement getStatement() throws SQLException {
        return this.statement;
    }

    public void setWrapperStatement(java.sql.Statement wrapperStatement) {
        this.statementWrapp = wrapperStatement;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getRef  " + i, this.rsLogCount, false);
        }
        throw SQLCommon.unSupportException("ResultSet.getRef", "int");
    }

    @Override
    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getBlob  " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        boolean flag = false;
        Blob real_data_blob = null;
        byte[] bytes = (byte[])this.currentRow[columnIndex - 1];
        if (this.getField(columnIndex - 1).getFiledFlag() && this.connection.useLobDescribMode()) {
            flag = this.statement.isDirectLob(bytes[0]);
            real_data_blob = new Blob(bytes, flag, this.connection.lobStatement(), this, columnIndex);
            if (bytes.length == 2 && bytes[1] == 0) {
                real_data_blob.setLobEmpty(true);
            }
        } else {
            real_data_blob = new Blob(bytes, this, this.connection, columnIndex);
            if (bytes.length == 1 && bytes[0] == 0) {
                real_data_blob.setLobEmpty(true);
            }
        }
        return real_data_blob;
    }

    @Override
    public java.sql.Clob getClob(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getClob  " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        this.checkClosed();
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        boolean flag = false;
        Clob real_data_clob = null;
        byte[] bytes = (byte[])this.currentRow[columnIndex - 1];
        if (this.getField(columnIndex - 1).getFiledFlag() && this.connection.useLobDescribMode()) {
            flag = this.statement.isDirectLob(bytes[0]);
            real_data_clob = new Clob(bytes, flag, this.connection.lobStatement(), this, columnIndex);
            if (bytes.length == 2 && bytes[1] == 0) {
                real_data_clob.setLobEmpty(true);
            }
        } else {
            real_data_clob = new Clob(this.connection.io.getStringWithCharactor(bytes), this, this.connection, columnIndex);
            if (bytes.length == 1 && bytes[0] == 0) {
                real_data_clob.setLobEmpty(true);
            }
        }
        return real_data_clob;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getArray  " + i, this.rsLogCount, false);
        }
        throw SQLCommon.unSupportException("ResultSet.getArray", "int");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public java.sql.Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public java.sql.Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getDate  " + columnIndex + "   " + cal, this.rsLogCount, false);
        }
        if ((date = this.getDate(columnIndex)) == null) {
            return null;
        }
        cal.setTime(date);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTime  " + columnIndex + "   " + cal, this.rsLogCount, false);
        }
        if ((time = this.getTime(columnIndex)) == null) {
            return null;
        }
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp tsp;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getTimestamp  " + columnIndex + "   " + cal, this.rsLogCount, false);
        }
        if ((tsp = this.getTimestamp(columnIndex)) == null) {
            return null;
        }
        cal.setTimeInMillis(tsp.getTime());
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getURL  " + columnIndex, this.rsLogCount, false);
        }
        this.wasNullFlag = false;
        URL column_url = null;
        this.checkClosed();
        this.checkCellNull(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        try {
            String url = this.getString(columnIndex);
            if (url == null) {
                return null;
            }
            column_url = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return column_url;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateRef  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.updateRef", "int,Ref");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    @Override
    public void updateBlob(int columnIndex, java.sql.Blob x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBlob  " + columnIndex + "  (Blob) " + x, this.rsLogCount, true);
        }
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        InputStream in = x.getBinaryStream();
        this.updateBlob(columnIndex, in);
    }

    @Override
    public void updateBlob(String columnName, java.sql.Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, java.sql.Clob x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateClob  " + columnIndex + "  (Clob) " + x, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] data = null;
        Vector<Object> cellVector = new Vector<Object>();
        if (this.fields[columnIndex - 1].getRedhorseType() == 33 || this.fields[columnIndex - 1].getRedhorseType() == 34 || this.fields[columnIndex - 1].getRedhorseType() == 32 || this.fields[columnIndex - 1].getRedhorseType() == 30) {
            String in = x.getSubString(1L, (int)x.length());
            data = in.getBytes();
            this.initUpString(columnIndex, "?", data);
            cellVector.add(data);
            cellVector.add(TypesUtil.getRedhorseType("CHAR"));
            this.param.add(cellVector);
            ++this.hugeParamCount;
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateClob(String columnName, java.sql.Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateArray  " + columnIndex + "   " + x, this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.updateArray", "int,Array");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "getHoldability  ", this.rsLogCount, true);
        }
        this.checkClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public java.sql.NClob getNClob(int columnIndex) throws SQLException {
        String NClobStr = this.getString(columnIndex);
        if (NClobStr == null) {
            return null;
        }
        return new NClob(NClobStr);
    }

    @Override
    public java.sql.NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public java.sql.RowId getRowId(int columnIndex) throws SQLException {
        String rowid_string;
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateClob  " + columnIndex, this.rsLogCount, true);
        }
        if ((rowid_string = this.getString(columnIndex)) == null) {
            return null;
        }
        return new RowId(rowid_string);
    }

    @Override
    public java.sql.RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String xmlStr = this.getString(columnIndex);
        if (xmlStr == null) {
            return null;
        }
        return new SQLXml(xmlStr, this.connection);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateAsciiStream  " + columnIndex + "   " + x + "  (long) " + length, this.rsLogCount, true);
        }
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBinaryStream  " + columnIndex + "   " + x + "  (long) " + length, this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.updateBinaryStream", "int,InputStream,long");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBlob  " + columnIndex + " (InputStream) " + inputStream + "   " + length, this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.updateBlob", "int,InputStream,long");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateBlob  " + columnIndex + " (InputStream) " + inputStream, this.rsLogCount, true);
        }
        byte[] data = null;
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (inputStream == null) {
            this.updateNull(columnIndex);
            return;
        }
        Vector<Object> cellVector = new Vector<Object>();
        Vector dataVector = new Vector();
        try {
            dataVector = this.getInRealLength(inputStream, -1);
            data = (byte[])dataVector.get(0);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.fields[columnIndex - 1].getRedhorseType() == 33 || this.fields[columnIndex - 1].getRedhorseType() == 34 || this.fields[columnIndex - 1].getRedhorseType() == 32) {
            this.currentRow[columnIndex - 1] = data;
            this.initUpString(columnIndex, "?", data);
            cellVector.add(data);
            cellVector.add(TypesUtil.getRedhorseType("BLOB"));
            this.param.add(cellVector);
            ++this.hugeParamCount;
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateCharacterStream  " + columnIndex + "  " + x + "  (long) " + length, this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.updateCharacterStream", "int,Reader,long");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateCharacterStream  " + columnIndex + " (Reaser) " + x, this.rsLogCount, true);
        }
        this.updateCharacterStream(columnIndex, x, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateClob  " + columnIndex + " (Reasder) " + reader + "   " + length, this.rsLogCount, true);
        }
        throw SQLCommon.unSupportException("ResultSet.updateClob", "int,Reader,long");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateClob  " + columnIndex + " (Reader) " + reader, this.rsLogCount, true);
        }
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.cancelUpdate();
        if (reader == null) {
            this.updateNull(columnIndex);
            return;
        }
        StringBuffer b = new StringBuffer();
        try {
            boolean times = false;
            char[] chars = new char[1024];
            int length = 0;
            while ((length = reader.read(chars)) != -1) {
                b.append(chars, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] data = null;
        Vector<Object> cellVector = new Vector<Object>();
        if (this.fields[columnIndex - 1].getRedhorseType() == 33 || this.fields[columnIndex - 1].getRedhorseType() == 34 || this.fields[columnIndex - 1].getRedhorseType() == 32 || this.fields[columnIndex - 1].getRedhorseType() == 30) {
            data = b.toString().getBytes();
            this.initUpString(columnIndex, "?", data);
            cellVector.add(data);
            cellVector.add(TypesUtil.getRedhorseType("CHAR"));
            this.param.add(cellVector);
            ++this.hugeParamCount;
        } else {
            throw this.updateTypeConverExcpt;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNCharacterStream  " + columnIndex + " (Reader) " + x + "  " + length, this.rsLogCount, true);
        }
        this.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNCharacterStream  " + columnIndex + " (Reader) " + x, this.rsLogCount, true);
        }
        this.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, java.sql.NClob nClob) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNClob  " + columnIndex + "  " + nClob, this.rsLogCount, true);
        }
        Reader reader = nClob.getCharacterStream();
        this.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNClob  " + columnIndex + " (Reader) " + reader + "   " + length, this.rsLogCount, true);
        }
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNClob  " + columnIndex + " (Reader) " + reader, this.rsLogCount, true);
        }
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, java.sql.NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateNString  " + columnIndex + "  " + nString, this.rsLogCount, true);
        }
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateRowId(int columnIndex, java.sql.RowId x) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateRowId  " + columnIndex + "  " + x, this.rsLogCount, true);
        }
        throw Error.createSQLException("[E51032]ResultSet\uff1a\u6570\u636e\u5e93\u670d\u52a1\u5668\u6682\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c", ReplaceEnum.excStr.getReplaceStr() + 51032, 51032);
    }

    @Override
    public void updateRowId(String columnLabel, java.sql.RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (Command.debug) {
            Command.logRSmethods(this.connection.io, "updateSQLXML  " + columnIndex + "  " + xmlObject, this.rsLogCount, true);
        }
        this.updateString(columnIndex, xmlObject.getString());
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    static boolean isRn(int y) {
        boolean f = y % 400 == 0 || y % 4 == 0 && y % 100 != 0;
        return f;
    }

    private byte[] convert_byte_double(double data, int len) {
        byte[] byteRet = new byte[len];
        if (len == 8) {
            long value = Double.doubleToLongBits(data);
            for (int i = 0; i < 8; ++i) {
                byteRet[i] = (byte)(value >> (7 - i) * 8 & 0xFFL);
            }
        } else {
            int fbit = Float.floatToIntBits((float)data);
            for (int i = 0; i < 4; ++i) {
                byteRet[i] = (byte)(fbit >> 24 - i * 8);
            }
        }
        return byteRet;
    }

    private byte[] convert_byte_bigdecimal(double data) {
        byte[] temp = null;
        String dd = Double.toString(data);
        temp = dd.getBytes();
        this.isUpdate = true;
        return temp;
    }

    private void time_convert_byte(byte[] b, long data) {
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)(data >>> 8 * (len - 1) - i * 8 & 0xFFL);
        }
    }

    private byte[] convert_byte(int byteLen, long data) {
        int len = byteLen;
        byte[] localBytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            localBytes[i] = (byte)(data >>> 8 * (len - 1) - i * 8 & 0xFFL);
        }
        return localBytes;
    }

    private long conver_byte_long(byte[] b, int beg_len) {
        byte[] realData = new byte[beg_len];
        int realInt = 0;
        int len = b.length;
        int c = beg_len - len;
        if (c > 0) {
            for (int i = beg_len - 1; i < 0; --i) {
                if (c > 0) {
                    realData[i] = 0;
                    --c;
                    continue;
                }
                realData[i] = b[i];
            }
        } else {
            for (int i = 0; i < beg_len; ++i) {
                realData[i] = b[i];
            }
        }
        switch (beg_len) {
            case 1: {
                realInt = realData[0] & 0xFF;
                break;
            }
            case 2: {
                realInt = (realData[0] & 0xFF) << 8 | realData[1] & 0xFF;
                break;
            }
            case 4: {
                realInt = (realData[0] & 0xFF) << 24 | (realData[1] & 0xFF) << 16 | (realData[2] & 0xFF) << 8 | realData[3] & 0xFF;
                break;
            }
            case 8: {
                realInt = (realData[0] & 0xFF) << 56 | (realData[1] & 0xFF) << 48 | (realData[2] & 0xFF) << 40 | (realData[3] & 0xFF) << 32 | (realData[4] & 0xFF) << 24 | (realData[5] & 0xFF) << 16 | (realData[6] & 0xFF) << 8 | realData[7] & 0xFF;
                break;
            }
        }
        return realInt;
    }

    private void checkConcurrency() throws SQLException {
        if (this.rsConcurrency != 1008) {
            throw Error.createSQLException("[E50088]ResultSet\u4e3a\u4e0d\u53ef\u66f4\u65b0\u7ed3\u679c\u96c6\uff0c\u65e0\u6cd5\u66f4\u65b0\u8bb0\u5f55\u6570\u636e", ReplaceEnum.excStr.getReplaceStr() + 50088, 50088);
        }
    }

    private void checkRowid() throws SQLException {
        if (!this.isReturnRowid) {
            throw Error.createSQLException("[E50089]ResultSet:\u66f4\u65b0\u7ed3\u679c\u96c6\u9700\u8fd4\u56deROWID", ReplaceEnum.excStr.getReplaceStr() + 50089, 50089);
        }
    }

    private void checkObj_length(long len) throws SQLException {
        if (len >= Integer.MAX_VALUE) {
            throw Error.createSQLException("[E50092]ResultSet:\u6570\u636e\u8fc7\u957f,\u65e0\u6cd5\u66f4\u65b0", ReplaceEnum.excStr.getReplaceStr() + 50092, 50092);
        }
        if (len < 0L && len != -1L) {
            throw Error.createSQLException("[E51005]ResultSet:\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u96f6", ReplaceEnum.excStr.getReplaceStr() + 51005, 51005);
        }
    }

    private void initUpString(int cIndex, String cValue, byte[] bValue) {
        String columnName = this.fields[cIndex - 1].getColumnName();
        if (this.isOnInsertRow) {
            this.insertRows = this.insertRows + "\"" + columnName + "\",";
            this.insertValues = this.insertValues + cValue + ",";
        } else {
            if (this.updateRowsBytes == null) {
                this.updateRowsBytes = new byte[this.currentRow.length][];
                System.arraycopy(this.currentRow, 0, this.updateRowsBytes, 0, this.currentRow.length);
            }
            this.updateRowsValues.append("\"" + columnName + "\"=" + cValue + ",");
            this.updateRowsBytes[cIndex - 1] = bValue;
        }
    }

    private void cancelUpdate() {
        if (this.isUpdateRow) {
            this.isUpdateRow = false;
        }
    }

    private boolean isForward() {
        return this.rsType == 1003 && this.rsDirection == 1000;
    }

    Vector getRs_rowdata() {
        return this.getRowData().getRows();
    }

    void addVector(Vector v) {
        this.getRowData().addVector(v);
    }

    private boolean getIsAD() {
        return this.isAD;
    }

    private void dt2tm(long t) {
        if (!this.isCalendar) {
            t *= 1000L;
        }
        int us = (int)((t += 3533431852800000000L) % 1000000L);
        int s = (int)((t /= 1000000L) % 86400L);
        int d = (int)(t / 86400L);
        int d1 = d - 10;
        int y = d1 / 146097 * 400;
        y += (d1 %= 146097) / 36524 * 100;
        y += (d1 %= 36524) / 1461 * 4;
        d1 %= 1461;
        if ((d -= (d1 = (y += d1 / 365) * 365 + (y - 1) / 4 - (y - 1) / 100 + (y - 1) / 400)) >= 365) {
            if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
                if (d > 365) {
                    ++y;
                    d -= 366;
                }
            } else {
                ++y;
                d -= 365;
            }
        }
        this.year = y - 110000;
        if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            this.month = Connection.day2md_rn[d][0];
            this.day = Connection.day2md_rn[d][1];
        } else {
            this.month = Connection.day2md[d][0];
            this.day = Connection.day2md[d][1];
        }
        this.second = s;
        this.ms = us;
    }

    public String getCur_num() {
        return this.cur_num;
    }

    void setCur_num(String cur_num) {
        this.cur_num = cur_num;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    void setCursor(boolean isCursor) {
        this.isCursor = isCursor;
    }

    RowData getRowData() {
        return this.resRowData;
    }

    public boolean hasMoreRows() {
        return this.getRowData().hasNext();
    }

    private int getParamLength(int paramIndex) {
        return ((byte[])this.param.get(paramIndex).get(0)).length;
    }

    private int getParamType(int paramIndex) {
        return (Integer)this.param.get(paramIndex).get(1);
    }

    private byte[] getParamData(int paramIndex) {
        return (byte[])this.param.get(paramIndex).get(0);
    }

    private int getMoveIndex() {
        return this.moveIndex;
    }

    private void setMoveIndex(int moveIndex) {
        this.moveIndex = moveIndex;
    }

    private void checkReverseable() throws SQLException {
        if (this.isCursor() || this.rsType != 1004 && this.rsType != 1005 || this.rsDirection == 1000) {
            throw Error.createSQLException("[E51043]ResultSet:\u975e\u56de\u6eda\u7ed3\u679c\u96c6\u4e0d\u53ef\u4ee5\u9006\u5411\u79fb\u52a8", ReplaceEnum.excStr.getReplaceStr() + 51043, 51043);
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isCursor()) {
            throw Error.createSQLException("[E51044]ResultSet:\u6e38\u6807\u7ed3\u679c\u96c6\u4e0d\u53ef\u505a\u6b64\u64cd\u4f5c", ReplaceEnum.excStr.getReplaceStr() + 51044, 51044);
        }
    }

    boolean isRowDataNull() {
        return this.getRowData().size() == 0;
    }

    Field[] getFileds() {
        return this.fields;
    }

    void addRowCount() {
        ++this.rowCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int rowdataSize() {
        return this.getRowData().size();
    }

    public int rowdataCapacity() {
        return this.getRowData().capacity();
    }

    private Field getField(int colIndex) {
        return this.fields[colIndex];
    }

    private void checkRowPosition() throws SQLException {
        if ((this.getRowData().isEmpty() || this.currentRow == null) && this.statement.recv_mode == 0) {
            throw Error.createSQLException("[E51045]ResultSet:\u7ed3\u679c\u96c6\u5df2\u8017\u5c3d", ReplaceEnum.excStr.getReplaceStr() + 51045, 51045);
        }
        if (!this.isMoveTOData && this.statement.recv_mode == 0) {
            throw Error.createSQLException("[E51046]ResultSet:\u975e\u6cd5\u7684\u7ed3\u679c\u96c6\u4e0b\u6807", ReplaceEnum.excStr.getReplaceStr() + 51046, 51046);
        }
    }

    private Vector getInRealLength(InputStream in, int len) throws IOException {
        int in_len;
        Vector totalV = new Vector();
        Vector<Object> returnV = new Vector<Object>();
        int cell_len = 0;
        byte[] readBytes = null;
        if (len == -1) {
            readBytes = new byte[1000];
            while ((cell_len = in.read(readBytes)) != -1) {
                byte[] cloneBytes = new byte[1000];
                System.arraycopy(readBytes, 0, cloneBytes, 0, cell_len);
                Vector<Object> cellV = new Vector<Object>();
                cellV.add(cloneBytes);
                cellV.add(cell_len);
                totalV.add(cellV);
                in_len += cell_len;
            }
            if (in_len <= 0) {
                returnV.add(new byte[1]);
                returnV.add(0);
            } else {
                byte[] in_bytes = new byte[in_len];
                int beginIndex = 0;
                for (int i = 0; i < totalV.size(); ++i) {
                    System.arraycopy(((Vector)totalV.get(i)).get(0), 0, in_bytes, beginIndex, (Integer)((Vector)totalV.get(i)).get(1));
                    beginIndex += ((Integer)((Vector)totalV.get(i)).get(1)).intValue();
                }
                returnV.add(in_bytes);
                returnV.add(in_len);
            }
        } else {
            readBytes = new byte[len];
            for (in_len = 0; in_len < len && (cell_len = in.read(readBytes, in_len, len - in_len)) != -1; in_len += cell_len) {
            }
            if (in_len < len) {
                byte[] lessBytes = new byte[in_len];
                System.arraycopy(readBytes, 0, lessBytes, 0, in_len);
                returnV.add(lessBytes);
                returnV.add(in_len);
            } else {
                returnV.add(readBytes);
                returnV.add(in_len);
            }
        }
        return returnV;
    }

    private Vector getReaderRealData(Reader rd, int len) throws IOException {
        int in_len;
        Vector totalV = new Vector();
        Vector<Object> returnV = new Vector<Object>();
        int cell_len = 0;
        char[] readchars = null;
        if (len == -1) {
            readchars = new char[1000];
            StringBuffer dataBuffer = new StringBuffer();
            while ((cell_len = rd.read(readchars)) != -1) {
                dataBuffer.append(new String(readchars, 0, cell_len));
                in_len += cell_len;
            }
            if (in_len <= 0) {
                returnV.add(new String(new char[1]));
                returnV.add(0);
            } else {
                returnV.add(dataBuffer.toString());
                returnV.add(in_len);
            }
        } else {
            readchars = new char[len];
            for (in_len = 0; in_len < len && (cell_len = rd.read(readchars, in_len, len - in_len)) != -1; in_len += cell_len) {
            }
            returnV.add(new String(readchars, 0, in_len));
            returnV.add(in_len);
        }
        return returnV;
    }

    private void resumeUpdateString() {
        this.insertRows = "";
        this.insertValues = "";
        this.insertString = "";
        this.updateRowsValues = new StringBuffer();
        this.updateRowsBytes = null;
        this.param = new Vector();
        this.hugeParamCount = 0;
        this.newRow = null;
    }

    private String logString(String str) {
        String returnStr = null;
        if (this.rsLogCount < 1) {
            returnStr = this.rs_sql + "|" + str;
        }
        ++this.rsLogCount;
        return returnStr;
    }

    synchronized boolean isRsIsOver() {
        return this.rsIsOver;
    }

    synchronized void setRsIsOver(boolean rsIsOver) {
        this.rsIsOver = rsIsOver;
    }

    protected synchronized boolean isCursorHasMoreRows() {
        return this.cursorHasMoreRows;
    }

    protected synchronized void setCursorHasMoreRows(boolean rsHasMoreRows) {
        this.cursorHasMoreRows = rsHasMoreRows;
    }

    boolean isManificateRs() {
        return this.isManificateRs;
    }

    void setManificateRs(boolean isManificateRs) {
        this.isManificateRs = isManificateRs;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw Error.createSQLException("[E50051]ResultSet:\u76ee\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", ReplaceEnum.excStr.getReplaceStr() + 50051, 50051);
        }
        this.checkCellNull(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(BigInteger.class)) {
            return (T)new BigInteger(this.getString(columnIndex));
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(this.getByte(columnIndex));
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (T)Short.toString(this.getShort(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(LocalDateTime.class)) {
            return (T)this.getLocalDatetime(columnIndex);
        }
        if (type.equals(LocalDate.class)) {
            return (T)this.getLocalDate(columnIndex);
        }
        if (type.equals(LocalTime.class)) {
            return (T)this.getLocalTime(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(InputStream.class)) {
            return (T)this.getBinaryStream(columnIndex);
        }
        if (type.equals(Blob.class) || type.equals(Blob.class)) {
            return (T)this.getBlob(columnIndex);
        }
        if (type.equals(Clob.class) || type.equals(Clob.class)) {
            return (T)this.getClob(columnIndex);
        }
        if (type.equals(Reader.class)) {
            return (T)this.getCharacterStream(columnIndex);
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(java.sql.RowId.class)) {
            return (T)this.getRowId(columnIndex);
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(java.util.Date.class)) {
            Timestamp ts = this.getTimestamp(columnIndex);
            return (T)java.util.Date.from(ts.toInstant());
        }
        if (type.equals(java.sql.NClob.class)) {
            return (T)this.getNClob(columnIndex);
        }
        throw Error.createSQLException("[E50044]Resultset: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> arg1) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> arg1) throws SQLException {
        return this.getObject(columnName);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    private String handleMS(String ms_str) {
        String ms = ms_str;
        if (ms != null && ms.equals("")) {
            ms = "000000";
        }
        return ms;
    }

    private String handleMS(long ms) {
        if (ms == 0L) {
            return "0";
        }
        return String.format("%06d", ms).replaceAll("(0)+$", "");
    }

    private String getUnicodeString(String str) {
        char[] utfBytes = str.toCharArray();
        StringBuilder unicodeBytes = new StringBuilder();
        for (int i = 0; i < utfBytes.length; ++i) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes.append("\\u").append(hexB);
        }
        return unicodeBytes.toString();
    }

    private byte[] polishBytesByLen(int initLen, byte[] copyBytes) {
        byte[] initBytes = new byte[initLen];
        int index = 0;
        int bytesLen = copyBytes.length;
        for (index = initLen - 1; index >= 0; --index) {
            if (bytesLen - 1 >= 0) {
                initBytes[index] = copyBytes[bytesLen - 1];
                --bytesLen;
                continue;
            }
            initBytes[index] = 0;
        }
        return initBytes;
    }

    private int getMSMultiplier(int num) {
        StringBuffer sb = new StringBuffer();
        sb.append("1");
        int usinedNum = Math.abs(num);
        for (int i = 0; i < usinedNum; ++i) {
            sb.append("0");
        }
        int multiplierZero = Integer.parseInt(sb.toString());
        multiplierZero = num > 0 ? (multiplierZero *= 1000000) : 1000000 / multiplierZero;
        return multiplierZero;
    }
}

