/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Blob;
import com.xugu.cloudjdbc.Clob;
import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.LogWriter;
import com.xugu.cloudjdbc.ParamList;
import com.xugu.cloudjdbc.Parameter;
import com.xugu.cloudjdbc.ParameterMetaData;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.ResultSetMetaData;
import com.xugu.cloudjdbc.Statement;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Pattern;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private boolean isJoinSQL = false;
    int call_num = 0;
    protected short paramTypes = 1;
    private ArrayList<byte[]> batchParamLists = new ArrayList(500);
    static int byteSize = 4096;
    private boolean notExecuteForDbever = false;
    protected boolean shouldPrepared = false;

    public PreparedStatement(Connection connection, String database, String originalSql, boolean isCallable) throws SQLException {
        super(connection, database, true);
        this.checkSQLNull(originalSql);
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "  @@@@@@  SQL:   " + originalSql);
        }
        this.isCallable = isCallable;
        if (this.connection.getBnechmarkMode() && originalSql.toUpperCase().indexOf("SELECT COUNT(*) AS LOW_STOCK FROM") != -1) {
            originalSql = "select pp(?,?,?,?) as low_stock";
        }
        this.colMap = new HashMap();
        String sql = this.parseSQL(originalSql);
        if (!this.shouldPrepared) {
            MessageFormat messFormat = SQLCommon.getMessageFormat("CallableStatement.callSQL");
            String[] callObj = new String[]{sql};
            this.originalSql = messFormat.format(callObj);
            super.prepare(this.originalSql);
        } else {
            this.originalSql = sql;
            super.prepare(sql);
        }
    }

    public PreparedStatement(Connection connection, String database) throws SQLException {
        super(connection, database, true);
    }

    private void checkPosition(int parameterIndex) throws SQLException {
        if (parameterIndex < 1) {
            throw Error.createSQLException("[E50032]the parameter's index can't be less than 1", ReplaceEnum.excStr.getReplaceStr() + 50032, 50032);
        }
        if (parameterIndex > this.paramCount && this.isPrepared) {
            throw Error.createSQLException("[E50033]the parameter's index is greater than the total of parameters", ReplaceEnum.excStr.getReplaceStr() + 50033, 50033);
        }
    }

    private void joinSQL() {
        byte[] typeAsByte = new byte[2];
        byte[] lengthAsByte = new byte[4];
        int mask = 255;
        boolean haveRet = false;
        if (this.paramList.isReturnVale(0)) {
            haveRet = true;
        }
        int totalLength = 4;
        for (int i = 0; i < this.paramCount; ++i) {
            if (this.paramList.isReturnVale(i)) continue;
            totalLength = this.paramList.getParamName(i) != null ? (int)((long)totalLength + (this.paramList.getParamLength(i) + 10L + (long)this.paramList.getParamName(i).getBytes().length)) : (int)((long)totalLength + (this.paramList.getParamLength(i) + 10L));
        }
        this.paramBytes = new byte[totalLength];
        int paraN = haveRet ? this.paramCount - 1 : this.paramCount;
        this.paramBytes[0] = (byte)(paraN >>> 24 & 0xFF);
        this.paramBytes[1] = (byte)(paraN >>> 16 & 0xFF);
        this.paramBytes[2] = (byte)(paraN >>> 8 & 0xFF);
        this.paramBytes[3] = (byte)(paraN & 0xFF);
        int currentPosition = 4;
        for (int i = 0; i < this.paramCount; ++i) {
            int j;
            if (this.paramList.isReturnVale(i)) continue;
            short inoutType = (short)this.paramList.getParaminoutType(i);
            short type = (short)this.paramList.getParamNativeType(i);
            long length = this.paramList.getParamLength(i);
            Object param = this.paramList.getParamData(i);
            String paramName = this.paramList.getParamName(i);
            if (paramName == null) {
                for (j = 0; j < 2; ++j) {
                    typeAsByte[j] = 0;
                }
                System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
                currentPosition += 2;
            } else {
                short paramNameLen = (short)paramName.length();
                for (int j2 = 0; j2 < 2; ++j2) {
                    typeAsByte[j2] = (byte)(paramNameLen >>> 8 - 8 * j2 & mask);
                }
                System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
                System.arraycopy(paramName.getBytes(), 0, this.paramBytes, currentPosition += 2, paramName.getBytes().length);
                currentPosition += paramName.getBytes().length;
            }
            for (j = 0; j < 2; ++j) {
                typeAsByte[j] = (byte)(inoutType >>> 8 - 8 * j & mask);
            }
            System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
            currentPosition += 2;
            for (j = 0; j < 2; ++j) {
                typeAsByte[j] = (byte)(type >>> 8 - 8 * j & mask);
            }
            System.arraycopy(typeAsByte, 0, this.paramBytes, currentPosition, 2);
            currentPosition += 2;
            for (j = 0; j < 4; ++j) {
                lengthAsByte[j] = (byte)(length >>> 24 - 8 * j & (long)mask);
            }
            int len1 = lengthAsByte.length;
            System.arraycopy(lengthAsByte, 0, this.paramBytes, currentPosition, len1);
            currentPosition += len1;
            if (param == null || length == 0L) continue;
            int len2 = ((byte[])param).length;
            System.arraycopy((byte[])param, 0, this.paramBytes, currentPosition, len2);
            currentPosition += len2;
        }
        this.isJoinSQL = true;
    }

    private byte[] joinBatchSQL(int paramIndex) {
        int i;
        byte[] typeAsByte = new byte[2];
        byte[] lengthAsByte = new byte[4];
        int mask = 255;
        int totalLength = 0;
        int currentPosition = 0;
        ParamList eachParamList = this.paramList;
        if (paramIndex == 0) {
            totalLength = 4;
            currentPosition = 4;
            for (i = 0; i < this.paramCount; ++i) {
                totalLength = eachParamList.getParamName(i) != null ? (int)((long)totalLength + (eachParamList.getParamLength(i) + 10L + (long)eachParamList.getParamName(i).getBytes().length)) : (int)((long)totalLength + (eachParamList.getParamLength(i) + 10L));
            }
        } else if (this.connection.is301Protocol()) {
            for (i = 0; i < this.paramCount; ++i) {
                totalLength = (int)((long)totalLength + (eachParamList.getParamLength(i) + 5L));
            }
        } else {
            for (i = 0; i < this.paramCount; ++i) {
                totalLength = (int)((long)totalLength + (eachParamList.getParamLength(i) + 4L));
            }
        }
        byte[] eachParamBytes = new byte[totalLength];
        for (int i2 = 0; i2 < this.paramCount; ++i2) {
            int len2;
            int len1;
            int j;
            short type;
            long length = eachParamList.getParamLength(i2);
            Object param = eachParamList.getParamData(i2);
            if (paramIndex == 0) {
                short inoutType = (short)eachParamList.getParaminoutType(i2);
                type = (short)eachParamList.getParamNativeType(i2);
                String paramName = eachParamList.getParamName(i2);
                if (paramName == null) {
                    for (j = 0; j < 2; ++j) {
                        typeAsByte[j] = 0;
                    }
                    System.arraycopy(typeAsByte, 0, eachParamBytes, currentPosition, 2);
                    currentPosition += 2;
                } else {
                    short paramNameLen = (short)paramName.length();
                    for (int j2 = 0; j2 < 2; ++j2) {
                        typeAsByte[j2] = (byte)(paramNameLen >>> 8 - 8 * j2 & mask);
                    }
                    System.arraycopy(typeAsByte, 0, eachParamBytes, currentPosition, 2);
                    System.arraycopy(paramName.getBytes(), 0, eachParamBytes, currentPosition += 2, paramName.getBytes().length);
                    currentPosition += paramName.getBytes().length;
                }
                for (j = 0; j < 2; ++j) {
                    typeAsByte[j] = (byte)(inoutType >>> 8 - 8 * j & mask);
                }
                System.arraycopy(typeAsByte, 0, eachParamBytes, currentPosition, 2);
                currentPosition += 2;
                for (j = 0; j < 2; ++j) {
                    typeAsByte[j] = (byte)(type >>> 8 - 8 * j & mask);
                }
                System.arraycopy(typeAsByte, 0, eachParamBytes, currentPosition, 2);
                currentPosition += 2;
            }
            if (this.connection.is301Protocol() && paramIndex != 0) {
                length = eachParamList.getParamLength(i2);
                param = eachParamList.getParamData(i2);
                type = (short)eachParamList.getParamNativeType(i2);
                for (j = 0; j < 2; ++j) {
                    typeAsByte[j] = (byte)(type >>> 8 - 8 * j & mask);
                }
                System.arraycopy(typeAsByte, 1, eachParamBytes, currentPosition, 1);
                ++currentPosition;
                for (j = 0; j < 4; ++j) {
                    lengthAsByte[j] = (byte)(length >>> 24 - 8 * j & (long)mask);
                }
                len1 = lengthAsByte.length;
                System.arraycopy(lengthAsByte, 0, eachParamBytes, currentPosition, len1);
                currentPosition += len1;
                if (param == null || length == 0L) continue;
                len2 = ((byte[])param).length;
                System.arraycopy((byte[])param, 0, eachParamBytes, currentPosition, len2);
                currentPosition += len2;
                continue;
            }
            for (j = 0; j < 4; ++j) {
                lengthAsByte[j] = (byte)(length >>> 24 - 8 * j & (long)mask);
            }
            len1 = lengthAsByte.length;
            System.arraycopy(lengthAsByte, 0, eachParamBytes, currentPosition, len1);
            currentPosition += len1;
            if (param == null || length == 0L) continue;
            len2 = ((byte[])param).length;
            System.arraycopy((byte[])param, 0, eachParamBytes, currentPosition, len2);
            currentPosition += len2;
        }
        this.isJoinSQL = true;
        return eachParamBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        String sqlexe = "";
        MessageFormat messFormat = null;
        String err_str = null;
        String cur_name = null;
        long beginTime = 0L;
        String linitStr = null;
        if (this.connection.getBnechmarkMode() && this.connection.getBnechmarkModeWid() && !this.connection.redirect) {
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            for (int j = 0; j < stacks.length; ++j) {
                if (stacks[j].getClassName().indexOf("jTPCCTData") == -1 && stacks[j].getClassName().indexOf("jTPCCTerminal") == -1) continue;
                try {
                    if (stacks[j].getMethodName().indexOf("executeNewOrder") == -1 && stacks[j].getMethodName().indexOf("newOrderTransaction") == -1) continue;
                    int w_id = (int)this.bytesToInt((byte[])this.paramList.getParamData(0), this.paramList.getParamType(0));
                    this.connection.io.buildNewConnection2(w_id);
                    Set keySet = this.connection.openStatements.keySet();
                    for (Statement key : keySet) {
                        if (!(key instanceof PreparedStatement)) continue;
                        ParamList l = null;
                        if (this == key) {
                            l = this.paramList;
                        }
                        ((PreparedStatement)key).prepare(((PreparedStatement)key).originalSql);
                        if (this != key) continue;
                        this.paramList = l;
                    }
                    this.connection.redirect = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.paramList != null) {
            if (!this.paramList.isAllSet()) {
                throw Error.createSQLException("[E50034]PreparedStatement: at least one parameter is not set by setXXX() method", ReplaceEnum.excStr.getReplaceStr() + 50034, 50034);
            }
            if (this.noSendPreSqlLimit != null) {
                StringBuffer noSendSqlBuffer = new StringBuffer();
                noSendSqlBuffer.append(this.noSendPreSqlwhere);
                linitStr = this.noSendPreSqlLimit.replaceAll("[?]", "%d");
                linitStr = this.limitParamCount == 1 ? String.format(linitStr, this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount), this.paramList.getParamType(this.whereParamCount))) : String.format(linitStr, this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount), this.paramList.getParamType(this.whereParamCount)), this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount + 1), this.paramList.getParamType(this.whereParamCount + 1)));
                this.originalSql = noSendSqlBuffer.append(" " + linitStr).toString();
                noSendSqlBuffer = null;
            }
            if (!this.isJoinSQL) {
                this.joinSQL();
            }
        }
        this.sql = this.originalSql;
        boolean ok = false;
        Connection conn = this.connection;
        if (this.isQuery && this.getRecv_mod() == 2) {
            this.curId = this.connection.io.getCurIdGen();
            if (this.connection.is301Protocol()) {
                messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Statement.301DeclareCursor"));
                sqlexe = messFormat.format(new String[]{this.conObjName + this.curId, this.conObjName + this.stId, String.valueOf(this.getCursorFirstCount())});
            } else {
                messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Statement.declareCursor"));
                sqlexe = messFormat.format(new String[]{this.conObjName + this.curId, this.conObjName + this.stId});
            }
            cur_name = "cur" + this.conObjName + this.curId;
        } else {
            messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("PreparedStatement.callSQL"));
            sqlexe = this.isPrepared ? messFormat.format(new String[]{this.conObjName + this.stId}) : this.originalSql;
        }
        this.checkSqlLen(sqlexe);
        while (!ok) {
            Object object = this.getMutex();
            synchronized (object) {
                if (!conn.io.isBLocked()) {
                    conn.io.setBLocked(true);
                    ok = true;
                    this.resumeSendType();
                    if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("callPre") != -1)) {
                        this.connection.io.lw.write(this.connection.io.sessionId, "prepareStm executeQuery : " + this.sql + " ;  " + sqlexe, LogWriter.CmdState.callPre);
                    }
                    if (this.call_num == 0) {
                        this.sql = this.sql + " ;  " + sqlexe;
                        ++this.call_num;
                    }
                    if (this.isQuery && this.getRecv_mod() == 2 && !this.connection.is301Protocol()) {
                        if (this.paramBytes != null) {
                            conn.io.sendCommand(sqlexe, this.paramBytes);
                        } else {
                            conn.io.sendCommand0(sqlexe);
                        }
                        ResultSet rs_cur = this.firstResultSet();
                        messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("Statement.openCursor"));
                        String openSql = messFormat.format(new String[]{cur_name});
                        this.checkSqlLen(openSql);
                        while (true) {
                            if (!conn.io.isBLocked()) {
                                conn.io.setBLocked(true);
                                rs_cur.setCur_num(cur_name);
                                rs_cur.setCursor(true);
                                if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("callPre") != -1)) {
                                    this.connection.io.lw.write(this.connection.io.sessionId, "prepareStm executeQuery : " + openSql, LogWriter.CmdState.callPre);
                                }
                                conn.io.sendCommand0(openSql);
                                this.paramBytes = null;
                                this.isJoinSQL = false;
                                while (conn.io.readByte() != 75) {
                                    err_str = conn.io.readStr();
                                }
                                conn.io.setBLocked(false);
                                if (Command.debug) {
                                    Command.logBlockedState(this.connection.io, "K   open cursor  " + cur_name, this.connection.io.isBLocked());
                                }
                                this.setStmIsOver(true);
                                this.allOpenRsultSet.addResult(rs_cur, true);
                                if (err_str != null) {
                                    throw Error.createSQLException(err_str);
                                }
                                return rs_cur;
                            }
                            if (Command.debug) {
                                Command.logBlockedState(this.connection.io, "open cursor  " + cur_name, this.connection.io.isBLocked());
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.paramBytes != null) {
                        conn.io.sendCommand(sqlexe, this.paramBytes);
                    } else {
                        conn.io.sendCommand0(sqlexe);
                    }
                    this.paramBytes = null;
                    this.isJoinSQL = false;
                    this.resumeRowid();
                    ResultSet frs = this.firstResultSet();
                    if (this.getRecv_mod() == 2) {
                        frs.setCur_num(cur_name);
                        frs.setCursor(true);
                        if (frs.getRowCount() < this.getCursorFirstCount()) {
                            frs.setCursorHasMoreRows(false);
                        }
                    }
                    this.allOpenRsultSet.addResult(frs, true);
                    return frs;
                }
                if (Command.debug) {
                    Command.logBlockedState(this.connection.io, this.sql, this.connection.io.isBLocked());
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.sql = this.originalSql;
        this.paramNameIndex = 0;
        String linitStr = null;
        if (this.paramList != null && !this.paramList.isAllSet()) {
            throw Error.createSQLException("[E50034]PreparedStatement: at least one parameter is not set by setXXX() method", ReplaceEnum.excStr.getReplaceStr() + 50034, 50034);
        }
        if (this.paramList != null) {
            if (this.noSendPreSqlLimit != null) {
                StringBuffer noSendSqlBuffer = new StringBuffer();
                noSendSqlBuffer.append(this.noSendPreSqlwhere);
                linitStr = this.noSendPreSqlLimit.replaceAll("[?]", "%d");
                linitStr = this.limitParamCount == 1 ? String.format(this.noSendPreSqlLimit, this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount), this.paramList.getParamType(this.whereParamCount))) : String.format(this.noSendPreSqlLimit, this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount), this.paramList.getParamType(this.whereParamCount)), this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount + 1), this.paramList.getParamType(this.whereParamCount + 1)));
                this.originalSql = noSendSqlBuffer.append(" " + linitStr).toString();
                noSendSqlBuffer = null;
            }
            if (!this.isJoinSQL) {
                this.joinSQL();
            }
        }
        MessageFormat messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("PreparedStatement.callSQL"));
        String exesql = this.isPrepared ? messFormat.format(new String[]{this.conObjName + String.valueOf(this.stId)}) : this.originalSql;
        this.isJoinSQL = false;
        return this.executeUpdate(exesql);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNull   " + parameterIndex + " , " + sqlType);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        int length = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        short redhorseType = this.getSetRedHorseTypeFromJavaType(sqlType);
        if (redhorseType == 0) {
            redhorseType = 30;
        }
        this.paramList.setObject(parameterIndex - 1, redhorseType, this.paramTypes, length, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBoolean   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = new byte[1];
        int length = 1;
        short paramTypes = 1;
        if (this.connection.compatibleQX) {
            if (this.paramList.getParamNativeType(parameterIndex - 1) == 2) {
                paramAsByte[0] = x ? (byte)1 : 0;
                this.paramList.setObject(parameterIndex - 1, (short)2, paramTypes, length, paramAsByte);
            } else {
                paramAsByte[0] = x ? 49 : 48;
                this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, length, paramAsByte);
            }
        } else if (this.connection.isora) {
            paramAsByte[0] = x ? 49 : 48;
            this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, length, paramAsByte);
        } else {
            paramAsByte[0] = x ? (byte)1 : 0;
            this.paramList.setObject(parameterIndex - 1, (short)2, paramTypes, length, paramAsByte);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setByte   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = null;
        int length = 0;
        Byte bx = new Byte(x);
        if (bx.toString() != null) {
            paramAsByte = new byte[]{x};
            length = 1;
        }
        short paramTypes = 1;
        this.paramList.setObject(parameterIndex - 1, (short)3, paramTypes, length, paramAsByte);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setShort   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = new byte[2];
        int length = 2;
        int mask = 255;
        for (int i = 0; i < 2; ++i) {
            paramAsByte[i] = (byte)(x >>> 8 - 8 * i & mask);
        }
        short paramTypes = 1;
        this.paramList.setObject(parameterIndex - 1, (short)4, paramTypes, length, paramAsByte);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInt   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = new byte[4];
        int length = 4;
        int mask = 255;
        for (int i = 0; i < 4; ++i) {
            paramAsByte[i] = (byte)(x >>> 24 - 8 * i & mask);
        }
        this.paramTypes = 1;
        this.paramList.setObject(parameterIndex - 1, (short)5, this.paramTypes, length, paramAsByte);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setLong   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = new byte[8];
        int length = 8;
        int mask = 255;
        for (int i = 0; i < 8; ++i) {
            paramAsByte[i] = (byte)(x >>> 56 - 8 * i & (long)mask);
        }
        short paramTypes = 1;
        this.paramList.setObject(parameterIndex - 1, (short)6, paramTypes, length, paramAsByte);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setFloat   " + parameterIndex + " , " + x);
        }
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setDouble   " + parameterIndex + " , " + x);
        }
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBigDecimal   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            String paramAsString = x.toString();
            int length = paramAsString.getBytes().length;
            byte[] paramAsByte = new byte[length];
            paramAsByte = paramAsString.getBytes();
            short paramTypes = 1;
            this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, length, paramAsByte);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setString   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = null;
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else if (x.equals("")) {
            paramAsByte = new byte[1];
            if (this.connection.isIsora() && this.connection.isEmptyStringAsNull()) {
                this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
            } else {
                this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, paramAsByte.length, paramAsByte);
            }
        } else {
            try {
                paramAsByte = x.getBytes(this.connection.getCharSet());
            }
            catch (UnsupportedEncodingException e) {
                throw SQLCommon.EncodingException(e);
            }
            short paramTypes = 1;
            if (paramAsByte == null) {
                this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, 0L, null);
            } else {
                this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, paramAsByte.length, paramAsByte);
            }
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBytes   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            int length = x.length;
            int typeId = this.paramList.getParamNativeType(parameterIndex - 1);
            short sendTypeId = 0;
            sendTypeId = typeId != 1 ? (short)Integer.valueOf(typeId).shortValue() : (short)33;
            short paramTypes = 1;
            if (length == 0) {
                this.paramList.setObject(parameterIndex - 1, sendTypeId, paramTypes, 1L, this.get0x0Bytes());
            } else {
                this.paramList.setObject(parameterIndex - 1, sendTypeId, paramTypes, length, x);
            }
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setDate   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = null;
        int length = 0;
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            try {
                paramAsByte = x.toString().getBytes(this.connection.getCharSet());
            }
            catch (UnsupportedEncodingException e) {
                throw SQLCommon.EncodingException(e);
            }
            length = paramAsByte.length;
            short paramTypes = 1;
            this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, length, paramAsByte);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setTime   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = null;
        int length = 0;
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            paramAsByte = x.toString().getBytes();
            length = paramAsByte.length;
            short paramTypes = 1;
            this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, length, paramAsByte);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setTimestamp   " + parameterIndex + " , " + x);
        }
        this.setDatetime(parameterIndex, x);
    }

    protected void setDatetime(int parameterIndex, Timestamp x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setDatetime   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] paramAsByte = null;
        int length = 0;
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            paramAsByte = x.toString().getBytes();
            length = paramAsByte.length;
            short paramTypes = 1;
            this.paramList.setObject(parameterIndex - 1, (short)30, paramTypes, length, paramAsByte);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setAsciiStream   " + parameterIndex + " , " + x + " , " + length);
        }
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setUnicodeStream   " + parameterIndex + " , " + x);
        }
        throw SQLCommon.unSupportException("PreparedStatement.setUnicodeStream", "int,InputStream,int");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        if (this.paramList != null) {
            this.paramList.paramDatClear();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setObject   " + parameterIndex + " , " + x + " , " + targetSqlType + " , " + scale);
        }
        throw SQLCommon.unSupportException("PreparedStatement.setObject", "int,Object,int,int");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setObject   " + parameterIndex + " , " + x + " , " + targetSqlType);
        }
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        String x_string = null;
        x_string = x instanceof byte[] ? this.connection.io.getStringWithCharactor((byte[])x) : x.toString();
        switch (targetSqlType) {
            case 16: {
                this.setBoolean(parameterIndex, Boolean.valueOf(x_string));
                break;
            }
            case -7: 
            case -6: {
                this.setByte(parameterIndex, Byte.parseByte(x_string));
                break;
            }
            case 5: {
                this.setShort(parameterIndex, Short.parseShort(x_string));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, Integer.parseInt(x_string));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, Long.parseLong(x_string));
                break;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, Float.parseFloat(x_string));
                break;
            }
            case 8: {
                this.setDouble(parameterIndex, Double.parseDouble(x_string));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal x_bd = new BigDecimal(x_string);
                this.setBigDecimal(parameterIndex, x_bd);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 3400: {
                this.setString(parameterIndex, x_string);
                break;
            }
            case 91: {
                Date x_date = null;
                if (x instanceof Long) {
                    Long x_long_d = (Long)x;
                    x_date = new Date(x_long_d);
                    this.setDate(parameterIndex, x_date);
                    break;
                }
                this.setString(parameterIndex, x_string);
                break;
            }
            case 92: {
                Time x_time = null;
                if (x instanceof Long) {
                    Long x_long_t = (Long)x;
                    x_time = new Time(x_long_t);
                    this.setTime(parameterIndex, x_time);
                    break;
                }
                this.setString(parameterIndex, x_string);
                break;
            }
            case 93: {
                Timestamp x_ts = null;
                if (x instanceof Long) {
                    Long x_long_ts = (Long)x;
                    x_ts = new Timestamp(x_long_ts);
                    this.setTimestamp(parameterIndex, x_ts);
                    break;
                }
                this.setString(parameterIndex, x_string);
                break;
            }
            case 3200: {
                this.setString(parameterIndex, x_string);
                break;
            }
            case 3100: {
                this.setString(parameterIndex, x_string);
                break;
            }
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: {
                short redHorseType = this.getSetRedHorseTypeFromJavaType(targetSqlType);
                this.setInterval(parameterIndex, redHorseType, x);
                break;
            }
            case 2005: 
            case 2011: 
            case 3700: {
                java.sql.Clob x_clob = null;
                if (x instanceof String) {
                    x_clob = new Clob(x_string);
                    this.setClob(parameterIndex, x_clob);
                    break;
                }
                if (x instanceof byte[]) {
                    x_clob = new Clob(this.connection.io.getStringWithCharactor((byte[])x));
                    this.setClob(parameterIndex, x_clob);
                    break;
                }
                if (x instanceof InputStream) {
                    this.setBinaryStream(parameterIndex, (InputStream)x);
                    break;
                }
                if (x instanceof Reader) {
                    this.setClob(parameterIndex, (Reader)x);
                    break;
                }
                x_clob = (java.sql.Clob)x;
                this.setClob(parameterIndex, x_clob);
                break;
            }
            case 2004: {
                java.sql.Blob x_blob = null;
                if (x instanceof byte[]) {
                    x_blob = new Blob((byte[])x);
                    this.setBlob(parameterIndex, x_blob);
                    break;
                }
                if (x instanceof InputStream) {
                    this.setBlob(parameterIndex, (InputStream)x);
                    break;
                }
                x_blob = (java.sql.Blob)x;
                this.setBlob(parameterIndex, x_blob);
                break;
            }
            case -3: 
            case -2: {
                if (x instanceof byte[]) {
                    this.setBytes(parameterIndex, (byte[])x);
                }
                if (!(x instanceof InputStream)) break;
                this.setBinaryStream(parameterIndex, (InputStream)x);
                break;
            }
            default: {
                throw Error.createSQLException("[E51031]\u76ee\u7684\u7c7b\u578b\u4e0d\u5339\u914d", ReplaceEnum.excStr.getReplaceStr() + 51031, 51031);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setObject   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else if (x instanceof java.sql.Blob) {
            this.setBlob(parameterIndex, (java.sql.Blob)x);
        } else if (x instanceof java.sql.Clob) {
            this.setClob(parameterIndex, (java.sql.Clob)x);
        } else if (x instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
        } else if (x instanceof BigInteger) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof LocalDateTime) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
            LocalDateTime local = (LocalDateTime)x;
            this.setString(parameterIndex, local.format(df));
        } else if (x instanceof LocalDate) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate local = (LocalDate)x;
            this.setString(parameterIndex, local.format(df));
        } else if (x instanceof LocalDateTime) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
            LocalTime local = (LocalTime)x;
            this.setString(parameterIndex, local.format(df));
        } else {
            this.setString(parameterIndex, x.toString());
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        this.sql = this.originalSql;
        this.paramNameIndex = 0;
        if (this.isPrepared) {
            if (this.isQuery) {
                return this.executeQuery() != null;
            }
            this.executeUpdate();
            return false;
        }
        if (this.connection.getBnechmarkMode() && this.connection.getBnechmarkModeWid() && !this.connection.redirect) {
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            for (int j = 0; j < stacks.length; ++j) {
                if (stacks[j].getClassName().indexOf("jTPCCTData") == -1 && stacks[j].getClassName().indexOf("jTPCCTerminal") == -1) continue;
                try {
                    if (stacks[j].getMethodName().indexOf("executeNewOrder") == -1 && stacks[j].getMethodName().indexOf("newOrderTransaction") == -1) continue;
                    int w_id = (int)this.bytesToInt((byte[])this.paramList.getParamData(0), this.paramList.getParamType(0));
                    this.connection.io.buildNewConnection2(w_id);
                    Set keySet = this.connection.openStatements.keySet();
                    for (Statement key : keySet) {
                        if (!(key instanceof PreparedStatement)) continue;
                        ParamList l = null;
                        if (this == key) {
                            l = this.paramList;
                        }
                        if (this != key) continue;
                        this.paramList = l;
                    }
                    this.connection.redirect = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.paramList != null) {
            String linitStr = null;
            if (this.noSendPreSqlLimit != null) {
                StringBuffer noSendSqlBuffer = new StringBuffer();
                noSendSqlBuffer.append(this.noSendPreSqlwhere);
                linitStr = this.noSendPreSqlLimit.replaceAll("[?]", "%d");
                linitStr = this.limitParamCount == 1 ? String.format(linitStr, this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount), this.paramList.getParamType(this.whereParamCount))) : String.format(linitStr, this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount), this.paramList.getParamType(this.whereParamCount)), this.bytesToInt((byte[])this.paramList.getParamData(this.whereParamCount + 1), this.paramList.getParamType(this.whereParamCount + 1)));
                this.originalSql = noSendSqlBuffer.append(" " + linitStr).toString();
                Object var2_4 = null;
            }
            if (!this.isJoinSQL) {
                this.joinSQL();
            }
        }
        this.isJoinSQL = false;
        boolean f = this.execute(this.originalSql);
        return f;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (!this.paramList.isAllSet()) {
            throw Error.createSQLException("[E50034]PreparedStatement: at least one parameter is not set by setXXX() method", ReplaceEnum.excStr.getReplaceStr() + 50034, 50034);
        }
        if (this.serverSupportBatch()) {
            byte[] eachParamBytes = this.joinBatchSQL(this.batchCount);
            this.batchParamLists.add(eachParamBytes);
            this.isJoinSQL = false;
            this.paramList.paramDatClear();
        } else {
            this.joinSQL();
            this.batchParamLists.add(this.paramBytes);
            this.isJoinSQL = false;
            this.paramList.paramDatClear();
        }
        ++this.batchCount;
    }

    public int addBatch1() throws SQLException {
        this.checkClosed();
        if (!this.paramList.isAllSet()) {
            throw Error.createSQLException("[E50034]PreparedStatement: at least one parameter is not set by setXXX() method", ReplaceEnum.excStr.getReplaceStr() + 50034, 50034);
        }
        if (this.serverSupportBatch()) {
            byte[] eachParamBytes = this.joinBatchSQL(this.batchCount);
            this.batchParamLists.add(eachParamBytes);
        } else {
            this.joinSQL();
            this.batchParamLists.add(this.paramBytes);
        }
        this.isJoinSQL = false;
        this.paramList.paramDatClear();
        return ++this.batchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] updateCount = null;
        this.isExeBatch = true;
        int i = 0;
        long beginBatchTime = 0L;
        try {
            this.initExecuteEnviorment(this.originalSql, true);
            if (this.batchCount == 0) {
                this.setStmIsOver(true);
                int[] nArray = new int[]{};
                return nArray;
            }
            this.resumeRowid();
            updateCount = new int[this.batchCount];
            MessageFormat messFormat = new MessageFormat(SQLCommon.getProperties().getProperty("PreparedStatement.callSQL"));
            String sql = this.isPrepared ? messFormat.format(new String[]{this.conObjName + String.valueOf(this.stId)}) : this.originalSql;
            this.checkBCountAndPCount(this.batchCount, this.paramCount);
            this.checkSqlLen(sql);
            if (Command.debug && Command.debugLevel.indexOf("batchSQL") != -1) {
                beginBatchTime = System.currentTimeMillis();
            }
            if (this.serverSupportBatch()) {
                boolean isReady = false;
                while (!isReady) {
                    Object object = this.getMutex();
                    synchronized (object) {
                        if (!this.connection.io.isBLocked()) {
                            this.connection.io.setBLocked(true);
                            isReady = true;
                            this.resumeSendType();
                            this.connection.io.sendCommandBatch(sql, this.batchParamLists, this.batchCount, this.paramCount);
                            this.resumeRowid();
                            this.firstResultSet();
                            for (int j = 0; j < this.batchCount; ++j) {
                                updateCount[j] = -2;
                            }
                        }
                    }
                }
            } else {
                this.resumeRowid();
                while (i < this.batchCount) {
                    this.paramBytes = this.batchParamLists.get(i);
                    updateCount[i] = this.executeUpdate(sql);
                    ++i;
                }
                if (Command.debug && Command.debugLevel.indexOf("batchSQL") != -1) {
                    this.connection.io.lw.write(this.connection.io.sessionId, this.sql + ": " + this.batchCount, LogWriter.CmdState.batchSQL, System.currentTimeMillis() - beginBatchTime);
                }
            }
        }
        catch (SQLException e) {
            updateCount = new int[this.serverBatchCount];
            for (int index = 0; index < this.serverBatchCount; ++index) {
                updateCount[index] = -2;
            }
            String ErrStr = e.getMessage();
            int err_code = this.getErr_Code(ErrStr);
            throw Error.createBatchUpdateException(ErrStr, ReplaceEnum.excStr.getReplaceStr() + err_code, err_code, updateCount);
        }
        finally {
            this.clearBatch();
        }
        return updateCount;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setCharacterStream   " + parameterIndex + " , " + reader.toString() + " , " + length);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        char[] c = null;
        long totalLen = 0L;
        try {
            if (reader == null) {
                this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
            } else {
                StringBuffer buf = new StringBuffer();
                if (length < 0L) {
                    throw Error.createSQLException("[E50035]The length of the parameter cannot be less than 1.", ReplaceEnum.excStr.getReplaceStr() + 50035, 50035);
                }
                if (length != 0L) {
                    c = length < (long)byteSize ? new char[(int)length] : new char[byteSize];
                    int len = 0;
                    while ((len = reader.read(c)) != -1) {
                        if (length - totalLen > (long)len) {
                            buf.append(c, 0, len);
                            totalLen += (long)len;
                            continue;
                        }
                        buf.append(c, 0, (int)(length - totalLen));
                        totalLen = length;
                        break;
                    }
                }
                if (totalLen == 0L) {
                    this.paramList.setObject(parameterIndex - 1, (short)32, (short)1, 1L, this.get0x0Bytes());
                } else {
                    this.setString(parameterIndex, buf.toString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setRef   " + i + " , " + x.toString());
        }
        throw SQLCommon.unSupportException("PreparedStatement.setRef", "int,Ref");
    }

    @Override
    public void setBlob(int parameterIndex, java.sql.Blob x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBlob   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            this.setBinaryStream(parameterIndex, x.getBinaryStream());
        }
    }

    @Override
    public void setClob(int parameterIndex, java.sql.Clob x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setClob   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            this.setCharacterStream(parameterIndex, x.getCharacterStream());
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setArray   " + i + " , " + x.toString());
        }
        throw SQLCommon.unSupportException("PreparedStatement.setArray", "int,Array");
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "getMetaData");
        }
        if (this.preFields != null) {
            return new ResultSetMetaData(this.preFields, this.connection.isIsora(), this.connection);
        }
        if (this.fields != null) {
            return new ResultSetMetaData(this.fields, this.connection.isIsora(), this.connection);
        }
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setDate   " + parameterIndex + " , " + x + " , " + cal);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (cal == null) {
            this.setDate(parameterIndex, x);
        } else if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            cal.setTime(x);
            java.util.Date date = cal.getTime();
            long d = date.getTime();
            this.setDate(parameterIndex, new Date(d));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setTime   " + parameterIndex + " , " + x + " , " + cal);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (cal == null) {
            this.setTime(parameterIndex, x);
        } else if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            cal.setTime(x);
            Time t = new Time(cal.getTime().getTime());
            this.setTime(parameterIndex, t);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setTimeStamp   " + parameterIndex + " , " + x + " , " + cal);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (cal == null) {
            this.setTimestamp(parameterIndex, x);
        } else if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            cal.setTimeInMillis(x.getTime());
            Timestamp ts = new Timestamp(cal.getTime().getTime());
            this.setTimestamp(parameterIndex, ts);
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNull   " + paramIndex + " , " + sqlType + " , " + typeName);
        }
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setURL   " + parameterIndex + " , " + x);
        }
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setString(parameterIndex, x.toString());
        }
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        Parameter[] param = null;
        param = this.paramList != null ? this.paramList.getParameters() : new Parameter[]{};
        return new ParameterMetaData(param, this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.isPoolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.isPoolable = poolable;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setAsciiStream   " + parameterIndex + " , " + x + " , " + length);
        }
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setAsciiStream   " + parameterIndex + " , " + x);
        }
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBinaryStream   " + parameterIndex + " , " + x + " , " + length);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        long totalLen = 0L;
        try {
            if (x == null) {
                this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
            } else {
                byte[] temp = null;
                if (length < 0L) {
                    throw Error.createSQLException("[E50035]The length of the parameter cannot be less than 1.", ReplaceEnum.excStr.getReplaceStr() + 50035, 50035);
                }
                if (length != 0L) {
                    temp = length < (long)byteSize ? new byte[(int)length] : new byte[byteSize];
                    int len = 0;
                    while ((len = x.read(temp)) != -1) {
                        if (length - totalLen > (long)len) {
                            bytesOut.write(temp, 0, len);
                            totalLen += (long)len;
                            continue;
                        }
                        bytesOut.write(temp, 0, (int)(length - totalLen));
                        totalLen = length;
                        break;
                    }
                }
                this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
                if (totalLen == 0L) {
                    this.paramList.setObject(parameterIndex - 1, (short)33, this.paramTypes, 1L, this.get0x0Bytes());
                } else {
                    this.paramList.setObject(parameterIndex - 1, (short)33, this.paramTypes, totalLen, bytesOut.toByteArray());
                }
            }
        }
        catch (IOException e) {
            throw Error.createSQLException("[E50037]PreparedStatement: Can't get the bytes from the InputStream.", ReplaceEnum.excStr.getReplaceStr() + 50037, 50037);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBinaryStream   " + parameterIndex + " , " + x);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        int totalLen = 0;
        if (x == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            byte[] temp = new byte[byteSize];
            try {
                int len = 0;
                while ((len = x.read(temp)) != -1) {
                    totalLen += len;
                    bytesOut.write(temp, 0, len);
                }
                bytesOut.close();
                byte[] blobBytes = bytesOut.toByteArray();
                this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
                if (totalLen == 0) {
                    this.paramList.setObject(parameterIndex - 1, (short)33, this.paramTypes, 1L, this.get0x0Bytes());
                } else {
                    this.paramList.setObject(parameterIndex - 1, (short)33, this.paramTypes, totalLen, blobBytes);
                }
            }
            catch (IOException e) {
                throw Error.createSQLException("[E50037]PreparedStatement: Can't get the bytes from the InputStream." + e.toString(), ReplaceEnum.excStr.getReplaceStr() + 50037, 50037);
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBlob   " + parameterIndex + " , " + inputStream + " , " + length);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        long totalLen = 0L;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            if (inputStream == null) {
                this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
            } else {
                byte[] temp = null;
                if (length < 0L) {
                    throw Error.createSQLException("[E50035]The length of the parameter cannot be less than 1.", ReplaceEnum.excStr.getReplaceStr() + 50035, 50035);
                }
                if (length != 0L) {
                    temp = length < (long)byteSize ? new byte[(int)length] : new byte[byteSize];
                    int len = 0;
                    while ((len = inputStream.read(temp)) != -1) {
                        if (length - totalLen > (long)len) {
                            byteOut.write(temp, 0, len);
                            totalLen += (long)len;
                            continue;
                        }
                        byteOut.write(temp, 0, (int)(length - totalLen));
                        totalLen = length;
                        break;
                    }
                }
                this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
                if (totalLen == 0L) {
                    this.paramList.setObject(parameterIndex - 1, (short)33, this.paramTypes, 1L, this.get0x0Bytes());
                } else {
                    this.paramList.setObject(parameterIndex - 1, (short)33, this.paramTypes, totalLen, byteOut.toByteArray());
                }
            }
        }
        catch (IOException e) {
            throw Error.createSQLException("[E50037]PreparedStatement: Can't get the bytes from the InputStream." + e.toString(), ReplaceEnum.excStr.getReplaceStr() + 50037, 50037);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setBlob   " + parameterIndex + " , " + inputStream);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] temp = new byte[byteSize];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int totalLen = 0;
        if (inputStream == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            try {
                int len = 0;
                while ((len = inputStream.read(temp)) != -1) {
                    byteOut.write(temp, 0, len);
                    totalLen += len;
                }
                this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
                if (totalLen == 0) {
                    this.paramList.setObject(parameterIndex - 1, (short)34, this.paramTypes, 1L, this.get0x0Bytes());
                } else {
                    this.paramList.setObject(parameterIndex - 1, (short)34, this.paramTypes, totalLen, byteOut.toByteArray());
                }
            }
            catch (IOException e) {
                throw Error.createSQLException("[E50037]PreparedStatement: Can't get the bytes from the InputStream." + e.toString(), ReplaceEnum.excStr.getReplaceStr() + 50037, 50037);
            }
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setCharacterStream   " + parameterIndex + " , " + reader);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        long totalLen = 0L;
        if (reader == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            try {
                char[] c = new char[byteSize];
                int len = 0;
                StringBuffer buf = new StringBuffer();
                while ((len = reader.read(c)) != -1) {
                    totalLen += (long)len;
                    buf.append(c, 0, len);
                }
                if (totalLen == 0L) {
                    this.paramList.setObject(parameterIndex - 1, (short)32, (short)1, 1L, this.get0x0Bytes());
                } else {
                    this.setString(parameterIndex, buf.toString());
                }
            }
            catch (IOException e) {
                throw Error.createSQLException("[E50037]PreparedStatement: Can't get the bytes from the InputStream." + e.toString(), ReplaceEnum.excStr.getReplaceStr() + 50037, 50037);
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setClob   " + parameterIndex + " , " + reader + " , " + length);
        }
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setClob   " + parameterIndex + " , " + reader);
        }
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNCharacterStream   " + parameterIndex + " , " + value + " , " + length);
        }
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNCharacterStream   " + parameterIndex + " , " + value);
        }
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNClob   " + parameterIndex + " , " + value);
        }
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNClob   " + parameterIndex + " , " + reader + " , " + length);
        }
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNClob   " + parameterIndex + " , " + reader);
        }
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setNString   " + parameterIndex + " , " + value);
        }
        this.setString(parameterIndex, value);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setRowId  " + parameterIndex + " , " + x);
        }
        this.setString(parameterIndex, x == null ? null : x.toString());
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setSQLXML   " + parameterIndex + " , " + xmlObject);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        if (xmlObject == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            String xmlStr = xmlObject.getString();
            this.setString(parameterIndex, xmlStr);
        }
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        return false;
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }

    protected void setTime_TZ(int parameterIndex, String time_tz) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setTime_TZ   " + parameterIndex + " , " + time_tz);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] tz_Bytes = null;
        int len = 0;
        try {
            if (time_tz == null) {
                this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
            } else {
                tz_Bytes = time_tz.getBytes(this.connection.getCharSet());
                len = tz_Bytes.length;
                this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
                this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, len, tz_Bytes);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
    }

    protected void setDateTime_TZ(int parameterIndex, String dtime_tz) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setDatetime_TZ   " + parameterIndex + " , " + dtime_tz);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] dtz_Bytes = null;
        int len = 0;
        if (dtime_tz == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
        } else {
            try {
                dtz_Bytes = dtime_tz.getBytes(this.connection.getCharSet());
                len = dtz_Bytes.length;
                this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
                this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, len, dtz_Bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw SQLCommon.EncodingException(e);
            }
        }
    }

    protected void setInterval_Y(int parameterIndex, String interval_y) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_Y   " + parameterIndex + " , " + interval_y);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] y_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_y != null) {
                y_Bytes = interval_y.getBytes(this.connection.getCharSet());
                len = y_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)15, this.paramTypes, len, y_Bytes);
    }

    protected void setInterval(int parameterIndex, short redhorseType, Object intervalObj) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval   " + parameterIndex + " , " + intervalObj);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        if (intervalObj == null) {
            this.setNull(parameterIndex, this.getParamJavaType(parameterIndex - 1));
            return;
        }
        if (intervalObj instanceof Integer) {
            if (redhorseType == 27 || redhorseType == 24 || redhorseType == 25 || redhorseType == 26) {
                throw new SQLException("[E52010]PreparedStatement\uff1a\u63d2\u5165\u6570\u636e\u8d85\u8fc7\u8303\u56f4", ReplaceEnum.excStr.getReplaceStr() + 52010, 52010);
            }
            int intObj = (Integer)intervalObj;
            byte[] intBytes = this.intToByte(intObj);
            long len = 4L;
            this.paramList.setObject(parameterIndex - 1, redhorseType, this.paramTypes, len, intBytes);
        } else if (intervalObj instanceof Long) {
            if (redhorseType != 27 || redhorseType != 24 || redhorseType != 25 || redhorseType != 26) {
                throw new SQLException("[E52010]PreparedStatement\uff1a\u63d2\u5165\u6570\u636e\u8d85\u8fc7\u8303\u56f4", ReplaceEnum.excStr.getReplaceStr() + 52010, 52010);
            }
            long longObj = (Long)intervalObj;
            byte[] longBytes = this.longToByte(longObj);
            long len = 8L;
            this.paramList.setObject(parameterIndex - 1, redhorseType, this.paramTypes, len, longBytes);
        } else if (intervalObj instanceof String) {
            String strObj = (String)intervalObj;
            byte[] strBytes = null;
            try {
                strBytes = strObj.getBytes(this.connection.getCharSet());
            }
            catch (UnsupportedEncodingException e) {
                throw SQLCommon.EncodingException(e);
            }
            long len = strBytes.length;
            this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, len, strBytes);
        } else if (intervalObj instanceof byte[]) {
            byte[] byteObj = (byte[])intervalObj;
            long len = byteObj.length;
            this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, len, byteObj);
        } else {
            throw new SQLException("[E52011]\u53c2\u6570\u6570\u636e\u4e0d\u80fd\u8f6c\u6362\u4e3ainterval\u7c7b\u578b", ReplaceEnum.excStr.getReplaceStr() + 52012, 52012);
        }
    }

    protected void setInterval_M(int parameterIndex, String interval_m) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_M   " + parameterIndex + " , " + interval_m);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] m_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_m != null) {
                m_Bytes = interval_m.getBytes(this.connection.getCharSet());
                len = m_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)17, this.paramTypes, len, m_Bytes);
    }

    protected void setInterval_D(int parameterIndex, String interval_d) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_D   " + parameterIndex + " , " + interval_d);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] d_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_d != null) {
                d_Bytes = interval_d.getBytes(this.connection.getCharSet());
                len = d_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)18, this.paramTypes, len, d_Bytes);
    }

    protected void setInterval_H(int parameterIndex, String interval_h) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_H   " + parameterIndex + " , " + interval_h);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] h_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_h != null) {
                h_Bytes = interval_h.getBytes(this.connection.getCharSet());
                len = h_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)20, this.paramTypes, len, h_Bytes);
    }

    protected void setInterval_MI(int parameterIndex, String interval_mi) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_Y MI  " + parameterIndex + " , " + interval_mi);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] mi_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_mi != null) {
                mi_Bytes = interval_mi.getBytes(this.connection.getCharSet());
                len = mi_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)23, this.paramTypes, len, mi_Bytes);
    }

    protected void setInterval_S(int parameterIndex, String interval_s) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_S   " + parameterIndex + " , " + interval_s);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] s_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_s != null) {
                s_Bytes = interval_s.getBytes(this.connection.getCharSet());
                len = s_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)27, this.paramTypes, len, s_Bytes);
    }

    protected void setInterval_Y2M(int parameterIndex, String interval_y2m) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_Y2M   " + parameterIndex + " , " + interval_y2m);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] y2m_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_y2m != null) {
                y2m_Bytes = interval_y2m.getBytes(this.connection.getCharSet());
                len = y2m_Bytes.length;
            }
            this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, len, y2m_Bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
    }

    protected void setInterval_D2M(int parameterIndex, String interval_d2m) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_D2M   " + parameterIndex + " , " + interval_d2m);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] d2m_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_d2m != null) {
                d2m_Bytes = interval_d2m.getBytes(this.connection.getCharSet());
                len = d2m_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)21, this.paramTypes, len, d2m_Bytes);
    }

    protected void setInterval_D2H(int parameterIndex, String interval_d2h) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_D2H   " + parameterIndex + " , " + interval_d2h);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] d2h_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_d2h != null) {
                d2h_Bytes = interval_d2h.getBytes(this.connection.getCharSet());
                len = d2h_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)19, this.paramTypes, len, d2h_Bytes);
    }

    protected void setInterval_D2S(int parameterIndex, String interval_d2s) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_D2S   " + parameterIndex + " , " + interval_d2s);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] d2s_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_d2s != null) {
                d2s_Bytes = interval_d2s.getBytes(this.connection.getCharSet());
                len = d2s_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)30, this.paramTypes, len, d2s_Bytes);
    }

    protected void setInterval_H2M(int parameterIndex, String interval_h2m) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_H2M   " + parameterIndex + " , " + interval_h2m);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] h2m_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_h2m != null) {
                h2m_Bytes = interval_h2m.getBytes(this.connection.getCharSet());
                len = h2m_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)22, this.paramTypes, len, h2m_Bytes);
    }

    protected void setInterval_H2S(int parameterIndex, String interval_h2s) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_H2S   " + parameterIndex + " , " + interval_h2s);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] h2s_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_h2s != null) {
                h2s_Bytes = interval_h2s.getBytes(this.connection.getCharSet());
                len = h2s_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)25, this.paramTypes, len, h2s_Bytes);
    }

    protected void setInterval_M2S(int parameterIndex, String interval_m2s) throws SQLException {
        if (Command.debug) {
            Command.logPstmethods(this.connection.io, "setInterval_M2S   " + parameterIndex + " , " + interval_m2s);
        }
        this.checkClosed();
        this.checkPosition(parameterIndex);
        byte[] m2s_Bytes = null;
        int len = 0;
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 1);
        try {
            if (interval_m2s != null) {
                m2s_Bytes = interval_m2s.getBytes(this.connection.getCharSet());
                len = m2s_Bytes.length;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw SQLCommon.EncodingException(e);
        }
        this.paramList.setObject(parameterIndex - 1, (short)26, this.paramTypes, len, m2s_Bytes);
    }

    private int getParamJavaType(int paramIndex) {
        return this.paramList.getParamJavaType(paramIndex);
    }

    public Hashtable<Integer, String> getInsertRowids() {
        return this.getRowid();
    }

    protected short getParamType(ParamList param, int idx, int methode) {
        if (!this.isPrepared) {
            return 1;
        }
        int paramType = 0;
        if (methode == 1) {
            paramType = param.getParamIsRegist(idx) ? 3 : 1;
        }
        if (methode == 2) {
            paramType = param.getParamIsSet(idx) ? 3 : 2;
        }
        return (short)paramType;
    }

    private byte[] getBytes(char[] chars) {
        Charset cs = Charset.forName(this.connection.getCharSet());
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batchParamLists.clear();
        this.batchCount = 0;
        this.serverBatchCount = 0;
        this.isExeBatch = false;
    }

    private byte[] dt2int(Date dt) {
        byte[] dtBytes = new byte[4];
        long dt_s = dt.getTime() / 1000L;
        int dt_d = (int)dt_s / 86400;
        for (int i = 0; i < 4; ++i) {
            dtBytes[i] = (byte)(dt_d >>> 24 - 8 * i & 0xFF);
        }
        return dtBytes;
    }

    private byte[] time2int(Time time) {
        byte[] timeBytes = new byte[4];
        long time_second = time.getTime() / 1000L;
        int time_int = (int)time_second % 86400 * 1000;
        for (int i = 0; i < 4; ++i) {
            timeBytes[i] = (byte)(time_int >>> 24 - 8 * i & 0xFF);
        }
        return timeBytes;
    }

    private byte[] ts2long(Timestamp ts) {
        byte[] tsBytes = new byte[8];
        long ts_s = ts.getTime() * 1000L;
        for (int i = 0; i < 8; ++i) {
            tsBytes[i] = (byte)(ts_s >>> 56 - 8 * i & 0xFFL);
        }
        return tsBytes;
    }

    protected byte[] get0x0Bytes() {
        byte[] b = new byte[]{0};
        return b;
    }

    private long bytesToInt(byte[] intBytes, int sqlType) throws SQLException {
        long l = 0L;
        if (intBytes == null) {
            throw new SQLException("[E52010]PreparedStatement\uff1a\u63d2\u5165\u6570\u636e\u8d85\u8fc7\u8303\u56f4", ReplaceEnum.excStr.getReplaceStr() + 52010, 52010);
        }
        switch (sqlType) {
            case -6: 
            case 2: 
            case 4: 
            case 5: {
                for (int i = 0; i < intBytes.length; ++i) {
                    l |= (long)((intBytes[i] & 0xFF) << (intBytes.length - i - 1) * 8);
                }
                break;
            }
            default: {
                if (Pattern.matches("[0-9]*", new String(intBytes))) {
                    l = new BigDecimal(new String(intBytes)).longValueExact();
                    break;
                }
                throw new SQLException("[E52010]PreparedStatement\uff1a\u63d2\u5165\u6570\u636e\u8d85\u8fc7\u8303\u56f4", ReplaceEnum.excStr.getReplaceStr() + 52010, 52010);
            }
        }
        return l;
    }

    protected short getSetRedHorseTypeFromJavaType(int sqlType) {
        short redhorseType = 0;
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 93: 
            case 2005: 
            case 2011: 
            case 3399: 
            case 3400: {
                redhorseType = 30;
                break;
            }
            case 91: {
                redhorseType = 10;
                break;
            }
            case 92: {
                redhorseType = 11;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 3500: {
                redhorseType = 33;
                break;
            }
            case 16: {
                redhorseType = 2;
                break;
            }
            case -7: 
            case -6: {
                redhorseType = 3;
                break;
            }
            case 5: {
                redhorseType = 4;
                break;
            }
            case 4: {
                redhorseType = 5;
                break;
            }
            case -5: {
                redhorseType = 6;
                break;
            }
            case 6: {
                redhorseType = 8;
                break;
            }
            case 8: {
                redhorseType = 9;
                break;
            }
            case 3200: {
                redhorseType = 12;
                break;
            }
            case 3100: {
                redhorseType = 14;
                break;
            }
            case 3003: {
                redhorseType = 18;
                break;
            }
            case 3008: {
                redhorseType = 19;
                break;
            }
            case 3009: {
                redhorseType = 21;
                break;
            }
            case 3010: {
                redhorseType = 24;
                break;
            }
            case 3004: {
                redhorseType = 20;
                break;
            }
            case 3011: {
                redhorseType = 22;
                break;
            }
            case 3012: {
                redhorseType = 25;
                break;
            }
            case 3002: {
                redhorseType = 17;
                break;
            }
            case 3013: {
                redhorseType = 26;
                break;
            }
            case 3005: {
                redhorseType = 23;
                break;
            }
            case 3006: {
                redhorseType = 27;
                break;
            }
            case 3001: {
                redhorseType = 15;
                break;
            }
            case 3007: {
                redhorseType = 16;
                break;
            }
            case 0: 
            case 1111: {
                redhorseType = 30;
                break;
            }
        }
        return redhorseType;
    }

    private String parseSQL(String orgSQL) {
        int i = 0;
        int begin_index = 0;
        int end_index = 0;
        orgSQL = orgSQL.trim();
        String sql = "";
        String returnParam = "";
        char nullChar = ' ';
        while (orgSQL.charAt(i) == nullChar) {
            ++i;
        }
        if (orgSQL.charAt(i) == '{') {
            ++i;
            while (orgSQL.charAt(i) == nullChar) {
                ++i;
            }
            if (orgSQL.charAt(i) == '?' || orgSQL.charAt(i) == ':') {
                if (this.paramList == null) {
                    this.paramList = new ParamList();
                }
                this.paramList.add(0);
                ++this.paramCount;
                ++i;
            }
            int ord = 1;
            while (orgSQL.charAt(i) == ' ') {
                ++i;
            }
            i = orgSQL.indexOf("=");
            if (i != -1) {
                this.isFunction = true;
                returnParam = orgSQL.substring(1, i).trim();
            }
            if ((begin_index = orgSQL.indexOf("call")) != -1) {
                orgSQL = orgSQL.substring(begin_index + 4);
            }
            orgSQL = orgSQL.substring(orgSQL.indexOf(" "), orgSQL.length());
            i = 0;
            while (orgSQL.charAt(i) == ' ') {
                ++i;
            }
            int sLen = orgSQL.length();
            boolean inStr = false;
            block32: while (i < sLen) {
                char ch = orgSQL.charAt(i);
                switch (ch) {
                    case '\'': {
                        inStr = !inStr;
                        sql = sql + ch;
                        ++i;
                        continue block32;
                    }
                    case '\\': {
                        if (orgSQL.charAt(i + 1) != '\'') continue block32;
                        sql = sql + "\\'";
                        i += 2;
                        continue block32;
                    }
                    case '?': {
                        if (this.paramList == null) {
                            this.paramList = new ParamList();
                        }
                        if (!inStr && this.paramList != null) {
                            this.paramList.add(ord);
                            ++this.paramCount;
                        }
                        sql = sql + ch;
                        ++i;
                        continue block32;
                    }
                    case ',': {
                        sql = sql + ch;
                        ++i;
                        continue block32;
                    }
                    case '}': {
                        ++i;
                        continue block32;
                    }
                }
                sql = sql + ch;
                ++i;
            }
            if (this.isFunction) {
                sql = sql + "," + returnParam;
            }
            return sql;
        }
        begin_index = orgSQL.toLowerCase().indexOf("begin");
        if (begin_index != -1 && (end_index = orgSQL.toLowerCase().indexOf("end")) != -1 && !orgSQL.toLowerCase().contains("with function")) {
            char beginNext = orgSQL.charAt(begin_index + 5);
            if (beginNext == ' ' || beginNext == '\n' || beginNext == '\r') {
                orgSQL = orgSQL.substring(begin_index + 6, end_index).trim();
                int sLen = orgSQL.length();
                boolean inStr = false;
                int ord = 1;
                block33: while (i < sLen) {
                    char ch = orgSQL.charAt(i);
                    switch (ch) {
                        case '\'': {
                            inStr = !inStr;
                            sql = sql + ch;
                            ++i;
                            continue block33;
                        }
                        case '\\': {
                            if (orgSQL.charAt(i + 1) != '\'') continue block33;
                            sql = sql + "\\'";
                            i += 2;
                            continue block33;
                        }
                        case '?': {
                            if (this.paramList == null) {
                                this.paramList = new ParamList();
                            }
                            if (!inStr && this.paramList != null) {
                                this.paramList.add(ord);
                                ++this.paramCount;
                            }
                            sql = sql + ch;
                            ++i;
                            continue block33;
                        }
                        case ',': {
                            sql = sql + ch;
                            ++i;
                            continue block33;
                        }
                        case ';': 
                        case '}': {
                            ++i;
                            continue block33;
                        }
                    }
                    sql = sql + ch;
                    ++i;
                }
            } else {
                this.shouldPrepared = true;
            }
        } else {
            if (orgSQL.startsWith("call")) {
                orgSQL = orgSQL.substring(begin_index + 5);
                int sLen = orgSQL.length();
                boolean inStr = false;
                int ord = 1;
                block34: while (i < sLen) {
                    char ch = orgSQL.charAt(i);
                    switch (ch) {
                        case '\'': {
                            inStr = !inStr;
                            sql = sql + ch;
                            ++i;
                            continue block34;
                        }
                        case '\\': {
                            if (orgSQL.charAt(i + 1) != '\'') continue block34;
                            sql = sql + "\\'";
                            i += 2;
                            continue block34;
                        }
                        case '?': {
                            if (this.paramList == null) {
                                this.paramList = new ParamList();
                            }
                            if (!inStr && this.paramList != null) {
                                this.paramList.add(ord);
                                ++this.paramCount;
                            }
                            sql = sql + ch;
                            ++i;
                            continue block34;
                        }
                        case ',': {
                            sql = sql + ch;
                            ++i;
                            continue block34;
                        }
                        case '}': {
                            ++i;
                            continue block34;
                        }
                    }
                    sql = sql + ch;
                    ++i;
                }
                return sql;
            }
            begin_index = orgSQL.indexOf("=call");
            if (begin_index != -1) {
                orgSQL = orgSQL.substring(begin_index + 6).trim();
                int sLen = orgSQL.length();
                boolean inStr = false;
                int ord = 1;
                block35: while (i < sLen) {
                    char ch = orgSQL.charAt(i);
                    switch (ch) {
                        case '\'': {
                            inStr = !inStr;
                            sql = sql + ch;
                            ++i;
                            continue block35;
                        }
                        case '\\': {
                            if (orgSQL.charAt(i + 1) != '\'') continue block35;
                            sql = sql + "\\'";
                            i += 2;
                            continue block35;
                        }
                        case '?': {
                            if (this.paramList == null) {
                                this.paramList = new ParamList();
                            }
                            if (!inStr && this.paramList != null) {
                                this.paramList.add(ord);
                                ++this.paramCount;
                            }
                            sql = sql + ch;
                            ++i;
                            continue block35;
                        }
                        case ',': {
                            sql = sql + ch;
                            ++i;
                            continue block35;
                        }
                        case '}': {
                            ++i;
                            continue block35;
                        }
                    }
                    sql = sql + ch;
                    ++i;
                }
            }
            this.shouldPrepared = true;
        }
        return sql.equals("") ? orgSQL : sql;
    }
}

