/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect.slf4j;

import com.xiaoleilu.hutool.log.AbstractLocationAwareLog;
import com.xiaoleilu.hutool.log.level.Level;
import com.xiaoleilu.hutool.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Slf4jLog.class.getName();
    private final transient Logger logger;

    public Slf4jLog(Logger logger) {
        this.logger = logger;
    }

    public Slf4jLog(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz));
    }

    public Slf4jLog(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (!this.locationAwareLog(0, format, arguments)) {
            this.logger.trace(format, arguments);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(0, t, format, arguments)) {
            this.logger.trace(StrUtil.format((CharSequence)format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (!this.locationAwareLog(10, format, arguments)) {
            this.logger.debug(format, arguments);
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(10, t, format, arguments)) {
            this.logger.debug(StrUtil.format((CharSequence)format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (!this.locationAwareLog(20, format, arguments)) {
            this.logger.info(format, arguments);
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(20, t, format, arguments)) {
            this.logger.info(StrUtil.format((CharSequence)format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (!this.locationAwareLog(30, format, arguments)) {
            this.logger.warn(format, arguments);
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(30, t, format, arguments)) {
            this.logger.warn(StrUtil.format((CharSequence)format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (!this.locationAwareLog(40, format, arguments)) {
            this.logger.error(format, arguments);
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(40, t, format, arguments)) {
            this.logger.error(StrUtil.format((CharSequence)format, arguments), t);
        }
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        int level_int;
        switch (level) {
            case TRACE: {
                level_int = 0;
                break;
            }
            case DEBUG: {
                level_int = 10;
                break;
            }
            case INFO: {
                level_int = 20;
                break;
            }
            case WARN: {
                level_int = 30;
                break;
            }
            case ERROR: {
                level_int = 40;
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", new Object[]{level}));
            }
        }
        this.locationAwareLog(fqcn, level_int, t, format, arguments);
    }

    private boolean locationAwareLog(int level_int, String msgTemplate, Object[] arguments) {
        return this.locationAwareLog(level_int, null, msgTemplate, arguments);
    }

    private boolean locationAwareLog(int level_int, Throwable t, String msgTemplate, Object[] arguments) {
        return this.locationAwareLog(FQCN, level_int, t, msgTemplate, arguments);
    }

    private boolean locationAwareLog(String fqcn, int level_int, Throwable t, String msgTemplate, Object[] arguments) {
        if (this.logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, fqcn, level_int, StrUtil.format((CharSequence)msgTemplate, arguments), null, t);
            return true;
        }
        return false;
    }
}

