/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.json;

import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.file.FileReader;
import com.xiaoleilu.hutool.json.InternalJSONUtil;
import com.xiaoleilu.hutool.json.JSON;
import com.xiaoleilu.hutool.json.JSONArray;
import com.xiaoleilu.hutool.json.JSONNull;
import com.xiaoleilu.hutool.json.JSONObject;
import com.xiaoleilu.hutool.json.JSONStrFormater;
import com.xiaoleilu.hutool.json.JSONString;
import com.xiaoleilu.hutool.json.XML;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;

public final class JSONUtil {
    public static JSONObject createObj() {
        return new JSONObject();
    }

    public static JSONArray createArray() {
        return new JSONArray();
    }

    public static JSONObject parseObj(String jsonStr) {
        return new JSONObject(jsonStr);
    }

    public static JSONObject parseObj(Object obj) {
        return new JSONObject(obj);
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue) {
        return new JSONObject(obj, ignoreNullValue);
    }

    public static JSONArray parseArray(String jsonStr) {
        return new JSONArray(jsonStr);
    }

    public static JSONArray parseArray(Object arrayOrCollection) {
        return new JSONArray(arrayOrCollection);
    }

    public static JSONArray parseArray(Object arrayOrCollection, boolean ignoreNullValue) {
        return new JSONArray(arrayOrCollection, ignoreNullValue);
    }

    public static JSON parse(Object obj) {
        String jsonStr;
        if (null == obj) {
            return null;
        }
        Object json = null;
        json = obj instanceof JSON ? (JSON)obj : (obj instanceof String ? ((jsonStr = ((String)obj).trim()).startsWith("[") ? JSONUtil.parseArray(jsonStr) : JSONUtil.parseObj(jsonStr)) : (obj instanceof Collection || obj.getClass().isArray() ? new JSONArray(obj) : new JSONObject(obj)));
        return json;
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return XML.toJSONObject(xmlStr);
    }

    public static JSONObject parseFromMap(Map<?, ?> map) {
        return new JSONObject(map);
    }

    public static JSONObject parseFromResourceBundle(ResourceBundle bundle) {
        JSONObject jsonObject = new JSONObject();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(jsonObject, key, bundle.getString(key));
        }
        return jsonObject;
    }

    public static JSON readJSON(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parse(FileReader.create(file, charset).readString());
    }

    public static JSONObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parseObj(FileReader.create(file, charset).readString());
    }

    public static JSONArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parseArray(FileReader.create(file, charset).readString());
    }

    public static String toJsonStr(JSON json, int indentFactor) {
        return json.toJSONString(indentFactor);
    }

    public static String toJsonStr(JSON json) {
        return json.toJSONString(0);
    }

    public static String toJsonPrettyStr(JSON json) {
        return json.toJSONString(4);
    }

    public static String toJsonStr(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return JSONUtil.toJsonStr(JSONUtil.parse(obj));
    }

    public static String toJsonPrettyStr(Object obj) {
        return JSONUtil.toJsonPrettyStr(JSONUtil.parse(obj));
    }

    public static String toXmlStr(JSON json) {
        return XML.toString(json);
    }

    public static <T> T toBean(String jsonString, Class<T> beanClass) {
        return JSONUtil.toBean(JSONUtil.parseObj(jsonString), beanClass, false);
    }

    public static <T> T toBean(JSONObject json, Class<T> beanClass) {
        return JSONUtil.toBean(json, beanClass, false);
    }

    public static <T> T toBean(JSONObject json, Class<T> beanClass, boolean ignoreError) {
        return (T)(null == json ? null : json.toBean(beanClass, ignoreError));
    }

    public static Object getByExp(JSON json, String expression) {
        return null == json || StrUtil.isBlank(expression) ? null : json.getByExp(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONUtil.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    public static Writer quote(String string, Writer writer) throws IOException {
        if (StrUtil.isEmpty(string)) {
            writer.write("\"\"");
            return writer;
        }
        char c = '\u0000';
        int len = string.length();
        writer.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        writer.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        writer.write("0000", 0, 4 - hhhh.length());
                        writer.write(hhhh);
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
        return writer;
    }

    public static Object wrap(Object object, boolean ignoreNullValue) {
        if (object == null) {
            return JSONNull.NULL;
        }
        if (object instanceof JSON || JSONNull.NULL.equals(object) || object instanceof JSONString || object instanceof CharSequence || object instanceof Number || ObjectUtil.isBasicType(object)) {
            return object;
        }
        try {
            String objectPackageName;
            if (object instanceof Iterable || ArrayUtil.isArray(object)) {
                return new JSONArray(object, ignoreNullValue);
            }
            if (object instanceof Date) {
                return ((Date)object).getTime();
            }
            if (object instanceof Calendar) {
                return ((Calendar)object).getTimeInMillis();
            }
            Class<?> objectClass = object.getClass();
            Package objectPackage = objectClass.getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || objectClass.getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object, ignoreNullValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormater.format(jsonStr);
    }
}

