/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cron;

import com.xiaoleilu.hutool.cron.Scheduler;
import com.xiaoleilu.hutool.cron.task.Task;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.setting.SettingRuntimeException;

public final class CronUtil {
    public static final String CRONTAB_CONFIG_PATH = "config/cron.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    private CronUtil() {
    }

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        try {
            crontabSetting = new Setting(cronSettingPath, Setting.DEFAULT_CHARSET, false);
        }
        catch (SettingRuntimeException settingRuntimeException) {
            // empty catch block
        }
    }

    public static void setMatchSecond(boolean isMatchSecond) {
        scheduler.setMatchSecond(isMatchSecond);
    }

    public static void setMatchYear(boolean isMatchYear) {
        scheduler.setMatchYear(isMatchYear);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        scheduler.schedule(cronSetting);
    }

    public void remove(String schedulerId) {
        scheduler.deschedule(schedulerId);
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    public static synchronized void start() {
        if (null == crontabSetting) {
            CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void restart() {
        if (null != crontabSetting) {
            crontabSetting.load();
        }
        if (scheduler.isStarted()) {
            scheduler.stop();
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }
}

