/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bean.copier;

import com.xiaoleilu.hutool.bean.BeanDesc;
import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.bean.copier.CopyOptions;
import com.xiaoleilu.hutool.bean.copier.ValueProvider;
import com.xiaoleilu.hutool.bean.copier.provider.BeanValueProvider;
import com.xiaoleilu.hutool.bean.copier.provider.MapValueProvider;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.copier.Copier;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.MapUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class BeanCopier<T>
implements Copier<T> {
    private Object source;
    private T dest;
    private CopyOptions copyOptions;

    public static <T> BeanCopier<T> create(Object source, T dest, CopyOptions copyOptions) {
        return new BeanCopier<T>(source, dest, copyOptions);
    }

    public BeanCopier(Object source, T dest, CopyOptions copyOptions) {
        this.source = source;
        this.dest = dest;
        this.copyOptions = copyOptions;
    }

    @Override
    public T copy() {
        if (null != this.source) {
            if (this.source instanceof ValueProvider) {
                this.valueProviderToBean((ValueProvider)this.source, this.dest);
            } else if (this.source instanceof Map) {
                this.mapToBean((Map)this.source, this.dest);
            } else {
                this.beanToBean(this.source, this.dest);
            }
        }
        return this.dest;
    }

    private void beanToBean(Object providerBean, Object destBean) {
        this.valueProviderToBean(new BeanValueProvider(providerBean, this.copyOptions.ignoreCase, this.copyOptions.ignoreError), destBean);
    }

    private void mapToBean(Map<?, ?> map, Object bean) {
        this.valueProviderToBean(new MapValueProvider(map, this.copyOptions.ignoreCase), bean);
    }

    private void valueProviderToBean(ValueProvider<String> valueProvider, Object bean) {
        if (null == valueProvider) {
            return;
        }
        Class<?> actualEditable = bean.getClass();
        if (this.copyOptions.editable != null) {
            if (!this.copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), this.copyOptions.editable.getName()));
            }
            actualEditable = this.copyOptions.editable;
        }
        HashSet<String> ignoreSet = null != this.copyOptions.ignoreProperties ? CollectionUtil.newHashSet(this.copyOptions.ignoreProperties) : null;
        Map<String, String> fieldReverseMapping = null != this.copyOptions.fieldMapping ? MapUtil.reverse(this.copyOptions.fieldMapping) : null;
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(actualEditable).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            Method setterMethod;
            String fieldName = prop.getFieldName();
            if (null != ignoreSet && ignoreSet.contains(fieldName) || !valueProvider.containsKey(fieldName) || null == (setterMethod = prop.getSetter())) continue;
            String providerKey = null;
            if (null != fieldReverseMapping) {
                providerKey = fieldReverseMapping.get(fieldName);
            }
            if (null == providerKey) {
                providerKey = fieldName;
            }
            if (null == (value = valueProvider.value(providerKey, TypeUtil.getFirstParamType(setterMethod))) && this.copyOptions.ignoreNullValue) continue;
            try {
                Class<?> propClass = prop.getFieldClass();
                if (!propClass.isInstance(value) && null == (value = Convert.convert(propClass, value)) && this.copyOptions.ignoreNullValue || null == setterMethod) continue;
                setterMethod.invoke(bean, value);
            }
            catch (Exception e) {
                if (this.copyOptions.ignoreError) continue;
                throw new UtilException(e, "Inject [{}] error!", prop.getFieldName());
            }
        }
    }
}

