/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.ConfigUtil;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.ServiceConfig;
import com.weibo.api.motan.config.springsupport.MotanNamespaceHandler;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ServiceConfigBean<T>
extends ServiceConfig<T>
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final long serialVersionUID = -7247592395983804440L;
    private transient BeanFactory beanFactory;

    public void destroy() throws Exception {
        this.unexport();
    }

    public void afterPropertiesSet() throws Exception {
        this.checkAndConfigBasicConfig();
        this.checkAndConfigExport();
        this.checkAndConfigRegistry();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.getExported().get()) {
            this.export();
        }
    }

    private void checkAndConfigBasicConfig() {
        if (this.getBasicService() == null) {
            if (MotanNamespaceHandler.basicServiceConfigDefineNames.size() == 0 && this.beanFactory instanceof ListableBeanFactory) {
                ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
                String[] basicServiceConfigNames = listableBeanFactory.getBeanNamesForType(BasicServiceInterfaceConfig.class);
                MotanNamespaceHandler.basicServiceConfigDefineNames.addAll(Arrays.asList(basicServiceConfigNames));
            }
            for (String name : MotanNamespaceHandler.basicServiceConfigDefineNames) {
                BasicServiceInterfaceConfig biConfig = (BasicServiceInterfaceConfig)this.beanFactory.getBean(name, BasicServiceInterfaceConfig.class);
                if (biConfig == null) continue;
                if (MotanNamespaceHandler.basicServiceConfigDefineNames.size() == 1) {
                    this.setBasicService(biConfig);
                    continue;
                }
                if (biConfig.isDefault() == null || !biConfig.isDefault().booleanValue()) continue;
                this.setBasicService(biConfig);
            }
        }
    }

    private void checkAndConfigExport() {
        Map exportMap;
        if (StringUtils.isBlank((CharSequence)this.getExport()) && this.getBasicService() != null && !StringUtils.isBlank((CharSequence)this.getBasicService().getExport())) {
            this.setExport(this.getBasicService().getExport());
            if (this.getBasicService().getProtocols() != null) {
                this.setProtocols(new ArrayList(this.getBasicService().getProtocols()));
            }
        }
        if (CollectionUtil.isEmpty((Collection)this.getProtocols()) && StringUtils.isNotEmpty((CharSequence)this.getExport()) && !(exportMap = ConfigUtil.parseExport((String)this.export)).isEmpty()) {
            ArrayList<ProtocolConfig> protos = new ArrayList<ProtocolConfig>();
            for (String p : exportMap.keySet()) {
                ProtocolConfig proto = null;
                try {
                    proto = (ProtocolConfig)this.beanFactory.getBean(p, ProtocolConfig.class);
                }
                catch (NoSuchBeanDefinitionException e) {
                    // empty catch block
                }
                if (proto == null) {
                    if ("motan".equals(p)) {
                        proto = MotanFrameworkUtil.getDefaultProtocolConfig();
                    } else {
                        throw new MotanFrameworkException(String.format("cann't find %s ProtocolConfig bean! export:%s", p, this.export), MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
                    }
                }
                protos.add(proto);
            }
            this.setProtocols(protos);
        }
        if (StringUtils.isEmpty((CharSequence)this.getExport()) || CollectionUtil.isEmpty((Collection)this.getProtocols())) {
            throw new MotanFrameworkException(String.format("%s ServiceConfig must config right export value!", this.getInterface().getName()), MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
    }

    private void checkAndConfigRegistry() {
        if (CollectionUtil.isEmpty((Collection)this.getRegistries()) && this.getBasicService() != null && !CollectionUtil.isEmpty((Collection)this.getBasicService().getRegistries())) {
            this.setRegistries(this.getBasicService().getRegistries());
        }
        if (CollectionUtil.isEmpty((Collection)this.getRegistries())) {
            for (String name : MotanNamespaceHandler.registryDefineNames) {
                RegistryConfig rc = (RegistryConfig)this.beanFactory.getBean(name, RegistryConfig.class);
                if (rc == null) continue;
                if (MotanNamespaceHandler.registryDefineNames.size() == 1) {
                    this.setRegistry(rc);
                    continue;
                }
                if (rc.isDefault() == null || !rc.isDefault().booleanValue()) continue;
                this.setRegistry(rc);
            }
        }
        if (CollectionUtil.isEmpty((Collection)this.getRegistries())) {
            this.setRegistry(MotanFrameworkUtil.getDefaultRegistryConfig());
        }
    }
}

