/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.Callbackable;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.Traceable;
import com.weibo.api.motan.rpc.TraceableContext;
import com.weibo.api.motan.util.LoggerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultResponse
implements Response,
Traceable,
Callbackable,
Serializable {
    private static final long serialVersionUID = 4281186647291615871L;
    private Object value;
    private Exception exception;
    private long requestId;
    private long processTime;
    private int timeout;
    private Map<String, String> attachments;
    private byte rpcProtocolVersion = RpcProtocolVersion.VERSION_1.getVersion();
    private int serializeNumber = 0;
    private List<Pair<Runnable, Executor>> taskList = new ArrayList<Pair<Runnable, Executor>>();
    private AtomicBoolean isFinished = new AtomicBoolean();
    private TraceableContext traceableContext = new TraceableContext();

    public DefaultResponse() {
    }

    public DefaultResponse(long requestId) {
        this.requestId = requestId;
    }

    public DefaultResponse(Response response) {
        this.value = response.getValue();
        this.exception = response.getException();
        this.requestId = response.getRequestId();
        this.processTime = response.getProcessTime();
        this.timeout = response.getTimeout();
        this.rpcProtocolVersion = response.getRpcProtocolVersion();
        this.serializeNumber = response.getSerializeNumber();
        this.attachments = response.getAttachments();
        if (response instanceof Traceable) {
            this.traceableContext.setReceiveTime(((Traceable)((Object)response)).getTraceableContext().getReceiveTime());
            this.traceableContext.traceInfoMap = ((Traceable)((Object)response)).getTraceableContext().getTraceInfoMap();
        }
    }

    public DefaultResponse(Object value) {
        this.value = value;
    }

    public DefaultResponse(Object value, long requestId) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        if (this.exception != null) {
            throw this.exception instanceof RuntimeException ? (RuntimeException)this.exception : new MotanServiceException(this.exception.getMessage(), this.exception);
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public long getProcessTime() {
        return this.processTime;
    }

    @Override
    public void setProcessTime(long time) {
        this.processTime = time;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.attachments != null ? this.attachments : Collections.emptyMap();
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void setAttachment(String key, String value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, String>();
        }
        this.attachments.put(key, value);
    }

    @Override
    public byte getRpcProtocolVersion() {
        return this.rpcProtocolVersion;
    }

    @Override
    public void setRpcProtocolVersion(byte rpcProtocolVersion) {
        this.rpcProtocolVersion = rpcProtocolVersion;
    }

    @Override
    public void setSerializeNumber(int number) {
        this.serializeNumber = number;
    }

    @Override
    public int getSerializeNumber() {
        return this.serializeNumber;
    }

    @Override
    public void addFinishCallback(Runnable runnable, Executor executor) {
        if (!this.isFinished.get()) {
            this.taskList.add((Pair<Runnable, Executor>)Pair.of((Object)runnable, (Object)executor));
        }
    }

    @Override
    public void onFinish() {
        if (!this.isFinished.compareAndSet(false, true)) {
            return;
        }
        for (Pair<Runnable, Executor> pair : this.taskList) {
            Runnable runnable = (Runnable)pair.getKey();
            Executor executor = (Executor)pair.getValue();
            if (executor == null) {
                runnable.run();
                continue;
            }
            try {
                executor.execute(runnable);
            }
            catch (Exception e) {
                LoggerUtil.error("Callbackable response exec callback task error, e: ", e);
            }
        }
    }

    @Override
    public TraceableContext getTraceableContext() {
        return this.traceableContext;
    }
}

